/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrumentType;
import ch.dvbern.tax.ge.pp.ictax.ICTAXDataBase;
import ch.dvbern.tax.ge.pp.ictax.ICTAXDatabaseUnavailableException;
import ch.dvbern.tax.ge.pp.ictax.ICTAXUtils;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValorSearchHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ValorSearchHelper.class);
    private static final int FISCAL_YEAR = ApplicationConfig.getInstance().getJahr();
    private static final String CHF_CURRENCY = "CHF";
    private final DvbTaxSession session;

    public ValorSearchHelper(@Nonnull DvbTaxSession session) {
        if (session == null) {
            throw new NullPointerException("Session cannot be null.");
        }
        this.session = session;
    }

    public void displayInstrument(String dataModelKey, DvbTaxInstrument instrument, BigDecimal exchangeRateYearEnd) {
        String valorDTOXML;
        for (String lmk : new String[]{"Titres.Divers.DiversTable.Titres.Designation", "Titres.Divers.DiversTable.Titres.RevenusAvecIAInput", "Titres.Divers.DiversTable.Titres.RevenusSansIAInput", "Titres.Divers.DiversTable.Titres.FortuneImposableInput", "Titres.Divers.DiversTable.Titres.InteretsEchusInput"}) {
            String dmk = EngineUtil.mergeModelKey((String)lmk, (String)dataModelKey);
            this.session.update(Collections.singletonMap(dmk, SharedUtils.createTouchedItem(null)), true);
        }
        try {
            StringWriter sw = new StringWriter();
            ICTAXUtils.marshall(instrument, sw);
            valorDTOXML = sw.toString();
        }
        catch (JAXBException e) {
            throw new InternalFailureException("Failed to marshall instrument.", e);
        }
        String cotationDmk = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.Cotation", (String)dataModelKey);
        String valorNumberDmk = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.NoValeur", (String)dataModelKey);
        String valorDTODmk = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.ValorDTO", (String)dataModelKey);
        String exchangeRateDmk = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.ExchangeRate", (String)dataModelKey);
        this.session.update(Collections.singletonMap(cotationDmk, SharedUtils.createTouchedItem(Boolean.TRUE)), true);
        this.session.update(Collections.singletonMap(valorNumberDmk, SharedUtils.createTouchedItem(String.valueOf(instrument.getValorNumber()))), true);
        this.session.update(Collections.singletonMap(valorDTODmk, SharedUtils.createTouchedItem(valorDTOXML)), true);
        this.session.update(Collections.singletonMap(exchangeRateDmk, SharedUtils.createTouchedItem(exchangeRateYearEnd)), true);
        this.done();
    }

    public void searchValorNumber(String dataModelKey) {
        DvbTaxInstrument instrument;
        Map dataModel = this.session.getDataModel();
        String valorNumberDmk = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.NoValeur", (String)dataModelKey);
        String valorNumber = (String)DataModelUtil.getValue((Map)dataModel, String.class, (String)valorNumberDmk);
        DvbTaxInstrumentType type = this.getInstrumentType(dataModelKey);
        if (valorNumber == null || type == null) {
            return;
        }
        LOG.info("Searching valor number {} of type {} in ICTAX database.", (Object)valorNumber, (Object)type);
        try {
            instrument = ICTAXDataBase.getInstance(FISCAL_YEAR).lookupNumber(type, valorNumber);
        }
        catch (ICTAXDatabaseUnavailableException e) {
            LOG.debug("EWS unavailable.", (Throwable)e);
            this.displayErrorMessage("error.valor.number.database.unavailable");
            return;
        }
        if (instrument == null) {
            this.displayErrorMessage("error.valor.number.not.found");
            return;
        }
        BigDecimal exchangeRateYearEnd = this.getExchangeRateEndOfYear(instrument.getCurrency());
        if (exchangeRateYearEnd == null) {
            return;
        }
        this.displayInstrument(dataModelKey, instrument, exchangeRateYearEnd);
    }

    @Nullable
    public BigDecimal getExchangeRateEndOfYear(@Nonnull String currency) {
        BigDecimal exchangeRateYearEnd;
        if (currency == null) {
            throw new NullPointerException("Currency cannot be null.");
        }
        try {
            exchangeRateYearEnd = !CHF_CURRENCY.equals(currency) ? ICTAXDataBase.getInstance(FISCAL_YEAR).getExchangeRateYearEnd(currency) : BigDecimal.ONE;
        }
        catch (ICTAXDatabaseUnavailableException e) {
            LOG.debug("EWS unavailable.", (Throwable)e);
            this.displayErrorMessage("error.valor.number.database.unavailable");
            return null;
        }
        return exchangeRateYearEnd;
    }

    public List<DvbTaxInstrument> searchInstruments(String dataModelKey, String name) {
        DvbTaxInstrumentType type = this.getInstrumentType(dataModelKey);
        if (type == null) {
            return Collections.emptyList();
        }
        return this.searchInstruments(type, name);
    }

    public List<DvbTaxInstrument> searchInstruments(DvbTaxInstrumentType type, String name) {
        List<DvbTaxInstrument> instruments;
        if (type == null) {
            throw new NullPointerException("Instrument type cannot be null.");
        }
        try {
            instruments = ICTAXDataBase.getInstance(FISCAL_YEAR).lookup(type, name);
        }
        catch (ICTAXDatabaseUnavailableException e) {
            LOG.debug("EWS unavailable.", (Throwable)e);
            this.displayErrorMessage("error.valor.number.database.unavailable");
            return Collections.emptyList();
        }
        if (instruments.isEmpty()) {
            this.displayErrorMessage("error.valor.no.result.found");
        }
        return instruments;
    }

    @Nullable
    public DvbTaxInstrumentType getInstrumentType(String dataModelKey) {
        String typeTitreDmk = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.TypeDeFortune", (String)dataModelKey);
        String typeStr = (String)DataModelUtil.getValue((Map)this.session.getDataModel(), String.class, (String)typeTitreDmk);
        DvbTaxInstrumentType instrumentType = null;
        if (typeStr != null) {
            GeConstants.TypeDeFortune typeFortune = GeConstants.TypeDeFortune.valueOf(typeStr);
            instrumentType = typeFortune.getInstrumentType();
        }
        return instrumentType;
    }

    protected abstract void done();

    protected abstract void displayErrorMessage(String var1);
}

