/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.admin.estv.xmlns.ictax._1_2_0.kursliste.Instrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrumentType;
import ch.dvbern.tax.ge.pp.ictax.PaymentBond;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;

public class InstrumentBond
extends DvbTaxInstrument {
    private final List<PaymentBond> payments;
    private final BigDecimal interestRate;
    private final LocalDate redemptionDate;
    private final boolean iup;

    InstrumentBond(ch.admin.estv.xmlns.ictax._1_2_0.kursliste.InstrumentBond bond) {
        super(DvbTaxInstrumentType.BOND, (Instrument)bond, bond.getTaxValue(), bond.getNominalAmount(), bond.getInstitutionIdentifier(), bond.getInstitutionIdentifierAppendix(), bond.getCountry(), bond.getCurrency(), bond.getLegend());
        this.interestRate = bond.getInterestRate();
        this.redemptionDate = bond.getRedemptionDate();
        this.iup = bond.isIup();
        List payments = bond.getPayment();
        ArrayList<PaymentBond> tmp = new ArrayList<PaymentBond>(payments.size());
        for (ch.admin.estv.xmlns.ictax._1_2_0.kursliste.PaymentBond payment : payments) {
            if (payment.isDeleted()) continue;
            tmp.add(new PaymentBond(payment));
        }
        this.payments = Collections.unmodifiableList(tmp);
    }

    @Nonnull
    public List<PaymentBond> getPayments() {
        return this.payments;
    }

    @Nullable
    public BigDecimal getInterestRate() {
        return this.interestRate;
    }

    @Nullable
    public LocalDate getRedemptionDate() {
        return this.redemptionDate;
    }

    public boolean isIup() {
        return this.iup;
    }
}

