/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrumentType;
import ch.dvbern.tax.ge.pp.ictax.ICTAXDataBaseProvider;
import ch.dvbern.tax.ge.pp.ictax.ICTAXDatabaseUnavailableException;
import java.math.BigDecimal;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ICTAXDataBase {
    public static final String NAMESPACE = "http://xmlns.estv.admin.ch/ictax/1.2.0/kursliste";
    private static final ConcurrentMap<Integer, ICTAXDataBase> DATABASES = new ConcurrentHashMap<Integer, ICTAXDataBase>();
    private final int year;

    protected ICTAXDataBase(int year) {
        this.year = year;
    }

    @Nonnull
    public static ICTAXDataBase getInstance(int year) {
        ServiceLoader<ICTAXDataBaseProvider> providers = ServiceLoader.load(ICTAXDataBaseProvider.class);
        for (ICTAXDataBaseProvider provider : providers) {
            ICTAXDataBase db = provider.getICTAXDataBase(year);
            if (db == null) continue;
            return db;
        }
        throw new ICTAXDatabaseUnavailableException("No provider found for year: " + year);
    }

    public abstract List<DvbTaxInstrument> lookup(@Nonnull DvbTaxInstrumentType var1, @Nonnull String var2);

    public abstract DvbTaxInstrument lookupNumber(@Nonnull DvbTaxInstrumentType var1, @Nonnull String var2);

    @Nullable
    public abstract BigDecimal getExchangeRateYearEnd(@Nonnull String var1);

    public int getYear() {
        return this.year;
    }
}

