/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.admin.estv.xmlns.ictax._1_2_0.kursliste.Instrument;
import ch.admin.estv.xmlns.ictax._1_2_0.kursliste.InstrumentType;
import ch.admin.estv.xmlns.ictax._1_2_0.kursliste.Legend;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrumentType;
import ch.dvbern.tax.ge.pp.ictax.Sign;
import ch.dvbern.tax.ge.pp.ictax.TaxValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class DvbTaxInstrument {
    private final Instrument ictaxInstrument;
    private final DvbTaxInstrumentType type;
    private final long valorNumber;
    private final String isin;
    private final TaxValue taxValue;
    private final BigDecimal nominalAmount;
    private final InstrumentType instrumentType;
    private final String institutionIdentifier;
    private final String institutionIdentifierAppendix;
    private final String country;
    private final String currency;
    private final Sign sign;
    private final List<String> legends;

    DvbTaxInstrument(DvbTaxInstrumentType type, Instrument ictaxInstrument, ch.admin.estv.xmlns.ictax._1_2_0.kursliste.TaxValue taxValue, BigDecimal nominalAmount, String institutionIdentifier, String institutionIdentifierAppendix, String country, String currency, List<Legend> legends) {
        this.type = type;
        this.ictaxInstrument = ictaxInstrument;
        this.valorNumber = ictaxInstrument.getValorNumber();
        this.isin = ictaxInstrument.getIsin();
        this.nominalAmount = nominalAmount;
        this.taxValue = taxValue.isDeleted() ? null : new TaxValue(taxValue);
        this.instrumentType = ictaxInstrument.getInstrumentType();
        String sign = ictaxInstrument.getSign();
        this.sign = Sign.parse(sign);
        this.institutionIdentifier = institutionIdentifier;
        this.institutionIdentifierAppendix = institutionIdentifierAppendix;
        this.country = country;
        this.currency = currency;
        ArrayList<String> legendsTmp = new ArrayList<String>(legends.size());
        for (Legend legend : legends) {
            if (legend.isDeleted()) continue;
            legendsTmp.add(legend.getText());
        }
        this.legends = Collections.unmodifiableList(legendsTmp);
    }

    public long getValorNumber() {
        return this.valorNumber;
    }

    @Nullable
    public String getIsin() {
        return this.isin;
    }

    @Nullable
    public TaxValue getTaxValue() {
        return this.taxValue;
    }

    @Nonnull
    public BigDecimal getNominalAmount() {
        return this.nominalAmount;
    }

    @Nonnull
    public String getInstitutionIdentifier() {
        return this.institutionIdentifier;
    }

    @Nullable
    public String getInstitutionIdentifierAppendix() {
        return this.institutionIdentifierAppendix;
    }

    public DvbTaxInstrumentType getType() {
        return this.type;
    }

    @Nonnull
    public InstrumentType getInstrumentType() {
        return this.instrumentType;
    }

    @Nonnull
    public String getCountry() {
        return this.country;
    }

    @Nonnull
    public String getCurrency() {
        return this.currency;
    }

    @Nullable
    public Sign getSign() {
        return this.sign;
    }

    @Nonnull
    public List<String> getLegends() {
        return this.legends;
    }

    Instrument getIctaxInstrument() {
        return this.ictaxInstrument;
    }
}

