/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.comparators.WizardTableComparatorProvider;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Col;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Table;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.Float2Converter;
import ch.dvbern.tax.ge.pp.utils.RepartitionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class WizardRepartitionTable
extends Table {
    private static final String HEADER_PREFIX = "title.col.recapitulation.repartition.";

    public WizardRepartitionTable(String name, String header, List<LabelAddOn> headerAddOns, String stateKey, List<ColDef> coldefs, Help help, List<Col> cols, String sort, boolean editable, boolean addRowEnabled, boolean deleteRowEnabled, String excludeKey, String align, int colspan, int rowspan, boolean readonly, String viewId, int rowsPerPage, boolean filter, boolean statusFilter, boolean showPrintRow, String buttonPlusText, String noEntryText, WizardTableComparatorProvider comparator) {
        super(name, header, headerAddOns, stateKey, coldefs, help, cols, sort, editable, addRowEnabled, deleteRowEnabled, excludeKey, align, colspan, rowspan, readonly, viewId, rowsPerPage, filter, statusFilter, showPrintRow, buttonPlusText, noEntryText, comparator, null, null, "", "", "", false);
    }

    public static class XMLFactory
    implements ElementParser {
        @Nonnull
        public ClassObjectPair parse(@Nonnull Element element, @Nonnull ParserFactory factory) throws ElementParserException {
            DataResource dataResource = null;
            List elements = element.getChildren();
            ArrayList<ColDef> coldefs = new ArrayList<ColDef>();
            ArrayList<Col> cols = new ArrayList<Col>();
            ArrayList<LabelAddOn> labelAddOns = new ArrayList<LabelAddOn>();
            Help help = null;
            WizardTableComparatorProvider comparator = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Help) {
                        help = (Help)ref;
                        continue;
                    }
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add((LabelAddOn)ref);
                        continue;
                    }
                    if (ref instanceof ColDef) {
                        coldefs.add((ColDef)ref);
                        continue;
                    }
                    if (ref instanceof Col) {
                        cols.add((Col)ref);
                        continue;
                    }
                    if (ref instanceof DataResource) {
                        dataResource = (DataResource)ref;
                        continue;
                    }
                    if (ref instanceof WizardTableComparatorProvider) {
                        comparator = (WizardTableComparatorProvider)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (labelAddOns.size() == 0 && element.getAttribute("header-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("header-add-on")));
            }
            if (labelAddOns.size() == 0) {
                labelAddOns = null;
            }
            if (element.getAttribute("help") != null) {
                help = new Help(element.getAttributeValue("help"));
            }
            int rowsPerPage = 0;
            if (element.getAttribute("rows-per-page") != null) {
                rowsPerPage = Integer.parseInt(element.getAttribute("rows-per-page"));
            }
            if (dataResource != null) {
                String listname = element.getAttributeValue("list-name");
                String listParam = element.getAttributeValue("list-name-param");
                ArrayList<ColDef> newColdefs = new ArrayList<ColDef>();
                ArrayList<Col> newCols = new ArrayList<Col>();
                Map<String, Object> repartitionItems = RepartitionUtil.getRepartitionItemsAsLogicModelNames(dataResource, listname, listParam, null);
                for (String nom : repartitionItems.keySet()) {
                    String stateKey = element.getAttributeValue("state-item-prefix") + nom;
                    ColDef colDefCommune = new ColDef("100", LMK.parse((String)stateKey), WizardRepartitionTable.HEADER_PREFIX + nom, new ArrayList(), true, null, null);
                    ColDef colDefPart = new ColDef("50", LMK.parse((String)stateKey), "title.col.recapitulation.repartition.Part", new ArrayList(), true, null, null);
                    Float2Converter converter = new Float2Converter(14, false);
                    Col colCommune = new Col(0, element.getAttributeValue("name") + "." + nom, Boolean.valueOf(true), "right", null, null, Boolean.valueOf(false), (AbstractConverter)converter, null, null, false);
                    Col colPart = new Col(0, element.getAttributeValue("name") + "." + nom + "Part", Boolean.valueOf(true), "right", null, null, Boolean.valueOf(false), (AbstractConverter)converter, null, null, false);
                    newColdefs.add(colDefCommune);
                    newColdefs.add(colDefPart);
                    newCols.add(colCommune);
                    newCols.add(colPart);
                }
                coldefs.addAll(newColdefs);
                cols.addAll(newCols);
            }
            for (int i = 0; i < cols.size(); ++i) {
                if (coldefs.size() <= i) continue;
                ((ColDef)coldefs.get(i)).setAlign(((Col)cols.get(i)).getAlign());
            }
            WizardRepartitionTable result = new WizardRepartitionTable(element.getAttributeValue("name"), element.getAttributeValue("header"), labelAddOns, element.getAttributeValue("state"), coldefs.size() > 0 ? coldefs : null, help, cols.size() > 0 ? cols : null, element.getAttributeValue("sort"), WizardDisplayUtil.getBoolean((String)element.getAttributeValue("editable"), (boolean)false), WizardDisplayUtil.getBoolean((String)element.getAttributeValue("delete-rows"), (boolean)true), WizardDisplayUtil.getBoolean((String)element.getAttributeValue("add-rows"), (boolean)true), element.getAttributeValue("exclude-ref"), WizardDisplayUtil.getString((String)element.getAttributeValue("align"), (String)"fill"), WizardDisplayUtil.getInt((String)element.getAttributeValue("colspan"), (int)1), WizardDisplayUtil.getInt((String)element.getAttributeValue("rowspan"), (int)1), WizardDisplayUtil.getBoolean((String)element.getAttributeValue("readonly"), (boolean)false), element.getAttributeValue("viewId"), rowsPerPage, WizardDisplayUtil.getBoolean((String)element.getAttributeValue("filter"), (boolean)false), WizardDisplayUtil.getBoolean((String)element.getAttributeValue("statusFilter"), (boolean)false), WizardDisplayUtil.getBoolean((String)element.getAttributeValue("showPrintRow"), (boolean)false), element.getAttributeValue("button-plus-text"), element.getAttributeValue("no-entry-text"), comparator);
            return new ClassObjectPair(WizardRepartitionTable.class, (Object)result);
        }
    }
}

