/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.ictax.ICTAXUtils;
import java.util.Map;
import javax.annotation.Nonnull;

public class ValorNumberValidator
implements Validator {
    public void initializeReferences(@Nonnull Map<String, LogicModelItem> logicModel, @Nonnull LogicModelItem logicModelItem) throws InvalidModelException {
    }

    @Nonnull
    public ModelItemDTO validate(@Nonnull LogicModelItem.ProtectedMap dataModel, @Nonnull String dataModelKey, @Nonnull ModelItemDTO modelItemDTO) {
        String number = (String)modelItemDTO.getValue();
        String replaced = "";
        if (number != null && ICTAXUtils.isValorNumber(number.replace(" ", ""))) {
            replaced = number.replace(" ", "");
            modelItemDTO = modelItemDTO.clone((Object)replaced);
        }
        if (!(number == null || number.isEmpty() || ICTAXUtils.isValorNumber(number) || ICTAXUtils.isISIN(number))) {
            modelItemDTO = modelItemDTO.clone(4, "error.titres.valorNumber", null, 4);
        }
        return modelItemDTO;
    }
}

