/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.printer.utils;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.ge.pp.utils.DataModelUtil;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Map;

public final class PDFTableHelper {
    public static final String EMPTY_CELL = "";
    public static final Font FONT_TITLE_BOLD = new Font(1, 9.0f, 1);
    private static final String TABLE_NOT_NULL = "table cannot be null";
    private static final String COLSPAN_GREATER_0 = "colspan must be greater than 0";
    private static final String INVALID_NULL_ARGUMENT = "invalid null argument";
    private static final Font FONT_SUB_TITLE_BOLD = new Font(1, 8.0f, 1);
    private static final Font FONT_CONTENT_WHITE = new Font(1, 6.0f, 0, Color.WHITE);
    private static final Font FONT_CONTENT_BOLD = new Font(1, 6.0f, 1);
    private static final Font FONT_CONTENT_NORMAL = new Font(1, 6.0f, 0);
    private static final float DEFAULT_TABLE_SPACING = 15.0f;

    private PDFTableHelper() {
    }

    private static Object formatNumber(Object value) {
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(GeConstants.DEFAULT_LOCALE);
        dfs.setGroupingSeparator('\'');
        DecimalFormat df = new DecimalFormat("#,###", dfs);
        if (value == null) {
            return EMPTY_CELL;
        }
        if (value instanceof Long) {
            return df.format(value);
        }
        return value;
    }

    public static PdfPTable getPdfPTable(float[] headerWidths, int headerRows, boolean hasSpacingBefore) {
        return PDFTableHelper.getPdfPTable(headerWidths, headerRows, hasSpacingBefore, 100.0f);
    }

    public static PdfPTable getPdfPTable(float[] headerWidths, int headerRows, boolean hasSpacingBefore, float totalWidth) {
        PdfPTable table;
        block2: {
            table = PDFTableHelper.getPdfPTable(headerWidths.length, headerRows, hasSpacingBefore ? 15.0f : 0.0f, totalWidth);
            try {
                table.setWidths(headerWidths);
            }
            catch (DocumentException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"incorrect column count");
            }
        }
        return table;
    }

    public static PdfPTable getPdfPTable(int colCount, int headerRows, float spacingBefore, float totalWidth) {
        PdfPTable table = new PdfPTable(colCount);
        table.setWidthPercentage(100.0f);
        table.setTotalWidth(totalWidth);
        table.setHeaderRows(headerRows);
        table.getDefaultCell().setPadding(0.0f);
        table.getDefaultCell().setBorder(0);
        table.setSpacingBefore(spacingBefore);
        return table;
    }

    public static void addPdfCellTitle1(PdfPTable table, String value, int horizontalAlignment, int verticalAlignment, int colspan) {
        if (table == null || value == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        if (colspan < 1) {
            throw new IllegalArgumentException(COLSPAN_GREATER_0);
        }
        Paragraph phrase = new Paragraph(value, FONT_TITLE_BOLD);
        PdfPCell cell = PDFTableHelper.createPdfCell(horizontalAlignment, verticalAlignment, (Phrase)phrase, false);
        cell.setColspan(colspan);
        table.addCell(cell);
    }

    public static void addPdfCellTitle2(PdfPTable table, String value, int horizontalAlignment, int verticalAlignment) {
        if (table == null || value == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        Paragraph phrase = new Paragraph(value, FONT_SUB_TITLE_BOLD);
        PdfPCell cell = PDFTableHelper.createPdfCell(horizontalAlignment, verticalAlignment, (Phrase)phrase, false);
        table.addCell(cell);
    }

    public static void addPdfCellTitle3(PdfPTable table, String value, int horizontalAlignment, int verticalAlignment) {
        if (table == null || value == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        Paragraph phrase = new Paragraph(value, FONT_CONTENT_WHITE);
        PdfPCell cell = PDFTableHelper.createPdfCell(horizontalAlignment, verticalAlignment, (Phrase)phrase, true);
        cell.setBackgroundColor(Color.BLACK);
        table.addCell(cell);
    }

    public static void addPdfCellColumnHeader(PdfPTable table, String value, int horizontalAlignment, int verticalAlignment) {
        if (table == null || value == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        Paragraph phrase = new Paragraph(value, FONT_CONTENT_NORMAL);
        PdfPCell cell = PDFTableHelper.createPdfCell(horizontalAlignment, verticalAlignment, (Phrase)phrase, true);
        cell.setBorderColor(Color.GRAY);
        table.addCell(cell);
    }

    public static void addPdfCellEmpty(PdfPTable table) {
        Paragraph phrase = new Paragraph(EMPTY_CELL, FONT_TITLE_BOLD);
        PdfPCell cell = PDFTableHelper.createPdfCell(0, 5, (Phrase)phrase, false);
        table.addCell(cell);
    }

    public static void addPdfCellEmpty(PdfPTable table, int colspan) {
        if (table == null) {
            throw new NullPointerException(TABLE_NOT_NULL);
        }
        if (colspan < 1) {
            throw new IllegalArgumentException(COLSPAN_GREATER_0);
        }
        Paragraph phrase = new Paragraph(EMPTY_CELL, FONT_TITLE_BOLD);
        PdfPCell cell = PDFTableHelper.createPdfCell(0, 5, (Phrase)phrase, false);
        cell.setColspan(colspan);
        table.addCell(cell);
    }

    public static void addPdfBlankCell(PdfPTable table) {
        if (table == null) {
            throw new NullPointerException(TABLE_NOT_NULL);
        }
        Paragraph phrase = new Paragraph(EMPTY_CELL, FONT_TITLE_BOLD);
        PdfPCell cell = PDFTableHelper.createPdfCell(0, 5, (Phrase)phrase, false);
        cell.setBorder(0);
        table.addCell(cell);
    }

    public static PdfPCell createPdfCell(int horizontalAlignment, int verticalAlignment, Phrase phrase, boolean withBorder) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setHorizontalAlignment(horizontalAlignment);
        cell.setVerticalAlignment(verticalAlignment);
        cell.setPaddingRight(2.0f);
        cell.setPaddingBottom(2.0f);
        if (!withBorder) {
            cell.setBorder(0);
        }
        return cell;
    }

    private static void addPdfCell(PdfPTable table, Object value, int horizontalAlignment, int verticalAlignment, int border, int colspan, Color backgroundColor, boolean bold, boolean borderColorGray) {
        Paragraph text = bold ? new Paragraph(String.valueOf(value), FONT_CONTENT_BOLD) : new Paragraph(String.valueOf(value), FONT_CONTENT_NORMAL);
        PdfPCell cell = new PdfPCell((Phrase)text);
        cell.setPaddingRight(2.0f);
        cell.setPaddingBottom(2.0f);
        cell.setBorder(border);
        cell.setHorizontalAlignment(horizontalAlignment);
        cell.setVerticalAlignment(verticalAlignment);
        if (backgroundColor != null) {
            cell.setBackgroundColor(backgroundColor);
        }
        if (colspan > 0) {
            cell.setColspan(colspan);
        }
        if (borderColorGray) {
            cell.setBorderColor(Color.GRAY);
        }
        table.addCell(cell);
    }

    public static void addPdfCellText(PdfPTable table, Object value) {
        if (table == null || value == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        PDFTableHelper.addPdfCell(table, value, 2, 5, 0, 0, null, false, true);
    }

    public static void addPdfCellTextBottomBorder(PdfPTable table, Object value, boolean bold, boolean borderColorGray) {
        PDFTableHelper.addPdfCellTextBottomBorder(table, value, 1, bold, borderColorGray);
    }

    public static void addPdfCellTextBottomBorder(PdfPTable table, Object value, int colspan, boolean bold, boolean borderColorGray) {
        if (table == null || value == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        if (colspan < 1) {
            throw new IllegalArgumentException(COLSPAN_GREATER_0);
        }
        PDFTableHelper.addPdfCell(table, value, 0, 5, 2, colspan, null, bold, borderColorGray);
    }

    public static void addPdfCellTextNoBorder(PdfPTable table, Object value, int horizontalAlignment, int colspan, boolean bold) {
        if (table == null || value == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        if (colspan < 1) {
            throw new IllegalArgumentException(COLSPAN_GREATER_0);
        }
        PDFTableHelper.addPdfCell(table, value, horizontalAlignment, 5, 0, colspan, null, bold, false);
    }

    public static void addPdfCellText(DataModelUtil dmUtil, PdfPTable table, String basekey, String key) {
        if (dmUtil == null || table == null || basekey == null || key == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        Object value = dmUtil.getValue(basekey + "." + key);
        if (value == null) {
            value = EMPTY_CELL;
        }
        PDFTableHelper.addPdfCell(table, value, 0, 5, 15, 0, null, true, true);
    }

    public static void addPdfCellText(DataModelUtil dmUtil, PdfPTable table, String basekey, String key, DataResource dataResource, String keyDataResouce) {
        Map optionMap;
        if (dmUtil == null || table == null || basekey == null || key == null || dataResource == null || keyDataResouce == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        Object value = dmUtil.getValue(basekey + "." + key);
        value = value == null ? EMPTY_CELL : ((optionMap = dataResource.get(keyDataResouce, null, null)) != null && optionMap.containsKey(value) ? optionMap.get(value) : EMPTY_CELL);
        PDFTableHelper.addPdfCell(table, value, 0, 5, 15, 0, null, true, true);
    }

    public static void addPdfCellObservation(DataModelUtil dmUtil, PdfPTable table, String basekey, String key, int colspan) {
        if (dmUtil == null || table == null || basekey == null || key == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        if (colspan < 1) {
            throw new IllegalArgumentException(COLSPAN_GREATER_0);
        }
        Object value = dmUtil.getValue(basekey + "." + key);
        PDFTableHelper.addPdfCell(table, PDFTableHelper.formatNumber(value), 0, 5, 0, colspan, null, false, true);
    }

    public static void addPdfCellPercent(PdfPTable table, Number value) {
        if (table == null) {
            throw new NullPointerException(TABLE_NOT_NULL);
        }
        Object str = value == null ? EMPTY_CELL : value + "%";
        PDFTableHelper.addPdfCell(table, str, 2, 5, 15, 0, null, true, true);
    }

    public static void addPdfCellNumber(DataModelUtil dmUtil, PdfPTable table, String basekey, String key) {
        if (basekey == null || key == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        PDFTableHelper.addPdfCellNumber(dmUtil, table, basekey + "." + key);
    }

    public static void addPdfCellNumber(DataModelUtil dmUtil, PdfPTable table, String completeKey) {
        if (dmUtil == null || completeKey == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        PDFTableHelper.addPdfCellNumber(table, dmUtil.getNumber(completeKey, null));
    }

    public static void addPdfCellNumber(PdfPTable table, Number value) {
        if (table == null) {
            throw new NullPointerException(TABLE_NOT_NULL);
        }
        PDFTableHelper.addPdfCell(table, PDFTableHelper.formatNumber(value), 2, 5, 15, 0, null, true, true);
    }

    public static void addPdfCellBoolean(DataModelUtil dmUtil, PdfPTable table, String basekey, String key) {
        if (dmUtil == null || basekey == null || key == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        PDFTableHelper.addPdfCellBoolean(table, dmUtil.getBoolean(basekey + "." + key));
    }

    public static void addPdfCellBoolean(DataModelUtil dmUtil, PdfPTable table, String basekey, String key, String yesLabel, String noLabel) {
        if (dmUtil == null || basekey == null || key == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        PDFTableHelper.addPdfCellBoolean(table, dmUtil.getBoolean(basekey + "." + key), yesLabel, noLabel);
    }

    public static void addPdfCellBoolean(PdfPTable table, Boolean value) {
        PDFTableHelper.addPdfCellBoolean(table, value, "X", EMPTY_CELL);
    }

    private static void addPdfCellBoolean(PdfPTable table, Boolean value, String yesLabel, String noLabel) {
        if (table == null) {
            throw new NullPointerException(TABLE_NOT_NULL);
        }
        if (yesLabel == null) {
            throw new NullPointerException("Yes-label cannot be null.");
        }
        if (noLabel == null) {
            throw new NullPointerException("No-label cannot be null.");
        }
        String str = value == null || value == false ? noLabel : yesLabel;
        PDFTableHelper.addPdfCell(table, str, 1, 5, 15, 0, null, true, true);
    }

    public static void addPdfCellDate(DataModelUtil dmUtil, PdfPTable table, String basekey, String key) {
        if (dmUtil == null || table == null || basekey == null || key == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        Object value = dmUtil.getValue(basekey + "." + key);
        value = value == null ? EMPTY_CELL : new SimpleDateFormat("dd.MM.yyyy").format(value);
        PDFTableHelper.addPdfCell(table, value, 0, 5, 15, 0, null, true, true);
    }

    public static void addPdfTotalCellNumber(DataModelUtil dmUtil, PdfPTable table, String basekey, String key, boolean bold) {
        if (dmUtil == null || table == null || basekey == null || key == null) {
            throw new NullPointerException(INVALID_NULL_ARGUMENT);
        }
        Object value = dmUtil.getValue(basekey + "." + key);
        PDFTableHelper.addPdfCell(table, PDFTableHelper.formatNumber(value), 2, 5, 15, 0, Color.LIGHT_GRAY, bold, false);
    }
}

