/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.printer;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.transfer.dto.CustomPrinterDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.convert.ComboboxConverter;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.ge.pp.engine.comparators.TitresTableRowComparatorProvider;
import ch.dvbern.tax.ge.pp.engine.printer.utils.PDFTableHelper;
import ch.dvbern.tax.ge.pp.ictax.ICTAXUtils;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitresTransactionsPrinter
extends ExpertItemPrinter<CustomPrinterDTO> {
    private static final String INVALID_DMK = "Invalid data model.";
    private static final Font BODY_FONT = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)0);
    private static final Font BOLD_FONT = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)1);
    private Map<String, LogicModelItem> logicModel = null;
    private LogicModelItem.ProtectedMap dataModel = null;
    private static final Logger LOG = LoggerFactory.getLogger(TitresTransactionsPrinter.class);
    private static final ThreadLocal<DateFormat> DATE_FMT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("dd.MM", GeConstants.DEFAULT_LOCALE);
            df.setTimeZone(ApplicationConfig.TIMEZONE);
            return df;
        }
    };
    private static final ThreadLocal<NumberFormat> VARATION_FMT = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            DecimalFormat nf = new DecimalFormat("+#;-#", DecimalFormatSymbols.getInstance(GeConstants.DEFAULT_LOCALE));
            ((NumberFormat)nf).setMaximumFractionDigits(3);
            return nf;
        }
    };
    private static final ThreadLocal<NumberFormat> NUMBER_FMT = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat nf = NumberFormat.getInstance(GeConstants.DEFAULT_LOCALE);
            nf.setMaximumFractionDigits(3);
            return nf;
        }
    };

    protected void initalize(@Nonnull CustomPrinterDTO item) {
        this.dataModel = item.getDataModel();
        this.logicModel = item.getLogicModel();
    }

    protected void printInternal(float xOffset, float yOffset) throws FormRendererException {
        assert (this.logicModel != null && this.dataModel != null);
        try {
            this.printInternal();
        }
        catch (DocumentException e) {
            throw new FormRendererException("Failed to render transaction list.", (Throwable)e);
        }
    }

    private void printInternal() throws DocumentException {
        Object rowDMK;
        Set indexes = (Set)DataModelUtil.getValue((Map)this.dataModel, Set.class, (String)"Titres.Divers.DiversTable");
        if (indexes == null || indexes.isEmpty()) {
            return;
        }
        VariationComparator cmp = new VariationComparator();
        ArrayList<TitresTableRowComparatorProvider.Entry> entries = new ArrayList<TitresTableRowComparatorProvider.Entry>(indexes.size());
        for (String index : indexes) {
            rowDMK = "Titres.Divers.DiversTable." + index;
            String transactionTableDMK = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.TransactionsTable", (String)rowDMK);
            Set transactionIndexes = (Set)DataModelUtil.getValue((Map)this.dataModel, Set.class, (String)transactionTableDMK);
            if (transactionIndexes == null || transactionIndexes.isEmpty()) continue;
            entries.add(TitresTableRowComparatorProvider.Entry.load((Map<String, ModelItemDTO>)this.dataModel, (String)rowDMK));
        }
        if (entries.isEmpty()) {
            return;
        }
        Collections.sort(entries);
        for (TitresTableRowComparatorProvider.Entry entry : entries) {
            rowDMK = entry.getRowDMK();
            this.getDocumentContext().getDocument().add((Element)new Phrase(6.0f, "\n", BODY_FONT));
            String type = this.renderSelect("Titres.Divers.DiversTable.TypeDeFortune", (String)rowDMK);
            String designation = this.getString("Titres.Divers.DiversTable.Designation", (String)rowDMK);
            Object noValeur = this.getString("Titres.Divers.DiversTable.Titres.NoValeur", (String)rowDMK);
            if (noValeur != null) {
                if (ICTAXUtils.isISIN((String)noValeur)) {
                    noValeur = "ISIN " + (String)noValeur;
                } else {
                    assert (ICTAXUtils.isValorNumber((String)noValeur));
                    noValeur = "NV " + (String)noValeur;
                }
            } else {
                noValeur = "";
            }
            Double valeurNominal = this.getDouble("Titres.Divers.DiversTable.Titres.ValeurNominaleInitial", (String)rowDMK);
            assert (valeurNominal != null) : "Invalid data model.";
            Object isMarriedOrChildObject = this.getValue("Stammdaten.SituationContribuable.IsMarriedOrHasChild", (String)rowDMK, Object.class);
            boolean isMarriedOrChild = isMarriedOrChildObject != null ? (Boolean)isMarriedOrChildObject : false;
            String appartenance = isMarriedOrChild ? this.renderSelect("Titres.Divers.DiversTable.Titres.Appartenance", (String)rowDMK) : this.renderSelect("Titres.Divers.DiversTable.Titres.AppartenanceSingle", (String)rowDMK);
            PdfPTable pdfTable = PDFTableHelper.getPdfPTable(new float[]{0.15f, 0.19f, 0.47f, 0.19f}, 2, false);
            Phrase header = new Phrase();
            header.setFont(BODY_FONT);
            header.add(type + " - ");
            header.add((Element)new Chunk(designation, BOLD_FONT));
            header.add(" - " + (String)noValeur + " - " + appartenance);
            PdfPCell cell = new PdfPCell(header);
            cell.setBorder(0);
            cell.setColspan(4);
            pdfTable.addCell(cell);
            pdfTable.addCell(this.newLabelCell("label.printer.titres.transactions.date"));
            pdfTable.addCell(this.newLabelCell("label.printer.titres.transactions.nombrePart"));
            pdfTable.addCell(this.newLabelCell("label.printer.titres.transactions.mouvements"));
            pdfTable.addCell(this.newLabelCell("label.printer.titres.transactions.solde"));
            pdfTable.addCell(this.newCell(this.renderDate("Stammdaten.Declaration.DebutPeriodeTaxation", (String)rowDMK)));
            pdfTable.addCell(this.newGrayedCell());
            pdfTable.addCell(this.newGrayedCell());
            pdfTable.addCell(this.newCell(this.renderNumber(valeurNominal), 2));
            String transactionTableDMK = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.TransactionsTable", (String)rowDMK);
            Set transactionIndexes = (Set)DataModelUtil.getValue((Map)this.dataModel, Set.class, (String)transactionTableDMK);
            assert (transactionIndexes != null && !transactionIndexes.isEmpty()) : "Empty or null transactions table should already have been filtered.";
            ArrayList<Variation> variations = new ArrayList<Variation>(transactionIndexes.size());
            for (String transactionIndex : transactionIndexes) {
                String transactionRowDMK = transactionTableDMK + "." + transactionIndex;
                variations.add(new Variation(transactionRowDMK));
            }
            Collections.sort(variations, cmp);
            for (Variation variation : variations) {
                pdfTable.addCell(this.newCell(this.renderDate(variation.date)));
                StringBuilder description = new StringBuilder(variation.genre);
                if (variation.genreAutre != null) {
                    description.append(": ");
                    description.append(variation.genreAutre);
                }
                pdfTable.addCell(this.newCell(this.renderVariation(variation.montant)));
                pdfTable.addCell(this.newCell(description.toString(), 0));
                valeurNominal = valeurNominal + variation.montant;
                pdfTable.addCell(this.newCell(this.renderNumber(valeurNominal), 2));
            }
            pdfTable.addCell(this.newCell(this.renderDate("Stammdaten.Declaration.FinPeriodeTaxation", (String)rowDMK)));
            pdfTable.addCell(this.newGrayedCell());
            pdfTable.addCell(this.newGrayedCell());
            pdfTable.addCell(this.newCell(this.renderNumber(valeurNominal), 2));
            this.getDocumentContext().getDocument().add((Element)pdfTable);
        }
    }

    @Nonnull
    private PdfPCell newCell(@Nonnull String text) {
        return this.newCell(text, 1);
    }

    @Nonnull
    private PdfPCell newCell(@Nonnull String text, int align) {
        PdfPCell cell = new PdfPCell();
        Phrase phrase = new Phrase(text, BODY_FONT);
        cell.setPhrase(phrase);
        cell.setHorizontalAlignment(align);
        return cell;
    }

    private PdfPCell newLabelCell(String key) {
        return this.newCell(this.getDocumentContext().getGlobalConverterContext().getLocalizationHelper().translate(key, new Object[0]));
    }

    private PdfPCell newGrayedCell() {
        PdfPCell cell = new PdfPCell();
        cell.setGrayFill(0.9f);
        return cell;
    }

    @Nullable
    private Double getDouble(@Nonnull String lmk, @Nonnull String rowDMK) {
        return this.getValue(lmk, rowDMK, Double.class);
    }

    @Nullable
    private BigDecimal getBigDecimal(@Nonnull String lmk, @Nonnull String rowDMK) {
        return this.getValue(lmk, rowDMK, BigDecimal.class);
    }

    @Nullable
    private Date getDate(@Nonnull String lmk, @Nonnull String rowDMK) {
        return this.getValue(lmk, rowDMK, Date.class);
    }

    @Nullable
    private String getString(@Nonnull String lmk, @Nonnull String rowDMK) {
        return this.getValue(lmk, rowDMK, String.class);
    }

    @Nullable
    private Boolean getBoolean(@Nonnull String lmk, @Nonnull String rowDMK) {
        return this.getValue(lmk, rowDMK, Boolean.class);
    }

    @Nullable
    private <T> T getValue(@Nonnull String lmk, @Nonnull String rowDMK, @Nonnull Class<T> type) {
        String dmk = EngineUtil.mergeModelKey((String)lmk, (String)rowDMK);
        return (T)DataModelUtil.getValue((Map)this.dataModel, type, (String)dmk);
    }

    @Nonnull
    private String renderNumber(@Nullable Number value) {
        return value != null ? NUMBER_FMT.get().format(value) : "";
    }

    @Nonnull
    private String renderVariation(@Nullable Number value) {
        return value != null ? VARATION_FMT.get().format(value) : "";
    }

    @Nonnull
    private String renderDate(@Nonnull String lmk, @Nonnull String rowDMK) {
        return this.renderDate(this.getDate(lmk, rowDMK));
    }

    @Nonnull
    private String renderDate(@Nullable Date value) {
        return value != null ? DATE_FMT.get().format(value) : "";
    }

    @Nullable
    private String renderSelect(@Nonnull String lmk, @Nonnull String rowDMK) {
        String dmk = EngineUtil.mergeModelKey((String)lmk, (String)rowDMK);
        Object value = this.getValue(lmk, rowDMK, Object.class);
        Select item = (Select)this.logicModel.get(lmk);
        return new ComboboxConverter(false).getRenderedValue(value, false, item.getOptionItems(this.dataModel, dmk), this.getGlobalConverterContext().withDmk(dmk));
    }

    private static class VariationComparator
    implements Comparator<Variation>,
    Serializable {
        private static final long serialVersionUID = 5250000579351024702L;

        private VariationComparator() {
        }

        @Override
        public int compare(Variation o1, Variation o2) {
            return o1.date.compareTo(o2.date);
        }
    }

    private class Variation {
        @Nonnull
        private final Date date;
        @Nonnull
        private final Double montant;
        @Nonnull
        private final String genre;
        @Nullable
        private final String genreAutre;
        @Nullable
        private final boolean sousJacentVenduJustificatif;
        @Nullable
        private final boolean plusValue;
        @Nullable
        private final boolean methodeFixationPrix;
        @Nullable
        private final boolean genreVR;
        @Nullable
        private final boolean genrePAR;

        Variation(String rowDMK) {
            this.date = Objects.requireNonNull(TitresTransactionsPrinter.this.getDate("Titres.Divers.DiversTable.Titres.TransactionsTable.Date", rowDMK), TitresTransactionsPrinter.INVALID_DMK);
            this.montant = Objects.requireNonNull(TitresTransactionsPrinter.this.getDouble("Titres.Divers.DiversTable.Titres.TransactionsTable.MutationNombreDeParts", rowDMK), TitresTransactionsPrinter.INVALID_DMK);
            this.sousJacentVenduJustificatif = Boolean.TRUE.equals(TitresTransactionsPrinter.this.getBoolean("Titres.Divers.DiversTable.Titres.TransactionsTable.SousJacentVenduJustificatif", rowDMK));
            this.plusValue = Boolean.TRUE.equals(TitresTransactionsPrinter.this.getBoolean("Titres.Divers.DiversTable.Titres.TransactionsTable.PlusValue", rowDMK));
            this.methodeFixationPrix = Boolean.TRUE.equals(TitresTransactionsPrinter.this.getBoolean("Titres.Divers.DiversTable.Titres.TransactionsTable.MethodeFixationPrix", rowDMK));
            this.genreVR = Boolean.TRUE.equals(TitresTransactionsPrinter.this.getBoolean("Titres.Divers.DiversTable.Titres.TransactionsTable.GenreVR", rowDMK));
            this.genrePAR = Boolean.TRUE.equals(TitresTransactionsPrinter.this.getBoolean("Titres.Divers.DiversTable.TypeParticipationCollaborateur", rowDMK));
            this.genre = this.genreVR ? (!this.genrePAR ? SharedUtils.translate("label.titres.divers.transaction.genre.minus.vente", new Object[0]) : (!this.plusValue ? SharedUtils.translate("label.titres.divers.transaction.genre.minus.vente.sans.plus.value.print", new Object[0]) : (this.methodeFixationPrix ? SharedUtils.translate("label.titres.divers.transaction.genre.minus.vente.avec.plus.value.methode.diff.print", new Object[0]) : SharedUtils.translate("label.titres.divers.transaction.genre.minus.vente.sans.plus.value.meme.methode.print", new Object[0])))) : (this.sousJacentVenduJustificatif ? SharedUtils.translate("label.titres.divers.transaction.genre.minus.exercice.print", new Object[0]) : Objects.requireNonNull(TitresTransactionsPrinter.this.renderSelect("Titres.Divers.DiversTable.Titres.TransactionsTable.Genre", rowDMK), TitresTransactionsPrinter.INVALID_DMK));
            this.genreAutre = TitresTransactionsPrinter.this.getString("Titres.Divers.DiversTable.Titres.TransactionsTable.GenreAutre", rowDMK);
        }
    }
}

