/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.modelitems;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

abstract class TableAccumulator<A>
extends LogicModelItem {
    private final Reference itemRef;
    private final Reference stateRef;
    private Pattern itemDmkPtn;

    public TableAccumulator(String name, String persistenceKeyTemplate, Reference itemRef, Reference stateRef) {
        super(name, null, persistenceKeyTemplate, true, "false", false, false);
        this.itemRef = itemRef;
        this.stateRef = stateRef;
    }

    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        int endIndex;
        this.itemRef.registerListenerOnReference(logicModel, (LogicModelItem)this, true);
        if (this.stateRef != null) {
            this.stateRef.registerListenerOnReference(logicModel, (LogicModelItem)this, true);
        }
        String nameWithTableIndexShapes = this.itemRef.getReference().getNameWithTableIndexShapes();
        StringBuilder sb = new StringBuilder(50);
        sb.append("(");
        int startIndex = 0;
        int lastTableMark = -1;
        String splitToken = ".#";
        while ((endIndex = nameWithTableIndexShapes.indexOf(".#", startIndex)) != -1) {
            sb.append("\\Q").append(nameWithTableIndexShapes.substring(startIndex, endIndex)).append("\\E");
            lastTableMark = sb.length();
            sb.append("\\.[0-9]+");
            startIndex = endIndex + ".#".length();
        }
        sb.insert(lastTableMark, ")");
        sb.append("\\Q").append(nameWithTableIndexShapes.substring(startIndex)).append("\\E");
        this.itemDmkPtn = Pattern.compile(sb.toString().replaceAll("#", "[0-9]+"));
    }

    public void stateChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        this.process(dataModel, dataModelKey, changedEventsOnlyOutsideOfThisTable);
    }

    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        this.process(dataModel, dataModelKey, changedEventsOnlyOutsideOfThisTable);
    }

    private void process(LogicModelItem.ProtectedMap dataModel, String dataModelKey, String changedEventsOnlyOutsideOfThisTable) {
        String itemDmk = EngineUtil.mergeModelKey((String)this.itemRef.getName(), (String)dataModelKey);
        Matcher m = this.itemDmkPtn.matcher(itemDmk);
        if (!m.matches()) {
            throw new IllegalStateException(String.format("Failed to parse item DMK %s with pattern %s.", itemDmk, this.itemDmkPtn));
        }
        String tableDmk = m.group(1);
        Set indexes = (Set)DataModelUtil.getValue((Map)dataModel, Set.class, (String)tableDmk);
        if (indexes == null || indexes.isEmpty()) {
            return;
        }
        A accumulator = this.newAccumulator();
        StringBuilder dmkBuilder = new StringBuilder(tableDmk);
        int mark = dmkBuilder.length();
        for (String index : indexes) {
            ModelItemDTO stateItem;
            dmkBuilder.setLength(mark);
            dmkBuilder.append(".").append(index);
            if (this.stateRef != null && ((stateItem = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.stateRef.getName(), (String)dmkBuilder.toString()))) == null || stateItem.getState() == 12)) {
                return;
            }
            this.processEntry((Map<String, ModelItemDTO>)dataModel, EngineUtil.mergeModelKey((String)this.itemRef.getName(), (String)dmkBuilder.toString()), accumulator);
        }
        ModelItemDTO value = new ModelItemDTO(this.postProcess(accumulator));
        value.setTouched();
        super.setValue(dataModel, EngineUtil.mergeModelKey((String)this.getName(), (String)dataModelKey), value, changedEventsOnlyOutsideOfThisTable);
    }

    @Nonnull
    protected abstract A newAccumulator();

    protected abstract void processEntry(Map<String, ModelItemDTO> var1, String var2, A var3);

    @Nonnull
    protected abstract Object postProcess(A var1);
}

