/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.engine.modelitems.TableAccumulator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class RevisedTableConcat
extends TableAccumulator<StringBuilder> {
    private static final String DEFAULT_DELIMITER = ", ";

    public RevisedTableConcat(String name, String persistenceKeyTemplate, Reference itemRef, Reference stateRef) {
        super(name, persistenceKeyTemplate, itemRef, stateRef);
    }

    @Override
    @Nonnull
    protected StringBuilder newAccumulator() {
        return new StringBuilder(50);
    }

    @Override
    protected void processEntry(Map<String, ModelItemDTO> dataModel, String dataModelKey, StringBuilder accumulator) {
        String value = (String)DataModelUtil.getValue(dataModel, String.class, (String)dataModelKey);
        if (value != null) {
            if (accumulator.length() != 0) {
                accumulator.append(DEFAULT_DELIMITER);
            }
            accumulator.append(value);
        }
    }

    @Override
    @Nonnull
    protected Object postProcess(StringBuilder accumulator) {
        return accumulator.toString();
    }

    public static class XMLFactory
    implements ElementParser {
        @Nonnull
        public ClassObjectPair parse(@Nonnull Element element, @Nonnull ParserFactory factory) throws ElementParserException {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair classObjectPair = parser.parse(subElement, factory);
                    Object ref = classObjectPair.getObject();
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            String stateLmk = element.getAttributeValue("state");
            Reference stateRef = stateLmk != null ? new Reference(stateLmk, true) : null;
            RevisedTableConcat result = new RevisedTableConcat(element.getAttributeValue("name"), element.getAttributeValue("pKey"), new Reference(element.getAttributeValue("ref"), true), stateRef);
            for (Object e : validators) {
                result.addValidator((Validator)e);
            }
            return new ClassObjectPair(RevisedTableConcat.class, (Object)result);
        }
    }
}

