/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.calcitems.RelRef;
import ch.dvbern.tax.common.engine.modelitems.Module;
import ch.dvbern.tax.common.engine.modelitems.TableSum;
import ch.dvbern.tax.ge.pp.engine.modelitems.RepartitionTableSum;
import ch.dvbern.tax.ge.pp.utils.RepartitionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class RepartitionModule
extends Module {
    public RepartitionModule(String name, String title, List<LogicModelItem> children, String persistenceKeyTemplate, boolean importantState, boolean transparentIfNotReleasable, boolean transparentIfNotReleased, boolean transparentIfReleased, boolean disabledIfCd, boolean disabledIfOnline, boolean listenToStateEvents, boolean readonlyIfTransparent, boolean barcode, boolean transparentIfReceipted) {
        super(name, title, children, persistenceKeyTemplate, importantState, transparentIfNotReleasable, transparentIfNotReleased, transparentIfReleased, disabledIfCd, disabledIfOnline, listenToStateEvents, readonlyIfTransparent, barcode, transparentIfReceipted, false);
    }

    public static class XMLFactory
    implements ElementParser {
        @Nonnull
        public ClassObjectPair parse(@Nonnull Element element, @Nonnull ParserFactory factory) throws ElementParserException {
            DataResource dataResource = null;
            List elements = element.getChildren();
            ArrayList<LogicModelItem> childItems = elements.size() > 0 ? new ArrayList<LogicModelItem>() : null;
            ArrayList<RepartitionTableSum> tableSums = new ArrayList<RepartitionTableSum>();
            ArrayList<Validator> validators = new ArrayList<Validator>();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LogicModelItem) {
                        if (ref instanceof RepartitionTableSum) {
                            tableSums.add((RepartitionTableSum)((Object)ref));
                            continue;
                        }
                        childItems.add((LogicModelItem)ref);
                        continue;
                    }
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    if (ref instanceof DataResource) {
                        dataResource = (DataResource)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (dataResource != null) {
                String listname = element.getAttributeValue("list-name");
                String listParam = element.getAttributeValue("list-name-param");
                Map<String, Object> repartitionItems = RepartitionUtil.getRepartitionItemsAsLogicModelNames(dataResource, listname, listParam, null);
                for (String nom : repartitionItems.keySet()) {
                    for (Object e : tableSums) {
                        RepartitionTableSum sum = (RepartitionTableSum)((Object)e);
                        String tableSumName = sum.getName();
                        RelRef ref = new RelRef(sum.getTableRefName() + "." + nom);
                        TableSum tableSum = new TableSum(tableSumName + nom, null, (Reference)ref);
                        for (Validator val : sum.getValidators()) {
                            tableSum.addValidator(val);
                        }
                        childItems.add((LogicModelItem)tableSum);
                    }
                }
            }
            boolean importantState = true;
            if (element.getAttribute("is-state-important") != null) {
                importantState = Boolean.getBoolean(element.getAttributeValue("is-state-important"));
            }
            RepartitionModule result = new RepartitionModule(element.getAttributeValue("name"), element.getAttributeValue("title") == null ? element.getAttributeValue("name") : element.getAttributeValue("title"), childItems, element.getAttributeValue("pKey"), importantState, Boolean.valueOf(element.getAttributeValue("transparent-if-not-releasable")), Boolean.valueOf(element.getAttributeValue("transparent-if-not-released")), Boolean.valueOf(element.getAttributeValue("transparent-if-released")), Boolean.valueOf(element.getAttributeValue("disabled-if-cd")), Boolean.valueOf(element.getAttributeValue("disabled-if-online")), Boolean.valueOf(element.getAttributeValue("listen-to-state-events")), Boolean.valueOf(element.getAttributeValue("readonly-if-transparent")), Boolean.parseBoolean(element.getAttributeValue("barcode")), Boolean.parseBoolean(element.getAttributeValue("transparent-if-receipted")));
            for (Validator validator : validators) {
                result.addValidator(validator);
            }
            return new ClassObjectPair(RepartitionModule.class, (Object)result);
        }
    }
}

