/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.modelitems;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;

public abstract class PPLogicModelItem
extends LogicModelItem {
    protected static final int FIRST_LINE_INDEX = 90000;
    private DataResource dataResource;
    private final Reference table;
    private final Reference sourceItems;

    public PPLogicModelItem(String name, Reference sourceItems, Reference table) {
        super(name, null, null, true, "false", true, false);
        this.sourceItems = sourceItems;
        this.table = table;
    }

    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.sourceItems.registerListenerOnReference(logicModel, (LogicModelItem)this, false);
        this.table.initializeReference(logicModel, (LogicModelItem)this, false);
    }

    protected boolean hasAnInitialGreenState() {
        return true;
    }

    public boolean isReadonly() {
        return true;
    }

    protected void createTableCell(Reference column, LogicModelItem.ProtectedMap dataModel, int row, Object value) {
        String key = EngineUtil.mergeModelKey((String)column.getReference().getName(), (String)(this.table.getReference().getName() + "." + row));
        ModelItemDTO mi = new ModelItemDTO(value);
        mi.setTouched();
        column.getReference().setValue(dataModel, key, mi, "true");
    }

    protected void resetAndClearTable(LogicModelItem.ProtectedMap dataModel) {
        this.sourceItems.getReference().setValue(dataModel, this.sourceItems.getName(), new ModelItemDTO(null), "false");
        this.table.getReference().deleteSubValues(dataModel, this.table.getReference().getName(), true, "true");
        this.table.getReference().getParent().deleteSubValues(dataModel, this.table.getReference().getParent().getName(), true, "true");
    }

    public void setDataResource(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    protected DataResource getDataResource() {
        return this.dataResource;
    }
}

