/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PKeyTuple {
    public static final Pattern DOCUMENT_PTN = Pattern.compile("[A-Z]+\\d*");
    public static final Pattern TABLE_PTN = Pattern.compile("\\d+");
    public static final Pattern ZIFFER_PTN = Pattern.compile("\\d+(?:\\.\\d+)?");
    public static final Pattern ZELLE_PTN = Pattern.compile("\\d+");
    private static final Pattern TABLE_GROUP_PATTERN = Pattern.compile(String.format("\\[(%s)\\](?:\\[(%s)\\])?", TABLE_PTN.pattern(), TABLE_PTN.pattern()));
    public static final Pattern PTN = Pattern.compile(String.format("(%s);(?:(.*?)-)?(%s)-(%s)", DOCUMENT_PTN.pattern(), ZIFFER_PTN.pattern(), ZELLE_PTN.pattern()));
    public final String dokument;
    public final List<String> tableIds;
    public final String ziffer;
    public final String zelle;
    private final int hashcode;

    public PKeyTuple(String dokument, String ziffer, String zelle, String ... tableIds) {
        this(dokument, ziffer, zelle, Arrays.asList(tableIds));
    }

    public PKeyTuple(String dokument, String ziffer, String zelle, List<String> tableIds) {
        if (dokument == null) {
            throw new NullPointerException("Document cannot be null.");
        }
        if (ziffer == null) {
            throw new NullPointerException("Ziffer cannot be null");
        }
        if (zelle == null) {
            throw new NullPointerException("Zelle cannot be null");
        }
        if (tableIds == null) {
            throw new NullPointerException("Table ids cannot be null.");
        }
        if (!DOCUMENT_PTN.matcher(dokument).matches()) {
            throw new IllegalArgumentException("Invalid document: " + dokument);
        }
        if (!ZIFFER_PTN.matcher(ziffer).matches()) {
            throw new IllegalArgumentException("Invalid ziffer: " + ziffer);
        }
        if (!ZELLE_PTN.matcher(zelle).matches()) {
            throw new IllegalArgumentException("Invalid zelle: " + zelle);
        }
        if (tableIds.size() > 2) {
            throw new IllegalArgumentException(String.format("Invalid table ids list: only two table levels supported(got: %s)", tableIds));
        }
        this.dokument = dokument;
        this.ziffer = ziffer;
        this.zelle = zelle;
        List<String> tableIdsCopy = Collections.unmodifiableList(new ArrayList<String>(tableIds));
        this.tableIds = tableIdsCopy;
        this.hashcode = new HashCodeBuilder(1847723879, 1545624253).append((Object)dokument).append(tableIdsCopy).append((Object)ziffer).append((Object)zelle).build();
    }

    @Nonnull
    public String toExternalForm() {
        StringBuilder sb = new StringBuilder(this.dokument + ";");
        for (String tableId : this.tableIds) {
            sb.append("[").append(tableId).append("]");
        }
        if (!this.tableIds.isEmpty()) {
            sb.append("-");
        }
        sb.append(this.ziffer).append("-").append(this.zelle);
        return sb.toString();
    }

    public String toString() {
        return this.toExternalForm();
    }

    @Nonnull
    public static PKeyTuple parse(@Nonnull String text) {
        List<String> tablesIds;
        if (text == null) {
            throw new NullPointerException("Text to parse cannot be null.");
        }
        Matcher mainMatcher = PTN.matcher(text);
        if (!mainMatcher.matches()) {
            throw new IllegalArgumentException("Cannot parse this text as a pKey tuple: " + text);
        }
        String tableIdsGroup = mainMatcher.group(2);
        if (tableIdsGroup != null) {
            Matcher tableMatcher = TABLE_GROUP_PATTERN.matcher(tableIdsGroup);
            if (!tableMatcher.matches()) {
                throw new AssertionError((Object)"TABLE_GROUP_PATTERN must match the whole subset of the table group in PTN.");
            }
            tablesIds = new ArrayList(tableMatcher.groupCount());
            for (int i = 1; i <= tableMatcher.groupCount(); ++i) {
                String tableId = tableMatcher.group(i);
                if (tableId == null) continue;
                tablesIds.add(tableId);
            }
        } else {
            tablesIds = Collections.emptyList();
        }
        return new PKeyTuple(mainMatcher.group(1), mainMatcher.group(3), mainMatcher.group(4), tablesIds);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PKeyTuple)) {
            return false;
        }
        PKeyTuple that = (PKeyTuple)obj;
        return this.hashcode == that.hashcode && this.dokument.equals(that.dokument) && this.ziffer.equals(that.ziffer) && this.zelle.equals(that.zelle) && this.tableIds.equals(that.tableIds);
    }

    public int hashCode() {
        return this.hashcode;
    }
}

