/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.dto;

import ch.dvbern.tax.ge.pp.engine.dto.PKey;
import ch.dvbern.tax.ge.pp.engine.dto.PKeyTuple;
import ch.dvbern.tax.ge.pp.engine.dto.PKeyType;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PKeyTemplate {
    public final PKeyTuple pkTuple;
    public final PKeyType type;
    private static final Pattern PTN = Pattern.compile("(.*?);(\\w+)(;#)?(;#)?");

    public PKeyTemplate(PKeyTuple pkTuple, PKeyType type) {
        if (pkTuple == null) {
            throw new NullPointerException("PKey tuple cannot be null.");
        }
        if (type == null) {
            throw new NullPointerException("PKey type cannot be null.");
        }
        this.pkTuple = pkTuple;
        this.type = type;
    }

    public static PKeyTemplate parse(String pKeyTemplate) {
        if (pKeyTemplate == null) {
            throw new NullPointerException("Template string cannot be null");
        }
        Matcher m = PTN.matcher(pKeyTemplate);
        if (!m.matches()) {
            throw new IllegalArgumentException("Cannot parse template string: " + pKeyTemplate);
        }
        int groupCount = m.groupCount();
        assert (groupCount >= 2 && groupCount <= 4);
        try {
            int tableDepth;
            PKeyTuple tuple = PKeyTuple.parse(m.group(1));
            String pKeyTypeText = m.group(2);
            PKeyType type = PKeyType.forIdentifier(pKeyTypeText);
            assert (m.group(4) == null || m.group(3) != null) : "Group 4 availability imply group 3 availability.";
            int n = m.group(4) != null ? 2 : (tableDepth = m.group(3) != null ? 1 : 0);
            if (tableDepth != tuple.tableIds.size()) {
                throw new IllegalArgumentException(String.format("Index placeholders count (%d) does not match list of table ids size for template: %s", tableDepth, pKeyTemplate));
            }
            return new PKeyTemplate(tuple, type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse pKey template: " + pKeyTemplate, e);
        }
    }

    public PKey generatePKey(int lnDokument, int lnZelle) {
        return new PKey(this.pkTuple, this.type, Arrays.asList(lnDokument, lnZelle));
    }

    public PKey generatePKey(List<Integer> indexes) {
        if (indexes == null) {
            throw new NullPointerException("Table indexes cannot be null.");
        }
        if (indexes.size() != this.pkTuple.tableIds.size()) {
            throw new IllegalArgumentException(String.format("Incompatible indexes list (%s) for tuple %s.", indexes, this.pkTuple));
        }
        return new PKey(this.pkTuple, this.type, indexes);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("pkTuple", (Object)this.pkTuple).append("type", (Object)this.type).build();
    }
}

