/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.dto;

import ch.dvbern.tax.ge.pp.engine.dto.PKeyTuple;
import ch.dvbern.tax.ge.pp.engine.dto.PKeyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PKey {
    private static final Pattern PTN = Pattern.compile("(.*?);(\\\\w+)(?:;(\\?|[1-9]\\d*)){0,2}");
    public final PKeyTuple pkTuple;
    public final PKeyType pkType;
    public final List<Integer> indexes;
    private final String externalForm;
    private final int hashcode;

    public PKey(@Nonnull PKeyTuple pkTuple, @Nonnull PKeyType pkType, Integer ... indexes) {
        this(pkTuple, pkType, Arrays.asList(indexes));
    }

    public PKey(@Nonnull PKeyTuple pkTuple, @Nonnull PKeyType pkType, List<Integer> indexes) {
        if (pkTuple == null) {
            throw new NullPointerException("PKey tuple cannot be null.");
        }
        if (pkType == null) {
            throw new NullPointerException("PKey type cannot be null.");
        }
        if (indexes == null) {
            throw new NullPointerException("Table indexes cannot be null");
        }
        if (indexes.size() != pkTuple.tableIds.size()) {
            throw new IllegalArgumentException(String.format("Incompatible indexes list (%s) for tuple: %s", indexes, pkTuple));
        }
        this.pkTuple = pkTuple;
        this.pkType = pkType;
        this.indexes = Collections.unmodifiableList(new ArrayList<Integer>(indexes));
        this.hashcode = new HashCodeBuilder(1659544927, 1807972489).append((Object)pkTuple).append((Object)pkType).append(indexes).build();
        StringBuilder sb = new StringBuilder(pkTuple.toExternalForm());
        sb.append(";").append(pkType.getIdentifier());
        for (Integer index : this.indexes) {
            if (index == null || index <= 0) {
                throw new IllegalArgumentException("Invalid index in list: " + indexes);
            }
            sb.append(";").append(index);
        }
        this.externalForm = sb.toString();
    }

    public static PKey parse(String pKey) {
        if (pKey == null) {
            throw new NullPointerException("Persistence key string cannot be null");
        }
        Matcher m = PTN.matcher(pKey);
        if (!m.matches()) {
            throw new IllegalArgumentException("Cannot parse persistence key string: " + pKey);
        }
        int groupCount = m.groupCount();
        assert (groupCount >= 2 && groupCount <= 4);
        PKeyTuple tuple = PKeyTuple.parse(m.group(1));
        String pKeyTypeText = m.group(2);
        PKeyType pkType = PKeyType.forIdentifier(pKeyTypeText);
        ArrayList<Integer> indexes = new ArrayList<Integer>(2);
        switch (groupCount) {
            case 4: {
                int lnZelle = PKey.parseLn(m.group(4));
                if (lnZelle > 0) {
                    indexes.add(lnZelle);
                }
            }
            case 3: {
                int lnDokument = PKey.parseLn(m.group(3));
                if (lnDokument <= 0) break;
                indexes.add(lnDokument);
            }
        }
        return new PKey(tuple, pkType, indexes);
    }

    private static int parseLn(String text) {
        if (text == null || "?".equals(text)) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    public String toExternalForm() {
        return this.externalForm;
    }

    public int getLnDokument() {
        return !this.indexes.isEmpty() ? this.indexes.get(0) : 0;
    }

    public int getLnZelle() {
        return this.indexes.size() > 1 ? this.indexes.get(1) : 0;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PKey) {
            PKey that = (PKey)obj;
            return this.hashcode == that.hashcode && this.pkTuple.equals(that.pkTuple) && this.pkType == that.pkType && this.indexes == that.indexes;
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("pkTuple", (Object)this.pkTuple).append("pkType", (Object)this.pkType).append("indexes", this.indexes).toString();
    }
}

