/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.comparators;

import ch.dvbern.tax.common.engine.comparators.ExpertTableComparatorProvider;
import ch.dvbern.tax.common.engine.comparators.WizardTableComparatorProvider;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import java.text.Collator;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;

public class TitresTableRowComparatorProvider
implements WizardTableComparatorProvider,
ExpertTableComparatorProvider {
    public Comparator<ExpertDisplayInfoDTO.TableDTO.RowDTO> newComparator(ExpertDisplayModel.ProtectedMap dataModel) {
        return new BaseComparator<ExpertDisplayInfoDTO.TableDTO.RowDTO>((Map)dataModel){

            @Override
            protected String getRowDMK(ExpertDisplayInfoDTO.TableDTO.RowDTO rowItem) {
                return rowItem.getDataModelKey();
            }
        };
    }

    public Comparator<WizardDisplayInfoDTO.RowItemDTO> newComparator(WizardDisplayModelItem.ProtectedMap dataModel) {
        return new BaseComparator<WizardDisplayInfoDTO.RowItemDTO>((Map)dataModel){

            @Override
            protected String getRowDMK(WizardDisplayInfoDTO.RowItemDTO rowItem) {
                return rowItem.getDmkTableEntry();
            }
        };
    }

    public static class Entry
    implements Comparable<Entry> {
        private final String rowDMK;
        private final Integer typePos;
        private final Integer appartenancePos;
        private final String designation;

        private Entry(String rowDMK, Integer typePos, Integer appartenancePos, String designation) {
            this.rowDMK = rowDMK;
            this.typePos = typePos;
            this.appartenancePos = appartenancePos;
            this.designation = designation;
        }

        public static Entry load(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull String rowDMK) {
            if (dataModel == null) {
                throw new NullPointerException("Data model cannot be null.");
            }
            if (rowDMK == null) {
                throw new NullPointerException("Row data model key cannot be null.");
            }
            return new Entry(rowDMK, (Integer)DataModelUtil.getValue(dataModel, Integer.class, (String)EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.TypeDeFortunePosition", (String)rowDMK)), (Integer)DataModelUtil.getValue(dataModel, Integer.class, (String)EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.AppartenancePosition", (String)rowDMK)), (String)DataModelUtil.getValue(dataModel, String.class, (String)EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Designation", (String)rowDMK)));
        }

        @Nonnull
        public String getRowDMK() {
            return this.rowDMK;
        }

        @Override
        public int compareTo(@Nonnull Entry that) {
            int cmp = this.nullSafeCompare(this.typePos, that.typePos);
            if (cmp == 0) {
                cmp = this.nullSafeCompare(this.appartenancePos, that.appartenancePos);
            }
            if (cmp == 0) {
                Collator collator = Collator.getInstance(GeConstants.DEFAULT_LOCALE);
                cmp = this.nullSafeCompare(collator.getCollationKey(this.designation), collator.getCollationKey(that.designation));
            }
            return cmp;
        }

        private <T extends Comparable<T>> int nullSafeCompare(T o1, T o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            return o2 != null ? o1.compareTo(o2) : 1;
        }
    }

    private abstract class BaseComparator<R>
    implements Comparator<R> {
        final Map<String, ModelItemDTO> dataModel;

        BaseComparator(Map<String, ModelItemDTO> dataModel) {
            this.dataModel = dataModel;
        }

        abstract String getRowDMK(R var1);

        @Override
        public int compare(R rowItem1, R rowItem2) {
            Entry entry1 = Entry.load(this.dataModel, this.getRowDMK(rowItem1));
            Entry entry2 = Entry.load(this.dataModel, this.getRowDMK(rowItem2));
            return entry1.compareTo(entry2);
        }
    }
}

