/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ge.pp.transfer.dto.TravauxImmeublesDTO;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import org.apache.commons.lang3.StringUtils;

public class CFFraisDesTravauxImmeuble
implements CalcItem {
    private final DataResource dataResource;

    public CFFraisDesTravauxImmeuble(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        String result;
        String property = StackUtil.getString((FastStack)stack);
        String categorie = StackUtil.getString((FastStack)stack);
        String travaux = StackUtil.getString((FastStack)stack);
        if (StringUtils.isBlank((CharSequence)property) || StringUtils.isBlank((CharSequence)categorie) || StringUtils.isBlank((CharSequence)travaux)) {
            return;
        }
        TravauxImmeublesDTO dto = (TravauxImmeublesDTO)((Object)this.dataResource.get(ResourceEnum.IMMEUBLES_TRAVAUX_DETAIL.code(), (Object)categorie, null).get(travaux));
        if (dto == null) {
            return;
        }
        switch (Property.valueOf(property)) {
            case TYPE: {
                result = dto.getTypeFrais().toString();
                break;
            }
            case TEXT: {
                result = dto.getText().toString();
                break;
            }
            case SHORTTEXT: {
                result = dto.getShortText().toString();
                break;
            }
            default: {
                return;
            }
        }
        stack.push((Object)result);
    }

    private static enum Property {
        TYPE,
        TEXT,
        SHORTTEXT;

    }
}

