/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.common.transfer.dto.convert.DateConverter;
import java.util.Calendar;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public class CFFlipDayAndSetCurrentYear
implements CalcItem {
    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, @NonNull String dataModelKey) {
        Date date = (Date)stack.pop();
        if (date == null) {
            return;
        }
        int year = StackUtil.getInteger((FastStack)stack);
        boolean getLastDayOfMonth = StackUtil.getBoolean((FastStack)stack);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, year);
        stack.push((Object)(getLastDayOfMonth ? this.getLastDayOfMonth(calendar) : this.getFirstDayOfNextMonth(calendar)));
    }

    private String getLastDayOfMonth(Calendar calendar) {
        int lastDayOfMonth = calendar.getActualMaximum(5);
        calendar.set(5, lastDayOfMonth);
        return this.convertCalendarToString(calendar);
    }

    private String getFirstDayOfNextMonth(Calendar calendar) {
        calendar.add(2, 1);
        calendar.set(5, 1);
        return this.convertCalendarToString(calendar);
    }

    private String convertCalendarToString(Calendar calendar) {
        DateConverter dateConverter = new DateConverter();
        return dateConverter.getRenderedValue((Object)calendar.getTime());
    }

    public static class BirthdayInDecember
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            Date date = (Date)stack.pop();
            if (date == null) {
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            stack.push((Object)(calendar.get(2) == 11 ? 1 : 0));
        }
    }
}

