/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.admin.estv.xmlns.ictax._1_2_0.kursliste.InstrumentType;
import ch.admin.estv.xmlns.ictax._1_2_0.kursliste.QuotationType;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrumentType;
import ch.dvbern.tax.ge.pp.ictax.ICTAXUtils;
import ch.dvbern.tax.ge.pp.ictax.InstrumentBond;
import ch.dvbern.tax.ge.pp.ictax.InstrumentDerivative;
import ch.dvbern.tax.ge.pp.ictax.InstrumentFund;
import ch.dvbern.tax.ge.pp.ictax.InstrumentShare;
import ch.dvbern.tax.ge.pp.ictax.PaymentBond;
import ch.dvbern.tax.ge.pp.ictax.PaymentDerivative;
import ch.dvbern.tax.ge.pp.ictax.PaymentFund;
import ch.dvbern.tax.ge.pp.ictax.PaymentShare;
import ch.dvbern.tax.ge.pp.ictax.Sign;
import ch.dvbern.tax.ge.pp.ictax.TaxValue;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFDistributeValor
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(CFDistributeValor.class);
    private static final int FISCAL_YEAR = ApplicationConfig.getInstance().getJahr();
    private static final String CH_ISO_COUNTRY_CODE = "CH";
    public static final String DO_VALOR_SEARCH_CMD = "doSearch";
    private final Reference valorDTORef;
    private final Reference initialPartRef;
    private final Reference exchangeRateRef;
    private final Reference mutationDateRef;
    private final Reference mutationPartRef;

    public CFDistributeValor(Reference valorDTORef, Reference exchangeRateRef, Reference initialPartRef, Reference mutationDateRef, Reference mutationPartRef) {
        this.valorDTORef = valorDTORef;
        this.initialPartRef = initialPartRef;
        this.exchangeRateRef = exchangeRateRef;
        this.mutationDateRef = mutationDateRef;
        this.mutationPartRef = mutationPartRef;
    }

    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.valorDTORef.registerListenerOnReference(logicModel, logicModelItem, false);
        this.initialPartRef.registerListenerOnReference(logicModel, logicModelItem, false);
        this.exchangeRateRef.registerListenerOnReference(logicModel, logicModelItem, false);
        this.mutationDateRef.registerListenerOnReference(logicModel, logicModelItem, true);
        this.mutationPartRef.registerListenerOnReference(logicModel, logicModelItem, true);
    }

    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        DvbTaxInstrument instrument;
        GeConstants.TypeDeFortune titreType;
        DvbTaxInstrumentType instrumentType;
        String valorDTODmk = EngineUtil.mergeModelKey((String)this.valorDTORef.getName(), (String)dataModelKey);
        String typeStr = (String)DataModelUtil.getValue((Map)dataModel, String.class, (String)EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.TypeDeFortune", (String)dataModelKey));
        BigDecimal exchangeRate = (BigDecimal)DataModelUtil.getValue((Map)dataModel, BigDecimal.class, (String)EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.ExchangeRate", (String)dataModelKey));
        String valorDTOXML = (String)DataModelUtil.getValue((Map)dataModel, String.class, (String)valorDTODmk);
        String valorGiven = (String)modelItemDTO.getValue();
        Result result = Result.NO_SEARCH;
        if (valorDTOXML != null && typeStr != null && (instrumentType = (titreType = GeConstants.TypeDeFortune.valueOf(typeStr)).getInstrumentType()) != null && (instrument = ICTAXUtils.unmarshall(valorDTOXML, instrumentType)) != null && valorGiven != null) {
            if (!valorGiven.equals(String.valueOf(instrument.getValorNumber())) && !valorGiven.equals(instrument.getIsin())) {
                dataModel.getAsyncUpdates().put(valorDTODmk, null);
            } else {
                result = this.computeDistribution((Map<String, ModelItemDTO>)dataModel, dataModelKey, instrument, exchangeRate);
                if (result.showPartialImportWarning) {
                    modelItemDTO = modelItemDTO.clone(2, "warning.titres.titres.no.computation", null, 2);
                }
            }
        }
        this.doUpdate(dataModel, dataModelKey, result);
        return modelItemDTO;
    }

    private Result computeDistribution(Map<String, ModelItemDTO> dataModel, String dataModelKey, DvbTaxInstrument instrument, @Nullable BigDecimal exchangeRate) {
        Double initialPartDouble = (Double)DataModelUtil.getValue(dataModel, Double.class, (String)EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.ValeurNominaleInitial", (String)dataModelKey));
        BigDecimal initialPart = initialPartDouble != null ? BigDecimal.valueOf(initialPartDouble) : null;
        Boolean isPphc = (Boolean)DataModelUtil.getValue(dataModel, Boolean.class, (String)EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.PPHCRule", (String)dataModelKey));
        isPphc = isPphc == null ? false : isPphc;
        String tableDmk = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.TransactionsTable", (String)dataModelKey);
        Set indexes = (Set)DataModelUtil.getValue(dataModel, Set.class, (String)tableDmk);
        ArrayList<Variation> variationsList = new ArrayList<Variation>();
        if (indexes != null) {
            for (String index : indexes) {
                String rowDMK = tableDmk + "." + index;
                Date mutationDate = (Date)DataModelUtil.getValue(dataModel, Date.class, (String)EngineUtil.mergeModelKey((String)this.mutationDateRef.getName(), (String)rowDMK));
                Double mutationPart = (Double)DataModelUtil.getValue(dataModel, Double.class, (String)EngineUtil.mergeModelKey((String)this.mutationPartRef.getName(), (String)rowDMK));
                if (mutationDate == null || mutationPart == null) continue;
                variationsList.add(new Variation(new LocalDate((Object)mutationDate, GeConstants.TIMEZONE), BigDecimal.valueOf(mutationPart)));
            }
        }
        Collections.sort(variationsList, new VariationDateComparator());
        ArrayDeque<Variation> variations = new ArrayDeque<Variation>(variationsList);
        if (instrument instanceof InstrumentShare) {
            return this.computeShareDistribution((InstrumentShare)instrument, initialPart, variations, exchangeRate, isPphc);
        }
        if (instrument instanceof InstrumentBond) {
            return this.computeBondDistribution((InstrumentBond)instrument, initialPart, variations, exchangeRate);
        }
        if (instrument instanceof InstrumentFund) {
            return this.computeFundDistribution((InstrumentFund)instrument, initialPart, variations, exchangeRate);
        }
        if (instrument instanceof InstrumentDerivative) {
            return this.computeDerivativeDistribution((InstrumentDerivative)instrument, initialPart, variations, exchangeRate);
        }
        throw new InternalFailureException("Unexpected instrument type: " + instrument);
    }

    private Result computeShareDistribution(@Nonnull InstrumentShare share, @Nullable BigDecimal initialPart, @Nullable Deque<Variation> variations, @Nullable BigDecimal exchangeRate, boolean isPphc) {
        TaxValue taxValue;
        Object designation = share.getInstitutionIdentifier();
        String designationAppendix = share.getInstitutionIdentifierAppendix();
        if (designationAppendix != null) {
            designation = (String)designation + " - " + designationAppendix;
        }
        BigDecimal revenusAvecIA = null;
        BigDecimal revenusSansIA = null;
        BigDecimal fortuneImposable = null;
        boolean showPartialImportWarning = false;
        BigDecimal numberOfPieces = initialPart;
        boolean swiss = CH_ISO_COUNTRY_CODE.equals(share.getCountry());
        boolean hasSignY = false;
        for (String legend : share.getLegends()) {
            if (!legend.contains(Sign.Y.toString())) continue;
            hasSignY = true;
            break;
        }
        if (!hasSignY) {
            revenusAvecIA = BigDecimal.ZERO;
            revenusSansIA = BigDecimal.ZERO;
            for (PaymentShare payment : share.getPayments()) {
                LocalDate exDate;
                BigDecimal valueCHF;
                Sign sign = payment.getSign();
                if (sign == Sign.I) {
                    revenusSansIA = null;
                    revenusAvecIA = null;
                    showPartialImportWarning = true;
                    break;
                }
                if (sign == Sign.KEP || sign == Sign.IK || (valueCHF = payment.getValueCHF()) == null || (exDate = payment.getExDate()) == null && (exDate = payment.getPaymentDate()) == null) continue;
                if (exDate.getYear() < FISCAL_YEAR) {
                    showPartialImportWarning = true;
                }
                if (numberOfPieces == null) continue;
                if (variations != null) {
                    while (!variations.isEmpty()) {
                        boolean achat;
                        Variation variation = variations.peek();
                        int cmp = variation.date.compareTo((ReadablePartial)exDate);
                        boolean bl = achat = variation.value.compareTo(BigDecimal.ZERO) >= 0;
                        if (cmp > 0 || achat && cmp == 0) break;
                        variations.pop();
                        numberOfPieces = numberOfPieces.add(variation.value);
                    }
                }
                BigDecimal income = numberOfPieces.multiply(valueCHF);
                if (!isPphc && (swiss || payment.getSign() == Sign.P)) {
                    revenusAvecIA = revenusAvecIA.add(income);
                    continue;
                }
                revenusSansIA = revenusSansIA.add(income);
            }
        } else {
            showPartialImportWarning = true;
        }
        if (numberOfPieces != null && variations != null) {
            while (!variations.isEmpty()) {
                Variation variation = variations.pop();
                numberOfPieces = numberOfPieces.add(variation.value);
            }
        }
        if ((taxValue = share.getTaxValue()) != null && numberOfPieces != null) {
            fortuneImposable = this.computeFortuneImposable(share, numberOfPieces, taxValue, exchangeRate);
        }
        return new Result((String)designation, revenusAvecIA, revenusSansIA, fortuneImposable, null, showPartialImportWarning);
    }

    private Result computeBondDistribution(InstrumentBond bond, @Nullable BigDecimal initialPart, Deque<Variation> variations, @Nullable BigDecimal exchangeRate) {
        TaxValue taxValue;
        BigDecimal revenusSansIA;
        assert (bond != null);
        Object designation = bond.getInstitutionIdentifier();
        String designationAppendix = bond.getInstitutionIdentifierAppendix();
        if (designationAppendix != null) {
            designation = (String)designation + " - " + designationAppendix;
        }
        BigDecimal fortuneImposable = null;
        BigDecimal interetsEchusCapitauxEpargne = null;
        boolean showPartialImportWarning = false;
        BigDecimal nominalValue = initialPart;
        boolean swiss = CH_ISO_COUNTRY_CODE.equals(bond.getCountry());
        LocalDate redemptionDate = bond.getRedemptionDate();
        boolean convertible = bond.getInstrumentType() == InstrumentType.BOND_CONVERTABLE;
        BigDecimal revenusAvecIA = revenusSansIA = BigDecimal.ZERO;
        for (Variation variation : variations) {
            boolean partSold = variation.value.compareTo(BigDecimal.ZERO) < 0;
            if (!partSold || !convertible || redemptionDate == null || redemptionDate.getYear() <= FISCAL_YEAR) continue;
            revenusSansIA = null;
            revenusAvecIA = null;
            showPartialImportWarning = true;
            break;
        }
        if (!bond.isIup() && redemptionDate != null && redemptionDate.getYear() != FISCAL_YEAR) {
            for (PaymentBond payment : bond.getPayments()) {
                LocalDate paymentDate = payment.getPaymentDate();
                if (paymentDate == null || nominalValue == null || revenusAvecIA == null || revenusSansIA == null) continue;
                while (!variations.isEmpty() && variations.peek().date.isBefore((ReadablePartial)paymentDate)) {
                    Variation variation = variations.pop();
                    nominalValue = nominalValue.add(variation.value);
                }
                if (swiss) {
                    BigDecimal income = nominalValue.multiply(bond.getInterestRate() != null ? bond.getInterestRate().divide(BigDecimal.valueOf(100L)) : BigDecimal.ZERO);
                    revenusAvecIA = revenusAvecIA.add(income);
                    continue;
                }
                BigDecimal valueCHF = payment.getValueCHF();
                if (valueCHF == null) continue;
                revenusSansIA = revenusSansIA.add(nominalValue.divide(bond.getNominalAmount(), MathContext.DECIMAL64).multiply(valueCHF));
            }
        } else {
            showPartialImportWarning = true;
        }
        if ((taxValue = bond.getTaxValue()) != null && nominalValue != null) {
            while (!variations.isEmpty()) {
                nominalValue = nominalValue.add(variations.pop().value);
            }
            BigDecimal numberOfPieces = nominalValue.divide(bond.getNominalAmount(), MathContext.DECIMAL64);
            fortuneImposable = this.computeFortuneImposable(numberOfPieces, nominalValue, taxValue, exchangeRate);
        }
        if (bond.getInstrumentType() != InstrumentType.BOND_CONVERTABLE) {
            interetsEchusCapitauxEpargne = swiss ? revenusAvecIA : revenusSansIA;
        }
        return new Result((String)designation, revenusAvecIA, revenusSansIA, fortuneImposable, interetsEchusCapitauxEpargne, showPartialImportWarning);
    }

    private Result computeFundDistribution(InstrumentFund fund, @Nullable BigDecimal initialPart, Deque<Variation> variations, @Nullable BigDecimal exchangeRate) {
        TaxValue taxValue;
        Object designation = fund.getInstitutionIdentifier();
        String designationAppendix = fund.getInstitutionIdentifierAppendix();
        if (designationAppendix != null) {
            designation = (String)designation + " - " + designationAppendix;
        }
        BigDecimal revenusAvecIA = BigDecimal.ZERO;
        BigDecimal revenusSansIA = BigDecimal.ZERO;
        BigDecimal fortuneImposable = null;
        boolean showPartialImportWarning = false;
        BigDecimal numberOfPieces = initialPart;
        boolean swiss = CH_ISO_COUNTRY_CODE.equals(fund.getCountry());
        for (PaymentFund payment : fund.getPayments()) {
            LocalDate paymentDate;
            Sign sign = payment.getSign();
            if (swiss && sign == Sign.G || !swiss && sign == Sign.KG) continue;
            if (sign == Sign.I || sign == Sign.IM) {
                revenusSansIA = null;
                revenusAvecIA = null;
                showPartialImportWarning = true;
                break;
            }
            BigDecimal valueCHF = payment.getValueCHF();
            if (valueCHF == null || (paymentDate = payment.getPaymentDate()) == null || numberOfPieces == null) continue;
            while (!variations.isEmpty() && variations.peek().date.isBefore((ReadablePartial)paymentDate)) {
                Variation variation = variations.pop();
                numberOfPieces = numberOfPieces.add(variation.value);
            }
            if (swiss) {
                revenusAvecIA = revenusAvecIA.add(numberOfPieces.multiply(valueCHF));
                continue;
            }
            revenusSansIA = revenusSansIA.add(numberOfPieces.multiply(valueCHF));
        }
        if ((taxValue = fund.getTaxValue()) != null && numberOfPieces != null) {
            while (!variations.isEmpty()) {
                Variation variation = variations.pop();
                numberOfPieces = numberOfPieces.add(variation.value);
            }
            fortuneImposable = this.computeFortuneImposable(fund, numberOfPieces, taxValue, exchangeRate);
        }
        return new Result((String)designation, revenusAvecIA, revenusSansIA, fortuneImposable, null, showPartialImportWarning);
    }

    private Result computeDerivativeDistribution(InstrumentDerivative derivative, @Nullable BigDecimal initialPart, Deque<Variation> variations, @Nullable BigDecimal exchangeRate) {
        Object designation = derivative.getInstitutionIdentifier();
        String designationAppendix = derivative.getInstitutionIdentifierAppendix();
        if (designationAppendix != null) {
            designation = (String)designation + " - " + designationAppendix;
        }
        BigDecimal revenusAvecIA = null;
        BigDecimal revenusSansIA = null;
        BigDecimal fortuneImposable = null;
        BigDecimal interetsEchusCapitauxEpargne = BigDecimal.ZERO;
        boolean showPartialImportWarning = false;
        BigDecimal numberOfPieces = initialPart;
        boolean swiss = CH_ISO_COUNTRY_CODE.equals(derivative.getCountry());
        InstrumentType instrumentType = derivative.getInstrumentType();
        if (instrumentType == InstrumentType.DEVT_FUNDSIMILARASSET) {
            revenusAvecIA = revenusSansIA = BigDecimal.ZERO;
            for (PaymentDerivative payment : derivative.getPayments()) {
                LocalDate paymentDate;
                Sign sign = payment.getSign();
                if (sign == Sign.I) {
                    showPartialImportWarning = true;
                    revenusSansIA = null;
                    revenusAvecIA = null;
                    break;
                }
                BigDecimal valueCHF = payment.getValueCHF();
                if (valueCHF == null || (paymentDate = payment.getPaymentDate()) == null || numberOfPieces == null) continue;
                while (!variations.isEmpty() && variations.peek().date.isBefore((ReadablePartial)paymentDate)) {
                    Variation variation = variations.pop();
                    numberOfPieces = numberOfPieces.add(variation.value);
                }
                if (swiss && payment.getSign() != Sign.L) {
                    revenusAvecIA = revenusAvecIA.add(valueCHF.multiply(numberOfPieces));
                    continue;
                }
                revenusSansIA = revenusSansIA.add(valueCHF.multiply(numberOfPieces));
            }
        } else {
            showPartialImportWarning = true;
        }
        TaxValue taxValue = derivative.getTaxValue();
        if (numberOfPieces != null && taxValue != null) {
            while (!variations.isEmpty()) {
                Variation variation = variations.pop();
                numberOfPieces = numberOfPieces.add(variation.value);
            }
            fortuneImposable = this.computeFortuneImposable(derivative, numberOfPieces, taxValue, exchangeRate);
        }
        return new Result((String)designation, revenusAvecIA, revenusSansIA, fortuneImposable, interetsEchusCapitauxEpargne, showPartialImportWarning);
    }

    private @Nullable BigDecimal computeFortuneImposable(DvbTaxInstrument instrument, BigDecimal numberOfPieces, TaxValue taxValue, @Nullable BigDecimal exchangeRate) {
        return this.computeFortuneImposable(numberOfPieces, numberOfPieces.multiply(instrument.getNominalAmount()), taxValue, exchangeRate);
    }

    private @Nullable BigDecimal computeFortuneImposable(BigDecimal numberOfPieces, BigDecimal nominalValue, TaxValue taxValue, @Nullable BigDecimal exchangeRate) {
        BigDecimal fortuneImposable;
        if (taxValue.getQuotationType() == QuotationType.PERCENT) {
            if (exchangeRate == null) {
                return null;
            }
            BigDecimal percent = taxValue.getYearEndPrice().divide(BigDecimal.valueOf(100L));
            fortuneImposable = nominalValue.multiply(percent).multiply(exchangeRate);
        } else {
            assert (taxValue.getQuotationType() == QuotationType.PIECE);
            fortuneImposable = numberOfPieces.multiply(taxValue.getYearEndPrice());
        }
        return fortuneImposable;
    }

    private void doUpdate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, Result result) {
        Map updateMap = dataModel.getAsyncUpdates();
        updateMap.put(EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.SyncSearch", (String)dataModelKey), SharedUtils.createTouchedItem(result.inSync));
        updateMap.put(EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.DesignationSearch", (String)dataModelKey), SharedUtils.createTouchedItem(result.designation));
        updateMap.put(EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.RevenusAvecIASearch", (String)dataModelKey), SharedUtils.createTouchedItem(this.roundToLong(result.revenusAvecIA)));
        updateMap.put(EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.RevenusSansIASearch", (String)dataModelKey), SharedUtils.createTouchedItem(this.roundToLong(result.revenusSansIA)));
        updateMap.put(EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.FortuneImposableSearch", (String)dataModelKey), SharedUtils.createTouchedItem(this.roundToLong(result.fortuneImposable)));
        updateMap.put(EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.InteretsEchusSearch", (String)dataModelKey), SharedUtils.createTouchedItem(this.roundToLong(result.interetsEchusCapitauxEpargne)));
    }

    private @Nullable Long roundToLong(@Nullable BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.setScale(0, 6).longValue();
    }

    private static class Result {
        static final Result NO_SEARCH = new Result(null, null, null, null, null, false, false);
        final String designation;
        final BigDecimal revenusAvecIA;
        final BigDecimal revenusSansIA;
        final BigDecimal fortuneImposable;
        final BigDecimal interetsEchusCapitauxEpargne;
        final boolean showPartialImportWarning;
        final boolean inSync;

        private Result(@Nullable String designation, @Nullable BigDecimal revenusAvecIA, @Nullable BigDecimal revenusSansIA, @Nullable BigDecimal fortuneImposable, @Nullable BigDecimal interetsEchusCapitauxEpargne, boolean showPartialImportWarning) {
            this(designation, revenusAvecIA, revenusSansIA, fortuneImposable, interetsEchusCapitauxEpargne, showPartialImportWarning, true);
        }

        private Result(@Nullable String designation, @Nullable BigDecimal revenusAvecIA, @Nullable BigDecimal revenusSansIA, @Nullable BigDecimal fortuneImposable, @Nullable BigDecimal interetsEchusCapitauxEpargne, boolean showPartialImportWarning, boolean inSync) {
            this.designation = designation;
            this.revenusAvecIA = revenusAvecIA;
            this.revenusSansIA = revenusSansIA;
            this.fortuneImposable = fortuneImposable;
            this.interetsEchusCapitauxEpargne = interetsEchusCapitauxEpargne;
            this.showPartialImportWarning = showPartialImportWarning;
            this.inSync = inSync;
        }
    }

    private static class Variation {
        final LocalDate date;
        final BigDecimal value;

        private Variation(LocalDate date, BigDecimal value) {
            this.date = date;
            this.value = value;
        }
    }

    private static class VariationDateComparator
    implements Comparator<Variation> {
        private VariationDateComparator() {
        }

        @Override
        public int compare(Variation v1, Variation v2) {
            return v1.date.compareTo((ReadablePartial)v2.date);
        }
    }
}

