/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.ge.pp.transfer.dto.BaremeDTO;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import ch.dvbern.tax.ge.pp.utils.StackUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFDetermineImpotSelonBareme
implements CalcItem {
    private final DataResource dataResource;
    private static final Logger LOG = LoggerFactory.getLogger(CFDetermineImpotSelonBareme.class);

    public CFDetermineImpotSelonBareme(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        try {
            long montantDeterminantPourLeTaux = StackUtil.getLong(stack);
            long revenuICCImposableGeneve = StackUtil.getLong(stack);
            String baremeType = StackUtil.getString(stack);
            Double impotDeBase = 0.0;
            if (revenuICCImposableGeneve > 0L) {
                Map optionMap = this.dataResource.get(ResourceEnum.BAREME.code(), null, null);
                assert (optionMap.size() == 1);
                List tranches = (List)optionMap.values().iterator().next();
                long revenuImposable = baremeType.equals("Splitting") ? (long)((double)montantDeterminantPourLeTaux * 0.5) : (baremeType.equals("Splitting partiel") ? (long)((double)montantDeterminantPourLeTaux * 0.5556) : montantDeterminantPourLeTaux);
                int trancheIndex = this.getTrancheIndex(tranches, revenuImposable);
                BaremeDTO tranche = (BaremeDTO)tranches.get(trancheIndex);
                BaremeDTO trancheBefore = (BaremeDTO)tranches.get(Math.max(0, trancheIndex - 1));
                double impotCumule = trancheBefore.getImpotCumule();
                long difference = revenuImposable - trancheBefore.getTranche();
                double impotDifference = (double)difference * tranche.getTaux();
                impotDeBase = impotCumule + impotDifference;
                if (baremeType.equals("Splitting") || baremeType.equals("Splitting partiel")) {
                    impotDeBase = (double)montantDeterminantPourLeTaux * impotDeBase / (double)revenuImposable;
                }
                if (montantDeterminantPourLeTaux != 0L) {
                    impotDeBase = impotDeBase / (double)montantDeterminantPourLeTaux * (double)revenuICCImposableGeneve;
                }
            }
            stack.push((Object)impotDeBase);
        }
        catch (Exception e) {
            LOG.error("Error while determine ImpotSelonBareme ", (Throwable)e);
        }
    }

    private int getTrancheIndex(List<BaremeDTO> tranches, long revenu) {
        int beyondMaxIndex = tranches.size() - 1;
        for (int i = 0; i < beyondMaxIndex; ++i) {
            if (tranches.get(i).getTranche() <= revenu) continue;
            return i;
        }
        return beyondMaxIndex;
    }
}

