/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ge.pp.transfer.dto.DeducPersChargeDTO;
import ch.dvbern.tax.ge.pp.transfer.logic.DeductionPersonneAChargeUtils;
import ch.dvbern.tax.ge.pp.transfer.utils.DeductionPersChargeUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CFDeductionPersonneCharge {

    public static class DetermineReducPourBaremeParentalIFD
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getReducPourBaremeParental());
        }
    }

    public static class DeterminePlafondPrimeAssurance5200IFD
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getDedPlafondAssuranceVie5200IFD());
        }
    }

    public static class DetermineDeduction6120IFD
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getDed6120IFD());
        }
    }

    public static class DetermineDeducSocialeFortune5150ICC
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getDedSocialeFortune5150ICC());
        }
    }

    public static class DeterminePlafondPrimeAssurance5215ICC
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getDedPlafondAssuranceVie5215ICC());
        }
    }

    public static class DetermineDed6125CFICC
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getDed6125CFICC());
        }
    }

    public static class DetermineNbrDemiDeduction
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getNombreDemiDeduction());
        }
    }

    public static class DetermineNbrDeductionEntiere
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getNombreDeductionEntiere());
        }
    }

    public static class DetermineBaremeIFDAsNbr
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)DeductionPersChargeUtils.computeBaremeIFDAsNumber(deductionDTO.getBaremeIFD()));
        }
    }

    public static class DetermineBaremeIFDBarcode
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            String bareme = deductionDTO.getBaremeIFD();
            if (!bareme.isEmpty()) {
                if (bareme.equals("Mari\u00e9")) {
                    stack.push((Object)"M");
                } else {
                    stack.push((Object)"C");
                }
            }
        }
    }

    public static class DetermineBaremeIFD
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getBaremeIFD());
        }
    }

    public static class DetermineBaremeICCBarcode
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            String bareme = deductionDTO.getBaremeICC();
            if (!bareme.isEmpty()) {
                if (bareme.equals("Splitting")) {
                    stack.push((Object)"S");
                } else if (bareme.equals("Splitting partiel")) {
                    stack.push((Object)"P");
                } else {
                    stack.push((Object)"C");
                }
            }
        }
    }

    public static class DetermineBaremeICC
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getBaremeICC());
        }
    }

    public static class DetermineChargeIFD
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getChargeIFD());
        }
    }

    public static class DetermineChargeICC
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            DeducPersChargeDTO deductionDTO = DeductionPersonneAChargeUtils.createDeducPersChargeDTOFromMap((Map)StackUtil.get((FastStack)stack, Map.class, null));
            stack.push((Object)deductionDTO.getChargeICC());
        }
    }
}

