/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import java.util.Map;

public class CFCurrentSelectPosition
implements ComplexCalcItem {
    private final Reference selectRef;
    private final Reference valueRef;

    public CFCurrentSelectPosition(Reference selectRef) {
        this(selectRef, selectRef);
    }

    public CFCurrentSelectPosition(Reference selectRef, Reference valueRef) {
        if (selectRef == null) {
            throw new NullPointerException("select item reference cannot be null");
        }
        this.selectRef = selectRef;
        this.valueRef = valueRef;
    }

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        Object selectValue;
        Select select = (Select)this.selectRef.getReference();
        String dmk = EngineUtil.mergeModelKey((String)this.valueRef.getReference().getName(), (String)dataModelKey);
        ModelItemDTO selectValueItem = dataModel.get((Object)dmk);
        int position = 0;
        if (selectValueItem != null && (selectValue = selectValueItem.getValue()) != null) {
            OptionItemsDTO items = select.getOptionItems(dataModel, dataModelKey);
            for (Object key : items.getOptionKeys()) {
                if (key != null && key.equals(selectValue.toString())) break;
                ++position;
            }
        }
        stack.push((Object)position);
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.selectRef.registerListenerOnReference(logicModel, logicModelItem, false);
        if (!this.selectRef.getName().equals(this.valueRef.getName())) {
            this.valueRef.registerListenerOnReference(logicModel, logicModelItem, false);
        }
    }
}

