/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ge.pp.presentation.cd.util.CodeDeclarationIdentificationCodeCalculator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CFCodeDeclarationIdentification
implements CalcItem {
    private static final Pattern CODE_PTN = Pattern.compile("(\\d\\d)-?(\\d\\d\\d)-?(\\d\\d\\d) ?([A-Za-z]{3})");

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        String noContribuable = StackUtil.getString((FastStack)stack);
        String codeDecla = StackUtil.getString((FastStack)stack);
        String year = String.valueOf(StackUtil.getLong((FastStack)stack));
        stack.push((Object)this.validateCodeID(noContribuable, codeDecla, String.valueOf(year)));
    }

    private boolean validateCodeID(String taxNr, String codeDecla, String taxYear) {
        if (taxNr == null || codeDecla == null || taxYear == null) {
            return false;
        }
        if (codeDecla.equals("99-999-999 ZZZ")) {
            return true;
        }
        Matcher m = CODE_PTN.matcher(codeDecla);
        if (!m.matches()) {
            return false;
        }
        String codeDeclaIdInput = m.group(4) == null ? "" : m.group(4);
        String codeDeclaID = new CodeDeclarationIdentificationCodeCalculator(taxYear).getCodeDeclarationControlCode(taxNr, codeDecla.replaceAll("[^\\d]", ""));
        return codeDeclaID.equals(codeDeclaIdInput.toUpperCase());
    }
}

