/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot.repartition.intercommunale.results;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.results.RepartitionResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionHierarchie;
import ch.dvbern.tax.ge.pp.engine.modelitems.repartition.RepartitionItem;
import java.util.Map;
import java.util.TreeMap;

public final class RepartitionIntercommunaleResults
extends RepartitionResults {
    private Double impotsCommunaux = 0.0;

    public RepartitionIntercommunaleResults(LogicModelItem.ProtectedMap dataModel, boolean initValue) {
        super(dataModel, RepartitionHierarchie.COMMUNAL);
        if (initValue) {
            this.setImpotsCommunaux(this.dmUtil.getDouble("Recapitulation.CalculImpot.ImpotsCommunaux"));
            this.setRevenuTotalImposable(this.dmUtil.getLong("Recapitulation.CalculImpot.RevenuICCPartImposableGeneve"));
            this.setFortuneTotalImposableGeneve(this.dmUtil.getLong("Recapitulation.CalculImpot.FortuneICCPartImposableGeneve"));
        } else {
            this.resetSessionAttributes();
        }
    }

    private Map<Object, Long> getRecapitulationFortuneSessionAttribute(String key) {
        if (this.dataModel.getSessionAttributes().get(key) != null) {
            return (Map)this.dataModel.getSessionAttributes().get(key);
        }
        TreeMap<Object, Long> tmp = new TreeMap<Object, Long>();
        this.dataModel.getSessionAttributes().put(key, tmp);
        return tmp;
    }

    public void setRecapitulationFortuneColumns(Map<Object, Long> columns) {
        this.dataModel.getSessionAttributes().put("Recapitulation.CalculImpot.RecapitulationFortuneColumns", columns);
    }

    public void setRecapitulationRevenuColumns(Map<Object, Long> columns) {
        this.dataModel.getSessionAttributes().put("Recapitulation.CalculImpot.RecapitulationRevenuColumns", columns);
    }

    public Map<Object, Long> getRecapitulationFortuneColumns() {
        return this.getRecapitulationFortuneSessionAttribute("Recapitulation.CalculImpot.RecapitulationFortuneColumns");
    }

    public Map<Object, Long> getRecapitulationRevenuColumns() {
        return this.getRecapitulationFortuneSessionAttribute("Recapitulation.CalculImpot.RecapitulationRevenuColumns");
    }

    public Double getImpotsCommunaux() {
        return this.impotsCommunaux;
    }

    public void setImpotsCommunaux(Double impotsCommunaux) {
        this.impotsCommunaux = impotsCommunaux;
    }

    @Override
    public void saveInstance(RepartitionItem item) {
        item.setValue(this.dataModel, "Recapitulation.CalculImpot.ImpotsCommunaux", new ModelItemDTO((Object)this.getImpotsCommunaux()), "true");
    }
}

