/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot.repartition.intercommunale;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCivilite;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionFortuneCalcul;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.intercantonale.RepartitionIntercantonaleFortuneCalcul;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.intercommunale.results.RepartitionIntercommunaleResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.results.RepartitionResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.table.RepartitionColumn;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.table.RepartitionTable;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionHierarchie;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionMode;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionType;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RevenuFortune;
import ch.dvbern.tax.ge.pp.engine.modelitems.repartition.RepartitionItem;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariable;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariableSelect;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.sql.SQLException;
import java.util.ArrayList;

public class RepartitionIntercommunaleFortuneCalcul
extends RepartitionFortuneCalcul {
    private RepartitionTable tableFortuneICC = null;
    private final RepartitionIntercommunaleResults results;
    private final RepartitionItem destination;

    public RepartitionIntercommunaleFortuneCalcul(LogicModelItem.ProtectedMap dataModel, DataResource dataResource, RepartitionHierarchie hierarchie, RepartitionItem destination) {
        super(dataModel, dataResource, hierarchie);
        this.destination = destination;
        this.results = new RepartitionIntercommunaleResults(dataModel, false);
    }

    @Override
    public RepartitionResults getResults() {
        return this.results;
    }

    @Override
    public RepartitionTable compute() throws SQLException {
        this.initRepartitionIntercantonale();
        this.initKeyTaxation();
        this.computeFortuneBrute();
        this.computeFortuneImposable();
        this.computeAucuneFortuneImposable();
        return this.table;
    }

    private void initRepartitionIntercantonale() throws SQLException {
        RepartitionIntercantonaleFortuneCalcul calculFortuneICC = new RepartitionIntercantonaleFortuneCalcul(this.dataModel, this.dataResource, RepartitionHierarchie.CANTONAL);
        this.tableFortuneICC = calculFortuneICC.compute();
        calculFortuneICC.getResults().saveInstance(this.destination);
    }

    private void computeFortuneBrute() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        selectVariable.setWhereFortuneLibelleNotEmpty(true);
        selectVariable.setWhereSigne(Boolean.TRUE);
        selectVariable.setWhereFortuneRepartitionCommunale(RepartitionMode.LOCALISATION_OU_DOMICILE);
        this.processVariables(selectVariable, RevenuFortune.FORTUNE, this.getTypeRepartition());
        this.addTotalToTable("91.00", SharedUtils.translate("label.recapitulation.repartition.communale.fortuneBrute", new Object[0]), RepartitionCivilite.FO, true);
        this.saveFortunesBrutes();
    }

    private void computeFortuneImposable() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        selectVariable.setWhereFortuneLibelleNotEmpty(true);
        selectVariable.setWhereSigne(Boolean.FALSE);
        selectVariable.setWhereFortuneRepartitionCommunale(RepartitionMode.FORTUNE_BRUTE);
        this.processVariables(selectVariable, RevenuFortune.FORTUNE, this.getTypeRepartition());
        this.addTotalToTable("99.00", SharedUtils.translate("label.recapitulation.repartition.communale.fortuneTotale", new Object[0]), RepartitionCivilite.FO, true);
        this.computeCommunesNegatives("94.75", "label.recapitulation.repartition.communale.fortuneCompensation", "99.00", "label.recapitulation.repartition.communale.fortuneTotale");
        this.saveFortuneImposable();
    }

    private void saveFortunesBrutes() {
        this.getResults().getFortuneBrute().setColumns(this.columnsSum.getColumns());
        this.getResults().getFortuneBrute().setSumAllColumns(this.columnsSum.getSumAllColumns());
    }

    private void saveFortuneImposable() {
        this.getResults().setFortuneDeterminantePourLeTaux(this.columnsSum.getSumAllColumns());
        ((RepartitionIntercommunaleResults)this.getResults()).setRecapitulationFortuneColumns(this.columnsSum.getColumns());
    }

    @Override
    protected long getValueRepartitionMode(RepartitionVariable variable, String key, String keyInternationale, String keyIntercommunale, String referencedKey, Object cantonOuCommune) {
        if (this.tableFortuneICC != null && !RepartitionMode.LOCALISATION_OU_DOMICILE.toString().equals(variable.getModeRepartitionFortuneCommunale())) {
            RepartitionColumn columnFortuneICCCode = this.tableFortuneICC.getColumnCode();
            RepartitionColumn columnFortuneICCKey = this.tableFortuneICC.getColumnDatamodelKey();
            long value = 0L;
            if (columnFortuneICCCode != null && columnFortuneICCKey != null) {
                ArrayList<Integer> tmpRowIndex = new ArrayList<Integer>();
                String selectedKey = this.getSelectedKey(variable, key, keyInternationale, keyIntercommunale);
                for (int i = 0; i <= this.tableFortuneICC.getCountRows(); ++i) {
                    if (!variable.getCode().equals(columnFortuneICCCode.get(i)) || !selectedKey.equals(columnFortuneICCKey.get(i))) continue;
                    tmpRowIndex.add(i);
                }
                if (this.tableFortuneICC.getRepartition() != null && this.tableFortuneICC.getRepartition().containsKey("GE")) {
                    RepartitionColumn columnGEFortuneICC = this.tableFortuneICC.getRepartition().get("GE");
                    for (Integer row : tmpRowIndex) {
                        if (columnGEFortuneICC.get(row) == null) continue;
                        value += ((Long)columnGEFortuneICC.get(row)).longValue();
                    }
                }
            }
            return value;
        }
        if (!"EX".equals(cantonOuCommune)) {
            return this.getValue(variable, this.getSelectedKey(variable, key, keyInternationale, keyIntercommunale), referencedKey);
        }
        return 0L;
    }

    @Override
    protected String getSelectedKey(RepartitionVariable variable, String key, String keyInternationale, String keyCommunale) {
        if (variable.getKeyFortuneCommunale() != null && variable.getKeyFortuneCommunale().length() > 0) {
            return keyCommunale;
        }
        return key;
    }

    @Override
    protected void computeSurestimation(RepartitionVariableSelect selectVariable) {
    }

    @Override
    protected void setSelectParticipeAssieteType(RepartitionVariableSelect selectVariable) {
    }

    @Override
    protected RepartitionType getTypeRepartition() {
        return RepartitionType.FORTUNE_COMMUNALE;
    }
}

