/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot.repartition.intercantonale;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionRevenuCalcul;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.intercantonale.results.RepartitionIntercantonaleResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.results.RepartitionResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionHierarchie;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionMode;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionType;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariable;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariableSelect;

public class RepartitionIntercantonaleRevenuCalcul
extends RepartitionRevenuCalcul {
    private final RepartitionIntercantonaleResults results;

    public RepartitionIntercantonaleRevenuCalcul(LogicModelItem.ProtectedMap dataModel, DataResource dataResource, RepartitionHierarchie hierarchie) {
        super(dataModel, dataResource, hierarchie);
        this.results = new RepartitionIntercantonaleResults(dataModel, true);
    }

    @Override
    public RepartitionResults getResults() {
        return this.results;
    }

    @Override
    protected void setSelectParticipeAssieteType(RepartitionVariableSelect selectVariable) {
        selectVariable.setWhereICCParticipeAssiette(Boolean.TRUE);
    }

    @Override
    protected void setSelectRevenuRepartitionRevenusNets(RepartitionVariableSelect selectVariable) {
        selectVariable.setWhereRevenuRepartitionCantonale(RepartitionMode.REVENUS_NETS);
    }

    @Override
    protected void setSelectRevenuRepartitionTypeNotRevenusNets(RepartitionVariableSelect selectVariable) {
        selectVariable.setWhereRevenuRepartitionCantonaleNot(RepartitionMode.REVENUS_NETS);
    }

    @Override
    protected String getSelectedKey(RepartitionVariable variable, String key, String keyInternationale, String keyCommunale) {
        return key;
    }

    @Override
    protected RepartitionType getTypeRepartition() {
        return RepartitionType.REVENU_CANTONAL;
    }

    @Override
    protected void computeRevenuDeterminantTaux() {
        Long revenuDeterminant = this.columnsSum.getSumAllColumns();
        Long geneveValue = 0L;
        if (this.columnsSum.getColumns().containsKey("GE")) {
            geneveValue = this.columnsSum.getColumnValue("GE");
        }
        Long nonImposableValue = this.columnsSum.getSumAllColumns() - geneveValue;
        if (geneveValue <= 0L) {
            revenuDeterminant = 0L;
            geneveValue = 0L;
            nonImposableValue = 0L;
        }
        this.getResults().setRevenuDeterminantPourLeTaux(revenuDeterminant);
        this.getResults().setRevenuTotalImposable(geneveValue);
        this.getResults().setRevenuTotalNonImposable(nonImposableValue);
    }
}

