/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot.repartition.intercantonale;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCivilite;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionFortuneCalcul;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.intercantonale.results.RepartitionIntercantonaleResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.results.RepartitionResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.RepartitionColumnSum;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionHierarchie;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionType;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariable;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariableSelect;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RepartitionIntercantonaleFortuneCalcul
extends RepartitionFortuneCalcul {
    private final RepartitionIntercantonaleResults results;

    public RepartitionIntercantonaleFortuneCalcul(LogicModelItem.ProtectedMap dataModel, DataResource dataResource, RepartitionHierarchie hierarchie) {
        super(dataModel, dataResource, hierarchie);
        this.results = new RepartitionIntercantonaleResults(dataModel, false);
    }

    @Override
    public RepartitionResults getResults() {
        return this.results;
    }

    @Override
    protected void setSelectParticipeAssieteType(RepartitionVariableSelect selectVariable) {
        selectVariable.setWhereICCParticipeAssiette(Boolean.TRUE);
    }

    @Override
    protected String getSelectedKey(RepartitionVariable variable, String key, String keyInternationale, String keyCommunale) {
        return key;
    }

    @Override
    protected void computeSurestimation(RepartitionVariableSelect selectVariable) throws SQLException {
        RepartitionColumnSum valeurImmeubles = this.getTotalFortuneImmeubles(selectVariable);
        if (valeurImmeubles.getColumns().isEmpty() || valeurImmeubles.getSumAllColumns() == 0L) {
            return;
        }
        ArrayList<Object> sortedKeys = new ArrayList<Object>(valeurImmeubles.getColumns().keySet());
        Map surestimationParameters = this.dataResource.get(ResourceEnum.SURESTIMATION_IMMEUBLES.code(), null, null);
        Iterator it = sortedKeys.iterator();
        Long surestimationTotal = 0L;
        boolean valuesAdded = false;
        while (it.hasNext()) {
            String canton = (String)it.next();
            if (!surestimationParameters.containsKey(canton)) continue;
            Long taux = (Long)surestimationParameters.get(canton);
            Long value = valeurImmeubles.getColumnValue(canton);
            if (taux == 100L || value == 0L) continue;
            double valueSurestimee = taux.doubleValue() / 100.0;
            long difference = Math.round(valueSurestimee *= value.doubleValue()) - value;
            surestimationTotal = surestimationTotal + difference;
            this.table.addRow(this.rowIndex, "15.90", SharedUtils.translate("label.recapitulation.repartition.totalsurestimationifd", new Object[0]), RepartitionCivilite.FO, surestimationTotal, canton, difference, 0.0, "");
            this.addToColumnTotal(canton, difference);
            this.surestimation.put(canton, difference);
            valuesAdded = true;
        }
        if (valuesAdded) {
            ++this.rowIndex;
        }
    }

    private RepartitionColumnSum getTotalFortuneImmeubles(RepartitionVariableSelect selectVariable) throws SQLException {
        List<RepartitionVariable> variables = selectVariable.getVariable();
        RepartitionColumnSum valeurImmeubles = new RepartitionColumnSum();
        for (RepartitionVariable variable : variables) {
            Object canton;
            if (!"15.00".equals(variable.getRubrique())) continue;
            if (variable.getTable() != null && !"".equals(variable.getTable())) {
                Collection<?> coll = this.getTableRowIndexes(variable.getTable());
                if (coll == null || coll.isEmpty()) continue;
                for (Object aColl : coll) {
                    String key = (String)aColl;
                    String basekey = variable.getTable() + "." + key;
                    Long value = this.getValue(variable, basekey + "." + variable.getKeyCantonaleFortune(), basekey + "." + variable.getReferencedKey());
                    canton = this.getCommuneOuCantonTaxation(basekey + "." + variable.getCanton(), basekey + "." + variable.getLocalite());
                    valeurImmeubles.put(canton, value);
                }
                continue;
            }
            Long value = this.getValue(variable, variable.getKeyCantonaleFortune(), variable.getReferencedKey());
            canton = this.getCommuneOuCantonTaxation(variable.getCanton(), variable.getLocalite());
            valeurImmeubles.put(canton, value);
        }
        return valeurImmeubles;
    }

    @Override
    protected RepartitionType getTypeRepartition() {
        return RepartitionType.FORTUNE;
    }
}

