/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot.repartition;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCalcul;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCivilite;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.table.RepartitionTable;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.RepartitionColumnSum;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionHierarchie;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionMode;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RevenuFortune;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariable;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariableSelect;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class RepartitionRevenuCalcul
extends RepartitionCalcul {
    private static final String LABEL_COMPENSATION = "label.recapitulation.repartition.compensation";

    public RepartitionRevenuCalcul(LogicModelItem.ProtectedMap dataModel, DataResource dataResource, RepartitionHierarchie hierarchie) {
        super(dataModel, dataResource, hierarchie);
    }

    protected abstract void setSelectRevenuRepartitionRevenusNets(RepartitionVariableSelect var1);

    protected abstract void setSelectRevenuRepartitionTypeNotRevenusNets(RepartitionVariableSelect var1);

    @Override
    public RepartitionTable compute() throws SQLException {
        this.initKeyTaxation();
        this.initQuasiResident();
        this.computeRendementDeFortune();
        this.computeRevenuNetWithCompensation();
        this.computeRevenuNet();
        this.compensationExedentsDeCharge();
        this.saveRevenuNet();
        this.computeRevenuImposable();
        this.computeRevenuDeterminantTaux();
        this.computeAucunRevenuImposable();
        return this.table;
    }

    protected void computeAucunRevenuImposable() {
        this.addResultBlankLine("99.00", SharedUtils.translate("label.recapitulation.repartition.revenuimposable", new Object[0]), RepartitionCivilite.FO);
    }

    protected abstract void computeRevenuDeterminantTaux();

    private void saveRevenuNet() {
        this.getResults().getRevenuNet().setColumns(this.columnsSum.getColumns());
        this.getResults().getRevenuNet().setSumAllColumns(this.columnsSum.getSumAllColumns());
    }

    private void saveRendementBrutDeFortune() {
        this.getResults().getRendementBrutDeFortune().setColumns(this.columnsSum.getColumns());
        this.getResults().getRendementBrutDeFortune().setSumAllColumns(this.columnsSum.getSumAllColumns());
    }

    private void computeRevenuImposable() throws SQLException {
        this.computeRevenuImposableSubDeductions();
        this.addTotalToTable("99.00", SharedUtils.translate("label.recapitulation.repartition.revenuimposable", new Object[0]), RepartitionCivilite.FO, false);
    }

    private void computeRevenuImposableSubDeductions() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        this.setSelectRevenuRepartitionRevenusNets(selectVariable);
        this.processVariables(selectVariable, RevenuFortune.REVENU, this.getTypeRepartition());
    }

    private void compensationExedentsDeCharge() throws SQLException {
        this.addTotalToTable("92.15", SharedUtils.translate("label.recapitulation.repartition.revenu", new Object[0]), RepartitionCivilite.FO, false);
        this.computeInteretsSurCapitalInvesti(false);
        this.compensationRevenuNetSurLeCantonDeTaxation("94.71", SharedUtils.translate("label.recapitulation.repartition.compensationselondomicile", new Object[0]), false, null, false);
        this.compensationCantonDeTaxation();
        this.compensationSelonLesRevenusNetsPositifs();
        this.addTotalToTable("92.15", SharedUtils.translate("label.recapitulation.repartition.revenunet", new Object[0]), RepartitionCivilite.FO, true);
    }

    private void compensationCantonDeTaxation() throws SQLException {
        Long cantonTaxationValue = this.columnsSum.getColumnValue(this.communeOuCantonTaxation);
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        ArrayList<String> codeIn = new ArrayList<String>();
        codeIn.add("12.01");
        selectVariable.setWhereCodeIn(codeIn);
        RepartitionColumnSum cantonWithBenefice = this.getVariablesSum(selectVariable);
        Long totalPositif = this.getTotalCantonPositifHorsCantonTaxation(cantonWithBenefice);
        if (cantonTaxationValue != null && cantonTaxationValue < 0L && totalPositif > 0L) {
            if (cantonTaxationValue * -1L >= totalPositif) {
                this.compensationRevenuNetSurLeCantonDeTaxation("94.72", SharedUtils.translate("label.recapitulation.repartition.compensationselonbasestable", new Object[0]), true, cantonWithBenefice, false);
            } else {
                this.compensationRevenuNetSurLeCantonDeTaxationAuProrata(cantonTaxationValue, cantonWithBenefice, totalPositif);
            }
        }
    }

    protected void compensationSelonLesRevenusNetsPositifs() {
        Long totalPositif;
        Long cantonTaxationValue = this.columnsSum.getColumnValue(this.communeOuCantonTaxation);
        if (cantonTaxationValue != null && cantonTaxationValue < 0L && (totalPositif = this.getTotalCantonPositifHorsCantonTaxation(null)) > 0L) {
            if (cantonTaxationValue * -1L >= totalPositif) {
                String libelleCompensation = SharedUtils.translate(LABEL_COMPENSATION, new Object[0]);
                this.compensationRevenuNetSurLeCantonDeTaxation("94.73", libelleCompensation, true, null, false);
            } else {
                this.compensationRevenuNetSurLeCantonDeTaxationAuProrata(cantonTaxationValue, null, totalPositif);
            }
        }
    }

    private void compensationRevenuNetSurLeCantonDeTaxationAuProrata(Long cantonTaxationValue, RepartitionColumnSum cantonWithBenefice, Long totalPositif) {
        ArrayList<Object> sortedKeys = new ArrayList<Object>(this.columnsSum.getColumns().keySet());
        sortedKeys.remove("EX");
        Iterator it = sortedKeys.iterator();
        Long admis = 0L;
        boolean valuesAdded = false;
        while (it.hasNext()) {
            String canton = (String)it.next();
            Long value = this.columnsSum.getColumnValue(canton);
            if (this.communeOuCantonTaxation.equals(canton) || "EX".equals(this.communeOuCantonTaxation) || value <= 0L || !this.isCantonWithBenefice(cantonWithBenefice, canton)) continue;
            double part = value.doubleValue() / totalPositif.doubleValue();
            value = Math.round(cantonTaxationValue.doubleValue() * part);
            admis = admis + value;
            this.table.addRow(this.rowIndex, "94.72", SharedUtils.translate("label.recapitulation.repartition.compensationselonbasestable", new Object[0]), RepartitionCivilite.FO, admis, canton, value, part * 100.0, "");
            this.addToColumnTotal(canton, value);
            valuesAdded = true;
        }
        if (valuesAdded) {
            Long value = admis * -1L;
            admis = admis + value;
            this.table.addRow(this.rowIndex, "94.72", SharedUtils.translate("label.recapitulation.repartition.compensationselonbasestable", new Object[0]), RepartitionCivilite.FO, admis, this.communeOuCantonTaxation, value, 0.0, "");
            this.addToColumnTotal(this.communeOuCantonTaxation, value);
            ++this.rowIndex;
        }
    }

    private Long getTotalCantonPositifHorsCantonTaxation(RepartitionColumnSum cantonWithBenefice) {
        ArrayList<Object> sortedKeys = new ArrayList<Object>(this.columnsSum.getColumns().keySet());
        sortedKeys.remove("EX");
        Iterator it = sortedKeys.iterator();
        Long totalPositif = 0L;
        while (it.hasNext()) {
            Long value;
            String canton = (String)it.next();
            if (this.communeOuCantonTaxation.equals(canton) || "EX".equals(this.communeOuCantonTaxation) || !this.isCantonWithBenefice(cantonWithBenefice, canton) || (value = this.columnsSum.getColumnValue(canton)) <= 0L) continue;
            totalPositif = totalPositif + value;
        }
        return totalPositif;
    }

    private void computeRevenuNet() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        selectVariable.setWhereRevenuRendementFortune(Boolean.FALSE);
        this.setSelectParticipeAssieteType(selectVariable);
        selectVariable.setWhereRevenuLibelleNotEmpty(true);
        ArrayList<String> rubriqueNotIn = new ArrayList<String>();
        rubriqueNotIn.add("90.00");
        rubriqueNotIn.add("94.00");
        rubriqueNotIn.add("94.30");
        selectVariable.setWhereRubriqueNotIn(rubriqueNotIn);
        this.setSelectRevenuRepartitionTypeNotRevenusNets(selectVariable);
        this.processVariables(selectVariable, RevenuFortune.REVENU, this.getTypeRepartition());
    }

    private void computeRendementDeFortune() throws SQLException {
        this.computeRendementDeFortuneStep1();
        this.computeInteretsSurCapitalInvesti(true);
        this.addTotalToTable("91.40", SharedUtils.translate("label.recapitulation.repartition.rendementdefortune", new Object[0]), RepartitionCivilite.FO, false);
        this.saveRendementBrutDeFortune();
        this.computeRendementDeFortuneStep2();
    }

    private void computeInteretsSurCapitalInvesti(boolean addMode) throws SQLException {
        String code;
        String libelle;
        if (addMode) {
            libelle = SharedUtils.translate("label.recapitulation.repartition.interet.sur.capital", new Object[0]);
            code = "12.02";
        } else {
            libelle = SharedUtils.translate("label.recapitulation.repartition.reprise.interet.sur.capital", new Object[0]);
            code = "12.04";
        }
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        ArrayList<String> codeIn = new ArrayList<String>();
        codeIn.add("12.01");
        selectVariable.setWhereCodeIn(codeIn);
        List<RepartitionVariable> variables = selectVariable.getVariable();
        for (RepartitionVariable variable : variables) {
            Collection<?> coll;
            if (variable.getTable() == null || "".equals(variable.getTable()) || (coll = this.getTableRowIndexes(variable.getTable())) == null || coll.isEmpty()) continue;
            for (Object aColl : coll) {
                String key = (String)aColl;
                String basekey = variable.getTable() + "." + key;
                this.addValue(addMode, libelle, code, variable, basekey);
            }
        }
    }

    private void addValue(boolean addMode, String libelle, String code, RepartitionVariable variable, String basekey) throws SQLException {
        Object canton = this.getCommuneOuCantonTaxation(basekey + "." + variable.getCanton(), basekey + "." + variable.getLocalite());
        long beneficeNet = this.getValue(variable, basekey + "." + variable.getKeyCantonale(RevenuFortune.REVENU), basekey + "." + variable.getReferencedKey());
        if (beneficeNet > 0L) {
            String keyFondsPropres = this.getKeyFortuneIndependant("12.70");
            String keyActifsCommerciaux = this.getKeyFortuneIndependant("12.50");
            String keyPassifsCommeriaux = this.getKeyFortuneIndependant("57.50");
            long fondsPropres = this.getValue(variable, basekey + "." + keyFondsPropres, null);
            long actifsCommerciaux = this.getValue(variable, basekey + "." + keyActifsCommerciaux, null);
            long passifsCommeriaux = this.getValue(variable, basekey + "." + keyPassifsCommeriaux, null);
            Double taux = this.getTauxInteretsAVS();
            if (taux != null) {
                double revenu = taux / 100.0 * (double)(fondsPropres + actifsCommerciaux - passifsCommeriaux);
                BigDecimal bd = BigDecimal.valueOf(revenu);
                if ((bd = bd.setScale(2, 2)).longValue() <= 0L) {
                    return;
                }
                if (bd.longValue() > beneficeNet) {
                    bd = new BigDecimal(beneficeNet);
                }
                if (!addMode) {
                    bd = bd.negate();
                }
                long value = bd.longValue();
                this.table.addRow(this.rowIndex, code, libelle, RepartitionCivilite.CT, value, "" + canton, value, 0.0, "");
                this.addToColumnTotal(canton, value);
                ++this.rowIndex;
            }
        }
    }

    private Double getTauxInteretsAVS() {
        Map tauxInteretsAVS = this.dataResource.get(ResourceEnum.TAUX_INTERETS_AVS.code(), null, null);
        if (tauxInteretsAVS != null && tauxInteretsAVS.containsKey(String.valueOf(ApplicationConfig.getInstance().getJahr()))) {
            return (Double)tauxInteretsAVS.get(String.valueOf(ApplicationConfig.getInstance().getJahr()));
        }
        return null;
    }

    private String getKeyFortuneIndependant(String code) throws SQLException {
        String result = "";
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        ArrayList<String> codeIn2 = new ArrayList<String>();
        codeIn2.add(code);
        selectVariable.setWhereCodeIn(codeIn2);
        List<RepartitionVariable> variables = selectVariable.getVariable();
        if (variables.isEmpty()) {
            result = variables.get(0).getKeyCantonale(RevenuFortune.FORTUNE);
        }
        return result;
    }

    private void computeRevenuNetWithCompensation() {
        ArrayList<Object> sortedKeys = new ArrayList<Object>(this.columnsSum.getColumns().keySet());
        Iterator it = sortedKeys.iterator();
        Long totalPositif = 0L;
        Long totalNegatif = 0L;
        while (it.hasNext()) {
            String canton = (String)it.next();
            if ("EX".equals(canton)) continue;
            Long value = this.columnsSum.getColumnValue(canton);
            if (value < 0L) {
                totalNegatif = totalNegatif + value;
                continue;
            }
            totalPositif = totalPositif + value;
        }
        if (totalNegatif < 0L) {
            this.addTotalToTable("91.45", SharedUtils.translate("label.recapitulation.repartition.rendementapres1ererepartition", new Object[0]), RepartitionCivilite.FO, false);
            if (totalNegatif * -1L >= totalPositif) {
                String libelleCompensation = SharedUtils.translate(LABEL_COMPENSATION, new Object[0]);
                this.compensationRevenuNetSurLeCantonDeTaxation("94.70", libelleCompensation, true, null, true);
            } else {
                this.computeRevenuNetNegatifInferieure();
            }
        }
        this.addTotalToTable("91.50", SharedUtils.translate("label.recapitulation.repartition.rendementnetfortune", new Object[0]), RepartitionCivilite.FO, false);
    }

    private void computeRevenuNetNegatifInferieure() {
        Map<Object, Long> sortedColumnsSum = this.sortByValue(this.columnsSum.getColumns());
        sortedColumnsSum.remove("EX");
        Long totalActifsBrutsCantonPositif = this.getTotalActifsBrutsLocalisesCantonsRevenuPositif();
        Iterator<Object> it = sortedColumnsSum.keySet().iterator();
        RepartitionColumnSum columnsSumBeforeCompensation = new RepartitionColumnSum();
        columnsSumBeforeCompensation.setColumns(sortedColumnsSum);
        columnsSumBeforeCompensation.setSumAllColumns(this.columnsSum.getSumAllColumns());
        while (it.hasNext()) {
            String canton = (String)it.next();
            Long value = columnsSumBeforeCompensation.getColumnValue(canton);
            if (value >= 0L) continue;
            value = this.plafonneExcedentsDeCharge(canton, value);
            Long admis = this.computeAdmis(sortedColumnsSum, totalActifsBrutsCantonPositif, columnsSumBeforeCompensation, value);
            value = value * -1L;
            admis = admis + value;
            String libelleCompensation = SharedUtils.translate(LABEL_COMPENSATION, new Object[0]);
            this.table.addRow(this.rowIndex, "94.70", libelleCompensation, RepartitionCivilite.FO, admis, canton, value, 0.0, "");
            this.addToColumnTotal(canton, value);
            ++this.rowIndex;
        }
    }

    private Long computeAdmis(Map<Object, Long> sortedColumnsSum, Long totalActifsBrutsCantonPositif, RepartitionColumnSum columnsSumBeforeCompensation, Long value) {
        Iterator<Object> it2 = sortedColumnsSum.keySet().iterator();
        Long admis = 0L;
        while (it2.hasNext()) {
            String canton2 = (String)it2.next();
            if (columnsSumBeforeCompensation.getColumnValue(canton2) <= 0L) continue;
            Long actifsBruts = this.getResults().getActifsBrutsLocalises().getColumnValue(canton2);
            double prorata = actifsBruts.doubleValue() / totalActifsBrutsCantonPositif.doubleValue();
            double tmp = prorata * (double)value.longValue();
            Long value2 = Math.round(tmp);
            admis = admis + value2;
            String libelleCompensation = SharedUtils.translate(LABEL_COMPENSATION, new Object[0]);
            this.table.addRow(this.rowIndex, "94.70", libelleCompensation, RepartitionCivilite.FO, admis, canton2, value2, prorata * 100.0, "");
            this.addToColumnTotal(canton2, value2);
        }
        return admis;
    }

    private Long plafonneExcedentsDeCharge(String canton, Long value) {
        Long rendementBrutDeFortune = this.getResults().getRendementBrutDeFortune().getColumnValue(canton);
        if (rendementBrutDeFortune < 0L) {
            value = value - rendementBrutDeFortune;
        }
        return value;
    }

    private Long getTotalActifsBrutsLocalisesCantonsRevenuPositif() {
        ArrayList<Object> sortedKeysActifsBruts = new ArrayList<Object>(this.getResults().getActifsBrutsLocalises().getColumns().keySet());
        sortedKeysActifsBruts.remove("EX");
        Iterator it = sortedKeysActifsBruts.iterator();
        Long totalActifsBrutsCantonPositif = 0L;
        while (it.hasNext()) {
            String canton = (String)it.next();
            if (!this.columnsSum.getColumns().containsKey(canton) || this.columnsSum.getColumnValue(canton) < 0L) continue;
            Long value = this.getResults().getActifsBrutsLocalises().getColumnValue(canton);
            totalActifsBrutsCantonPositif = totalActifsBrutsCantonPositif + value;
        }
        return totalActifsBrutsCantonPositif;
    }

    private void compensationRevenuNetSurLeCantonDeTaxation(String codeCompensation, String libelleCompensation, boolean compenserCantonPositif, RepartitionColumnSum cantonWithBenefice, boolean plafonnerExcedentsDeCharge) {
        ArrayList<Object> sortedKeys = new ArrayList<Object>(this.columnsSum.getColumns().keySet());
        sortedKeys.remove("EX");
        Iterator it = sortedKeys.iterator();
        Long admis = 0L;
        boolean valuesAdded = false;
        while (it.hasNext()) {
            String canton = (String)it.next();
            Long value = this.columnsSum.getColumnValue(canton);
            if (this.communeOuCantonTaxation.equals(canton) || "EX".equals(this.communeOuCantonTaxation) || !this.isCantonWithBenefice(cantonWithBenefice, canton) || !(compenserCantonPositif && value > 0L || !compenserCantonPositif && value < 0L) && (!plafonnerExcedentsDeCharge || value == 0L)) continue;
            if (plafonnerExcedentsDeCharge && value < 0L) {
                value = this.plafonneExcedentsDeCharge(canton, value);
            }
            value = value * -1L;
            admis = admis + value;
            this.table.addRow(this.rowIndex, codeCompensation, libelleCompensation, RepartitionCivilite.FO, admis, canton, value, 0.0, "");
            this.addToColumnTotal(canton, value);
            valuesAdded = true;
        }
        if (valuesAdded) {
            Long value = admis * -1L;
            admis = admis + value;
            this.table.addRow(this.rowIndex, codeCompensation, libelleCompensation, RepartitionCivilite.FO, admis, this.communeOuCantonTaxation, value, 0.0, "");
            this.addToColumnTotal(this.communeOuCantonTaxation, value);
            ++this.rowIndex;
        }
    }

    private boolean isCantonWithBenefice(RepartitionColumnSum cantonWithBenefice, String canton) {
        return cantonWithBenefice == null && !"EX".equals(this.communeOuCantonTaxation) || cantonWithBenefice != null && cantonWithBenefice.getColumns().containsKey(canton);
    }

    private void computeRendementDeFortuneStep1() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        selectVariable.setWhereRevenuRendementFortune(Boolean.TRUE);
        selectVariable.setWhereRevenuRepartitionCantonaleNot(RepartitionMode.ACTIFS_BRUTS_DE_FORTUNE);
        this.processVariables(selectVariable, RevenuFortune.REVENU, this.getTypeRepartition());
    }

    private void computeRendementDeFortuneStep2() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        selectVariable.setWhereRevenuRendementFortune(Boolean.TRUE);
        selectVariable.setWhereRevenuRepartitionCantonale(RepartitionMode.ACTIFS_BRUTS_DE_FORTUNE);
        this.processVariables(selectVariable, RevenuFortune.REVENU, this.getTypeRepartition());
    }
}

