/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot.repartition;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCalcul;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCivilite;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.table.RepartitionTable;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.RepartitionColumnSum;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionHierarchie;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionMode;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RevenuFortune;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariableSelect;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepartitionFortuneCalcul
extends RepartitionCalcul {
    private static final Logger LOG = LoggerFactory.getLogger(RepartitionFortuneCalcul.class);
    protected final RepartitionColumnSum surestimation = new RepartitionColumnSum();

    public RepartitionFortuneCalcul(LogicModelItem.ProtectedMap dataModel, DataResource dataResource, RepartitionHierarchie hierarchie) {
        super(dataModel, dataResource, hierarchie);
    }

    @Override
    public RepartitionTable compute() throws SQLException {
        this.initKeyTaxation();
        this.initQuasiResident();
        try {
            this.computeActifsBrutsFortune();
        }
        catch (SQLException e) {
            LOG.error("Error computing actifs bruts fortune", (Throwable)e);
        }
        try {
            this.computeFortuneNette();
        }
        catch (SQLException e) {
            LOG.error("Error computing fortune nette", (Throwable)e);
        }
        try {
            this.computeFortuneImposable();
        }
        catch (SQLException e) {
            LOG.error("Error computing fortune imposable", (Throwable)e);
        }
        this.saveFortuneTotale();
        this.computeFortuneDeterminanteTaux();
        this.computeAucuneFortuneImposable();
        return this.table;
    }

    protected void computeAucuneFortuneImposable() {
        this.addResultBlankLine("99.00", SharedUtils.translate("label.recapitulation.repartition.fortunetotalefinale", new Object[0]), RepartitionCivilite.FO);
    }

    private void computeFortuneDeterminanteTaux() {
        this.getResults().setFortuneDeterminantePourLeTaux(this.columnsSum.getSumAllColumns());
        Long geneveValue = 0L;
        if (this.columnsSum.getColumns().containsKey("GE")) {
            geneveValue = this.columnsSum.getColumnValue("GE");
        }
        Long nonImposableValue = this.columnsSum.getSumAllColumns() - geneveValue;
        this.getResults().setFortuneTotalImposableGeneve(geneveValue);
        this.getResults().setFortuneTotalNonImposable(nonImposableValue);
    }

    private void saveFortuneTotale() {
        this.getResults().getFortuneTotale().setColumns(this.columnsSum.getColumns());
        this.getResults().getFortuneTotale().setSumAllColumns(this.columnsSum.getSumAllColumns());
    }

    private void computeTotalFortuneNette() {
        this.computeFortuneWithCompensation("92.15", SharedUtils.translate("label.recapitulation.repartition.fortunenette", new Object[0]), SharedUtils.translate("label.recapitulation.repartition.fortunenettefinale", new Object[0]), RepartitionCivilite.FO);
    }

    private void computeDeductionsFortuneNette() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        selectVariable.setWhereFortuneRepartitionCantonale(RepartitionMode.FORTUNE_NETTE);
        this.processVariables(selectVariable, RevenuFortune.FORTUNE, this.getTypeRepartition());
    }

    private void computeFortuneImposable() throws SQLException {
        if (this.getResults().getFortuneNette().getSumAllColumns() != 0L) {
            this.computeDeductionsFortuneNette();
            this.computeAbbatements();
            this.computeExemptionSurestimation();
            this.computeFortuneTotale();
        }
    }

    private void computeExemptionSurestimation() {
        if (this.surestimation != null && this.surestimation.getColumns() != null && !this.surestimation.getColumns().isEmpty()) {
            ArrayList<Object> sortedKeys = new ArrayList<Object>(this.surestimation.getColumns().keySet());
            Iterator it = sortedKeys.iterator();
            boolean valuesAdded = false;
            while (it.hasNext()) {
                String canton = (String)it.next();
                Long value = this.surestimation.getColumns().get(canton);
                value = value * -1L;
                Long sum = this.surestimation.getSumAllColumns() * -1L;
                this.table.addRow(this.rowIndex, "94.10", SharedUtils.translate("label.recapitulation.repartition.exemptionsurestimation", new Object[0]), RepartitionCivilite.FO, sum, canton, value, 0.0, "");
                this.addToColumnTotal(canton, value);
                valuesAdded = true;
            }
            if (valuesAdded) {
                ++this.rowIndex;
            }
        }
    }

    private void computeAbbatements() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        selectVariable.setWhereRubrique("94.20");
        this.processVariables(selectVariable, RevenuFortune.FORTUNE, this.getTypeRepartition());
    }

    private void computeFortuneTotale() {
        this.computeFortuneWithCompensation("99.00", SharedUtils.translate("label.recapitulation.repartition.fortunetotale", new Object[0]), SharedUtils.translate("label.recapitulation.repartition.fortunetotalefinale", new Object[0]), RepartitionCivilite.FO);
    }

    private void computeFortuneWithCompensation(String code, String libelleIntermediaire, String libelleFinal, RepartitionCivilite civilite) {
        Map<Object, Long> sortedColumnsSum = this.sortByValue(this.columnsSum.getColumns());
        Iterator<Map.Entry<Object, Long>> it = sortedColumnsSum.entrySet().iterator();
        Long totalPositif = 0L;
        Long totalNegatif = 0L;
        Long totalPositifCH = 0L;
        Long totalNegatifCH = 0L;
        while (it.hasNext()) {
            Map.Entry<Object, Long> entry = it.next();
            String canton = (String)entry.getKey();
            Long value = entry.getValue();
            if (value < 0L) {
                totalNegatif = totalNegatif + value;
                if ("EX".equals(canton)) continue;
                totalNegatifCH = totalNegatifCH + value;
                continue;
            }
            totalPositif = totalPositif + value;
            if ("EX".equals(canton)) continue;
            totalPositifCH = totalPositifCH + value;
        }
        if (totalNegatif < 0L) {
            this.computeValueAndAdmis(code, libelleIntermediaire, civilite, sortedColumnsSum, totalPositif, totalNegatif, totalPositifCH, totalNegatifCH);
        }
        this.addTotalToTable(code, libelleFinal, civilite, true);
    }

    private void computeValueAndAdmis(String code, String libelleIntermediaire, RepartitionCivilite civilite, Map<Object, Long> sortedColumnsSum, Long totalPositif, Long totalNegatif, Long totalPositifCH, Long totalNegatifCH) {
        this.addTotalToTable(code, libelleIntermediaire, civilite, false);
        Iterator<Map.Entry<Object, Long>> it = sortedColumnsSum.entrySet().iterator();
        Long admis = 0L;
        Long total = 0L;
        while (it.hasNext()) {
            Map.Entry<Object, Long> entry = it.next();
            String canton = (String)entry.getKey();
            Long value = entry.getValue();
            if (value == 0L) continue;
            if (totalNegatif * -1L >= totalPositif) {
                value = value * -1L;
                admis = this.addCompensation(admis, canton, value);
                continue;
            }
            if ("EX".equals(canton)) continue;
            if (value < 0L) {
                value = value * -1L;
            } else {
                double tmp = value.doubleValue() / totalPositifCH.doubleValue();
                value = Math.round(tmp *= (double)totalNegatifCH.longValue());
                if (total + value < totalNegatifCH) {
                    value = totalNegatifCH - total;
                }
                total = total + value;
            }
            admis = this.addCompensation(admis, canton, value);
        }
        ++this.rowIndex;
    }

    private Long addCompensation(Long admis, String canton, Long value) {
        admis = admis + value;
        String libelleCompensation = SharedUtils.translate("label.recapitulation.repartition.compensation", new Object[0]);
        this.table.addRow(this.rowIndex, "94.75", libelleCompensation, RepartitionCivilite.FO, admis, canton, value, 0.0, "");
        this.addToColumnTotal(canton, value);
        return admis;
    }

    private void computePassifsRepartis() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        selectVariable.setWhereSigne(Boolean.FALSE);
        selectVariable.setWhereFortuneLibelleNotEmpty(true);
        this.setSelectParticipeAssieteType(selectVariable);
        selectVariable.setWhereFortuneRepartitionCantonaleNot(RepartitionMode.FORTUNE_NETTE);
        selectVariable.setWhereCalcule(Boolean.FALSE);
        this.processVariables(selectVariable, RevenuFortune.FORTUNE, this.getTypeRepartition());
    }

    private void computeActifsBrutsFortune() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        selectVariable.setWhereSigne(Boolean.TRUE);
        selectVariable.setWhereFortuneLibelleNotEmpty(true);
        this.setSelectParticipeAssieteType(selectVariable);
        ArrayList<String> codeNotIn = new ArrayList<String>();
        codeNotIn.add("12.70");
        codeNotIn.add("12.80");
        selectVariable.setWhereCodeNotIn(codeNotIn);
        this.computeActifBrutLocalise(selectVariable);
        this.computeSurestimation(selectVariable);
        this.addTotalToTable("90.00", SharedUtils.translate("label.recapitulation.repartition.actifbrutlocalise", new Object[0]), RepartitionCivilite.FO, true);
        this.saveActifsBrutsLocalises();
    }

    private void saveActifsBrutsLocalises() {
        this.getResults().getActifsBrutsLocalises().setColumns(this.columnsSum.getColumns());
        this.getResults().getActifsBrutsLocalises().setSumAllColumns(this.columnsSum.getSumAllColumns());
    }

    protected abstract void computeSurestimation(RepartitionVariableSelect var1) throws SQLException;

    private void computeFortuneNette() throws SQLException {
        this.computeFondsPropres();
        this.computePassifsRepartis();
        this.computeTotalFortuneNette();
        this.saveFortuneNette();
    }

    private void saveFortuneNette() {
        this.getResults().getFortuneNette().setColumns(this.columnsSum.getColumns());
        this.getResults().getFortuneNette().setSumAllColumns(this.columnsSum.getSumAllColumns());
    }

    private void computeActifBrutLocalise(RepartitionVariableSelect selectVariable) throws SQLException {
        this.processVariables(selectVariable, RevenuFortune.FORTUNE, this.getTypeRepartition());
    }

    private void computeFondsPropres() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        ArrayList<String> codeIn = new ArrayList<String>();
        codeIn.add("12.70");
        selectVariable.setWhereCodeIn(codeIn);
        this.processVariables(selectVariable, RevenuFortune.FORTUNE, this.getTypeRepartition());
    }
}

