/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.repartition;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class SingleConnectionDataSource
implements DataSource {
    private final DataSource dataSource;
    private Connection singleConnection = null;

    public SingleConnectionDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("data source cannot be null");
        }
        this.dataSource = dataSource;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface != null && iface.isAssignableFrom(DataSource.class)) {
            return (T)this.dataSource;
        }
        throw new SQLException("Cannot unwrap from " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface != null && iface.isAssignableFrom(DataSource.class);
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        Connection connection = this.singleConnection;
        if (connection == null) {
            this.singleConnection = connection = this.dataSource.getConnection();
        }
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new UncloseableConnection(connection));
    }

    @Override
    public synchronized Connection getConnection(String username, String password) throws SQLException {
        Connection connection = this.singleConnection;
        if (connection == null) {
            this.singleConnection = connection = this.dataSource.getConnection(username, password);
        }
        return this.getConnection();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    private static class UncloseableConnection
    implements InvocationHandler {
        private final Connection connection;

        public UncloseableConnection(Connection connection) {
            assert (connection != null);
            this.connection = connection;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("close".equals(method.getName())) {
                return null;
            }
            try {
                return method.invoke((Object)this.connection, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

