/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.util;

import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.OpenException;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.presentation.cd.GeTaxWindow;
import ch.dvbern.tax.ge.pp.presentation.cd.util.GeCdApplicationConfig;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxmeGeFilename
extends TaxFileConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TaxmeGeFilename.class);

    public boolean checkVersion(Map dataModel) throws OpenException {
        Object value;
        boolean departDecesSelected = ((GeTaxWindow)TaxmeController.getInstance().getApp()).isDepartDeces();
        Integer taxYear = ((GeCdApplicationConfig)ApplicationConfig.getInstance()).getEffectiveYear(departDecesSelected);
        Long yearOfFileNbr = null;
        ModelItemDTO yearOfFile = (ModelItemDTO)dataModel.get("Stammdaten.Declaration.PeriodeTaxation");
        if (yearOfFile != null && (value = yearOfFile.getValue()) != null) {
            if (value instanceof Long) {
                yearOfFileNbr = (Long)value;
            } else {
                try {
                    yearOfFileNbr = Long.valueOf(value.toString());
                }
                catch (Exception e) {
                    LOG.warn("tax year conversion failed", (Throwable)e);
                    yearOfFileNbr = null;
                }
            }
        }
        return Long.valueOf(taxYear.intValue()).equals(yearOfFileNbr);
    }

    public boolean checkVersion(Map<String, ModelItemDTO> dataModel, boolean previousYear) throws OpenException {
        try {
            long actualYear = DataModelUtil.getValue(dataModel, Long.class, "Stammdaten.Declaration.PeriodeTaxation");
            Boolean departDecesDataModel = DataModelUtil.getValue(dataModel, Boolean.class, "Stammdaten.Declaration.DepartDeces");
            if (departDecesDataModel == null) {
                departDecesDataModel = false;
            }
            boolean departDecesSelected = ((GeTaxWindow)TaxmeController.getInstance().getApp()).isDepartDeces();
            String errorMessageKey = null;
            Object[] errorMessageArgs = null;
            GeCdApplicationConfig appConfig = (GeCdApplicationConfig)ApplicationConfig.getInstance();
            if (previousYear) {
                int expectedYear = appConfig.getEffectiveYear(departDecesSelected) - 1;
                if ((long)expectedYear != actualYear) {
                    errorMessageKey = departDecesSelected ? "error.tax.import.year.departDeces" : "error.tax.import.year";
                    errorMessageArgs = new Object[]{expectedYear, actualYear};
                }
            } else {
                int expectedYear = appConfig.getEffectiveYear(departDecesDataModel);
                if ((long)expectedYear != actualYear) {
                    errorMessageKey = departDecesDataModel != false ? "error.tax.open.departDeces" : "error.open.unbekannt";
                    errorMessageArgs = new Object[]{expectedYear, actualYear};
                }
            }
            if (errorMessageKey != null) {
                final String errorMessageKeyFinal = errorMessageKey;
                final Object[] errorMessageArgsFinal = errorMessageArgs;
                throw new OpenException("Tax file check failed."){

                    @Nullable
                    public String getMessageKey() {
                        return errorMessageKeyFinal;
                    }

                    @Nullable
                    public Object[] getMessageArgs() {
                        return errorMessageArgsFinal;
                    }
                };
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            LOG.error("Invalid tax file.", (Throwable)e);
            return false;
        }
    }

    public String getFileName(Map datamodel) {
        ModelItemDTO coupleDTO = (ModelItemDTO)datamodel.get("Stammdaten.Couple");
        ModelItemDTO nomContribuableDTO = (ModelItemDTO)datamodel.get("Stammdaten.Contribuable.Nom");
        ModelItemDTO prenomContribuableDTO = (ModelItemDTO)datamodel.get("Stammdaten.Contribuable.Prenom");
        ModelItemDTO steuerjahrDTO = (ModelItemDTO)datamodel.get("Stammdaten.Declaration.PeriodeTaxation");
        String nomContribuable = nomContribuableDTO != null && nomContribuableDTO.getValue() != null ? (String)nomContribuableDTO.getValue() : "";
        String prenomContribuable = prenomContribuableDTO != null && prenomContribuableDTO.getValue() != null ? (String)prenomContribuableDTO.getValue() : "";
        String steuerjahr = steuerjahrDTO != null && steuerjahrDTO.getValue() != null ? String.valueOf(steuerjahrDTO.getValue()) : "";
        Object filename = coupleDTO != null && coupleDTO.getValue() instanceof Boolean && (Boolean)coupleDTO.getValue() != false ? "Fam_" + nomContribuable + prenomContribuable : nomContribuable + prenomContribuable;
        if (((String)filename).length() > 20) {
            filename = ((String)filename).substring(0, 20);
        }
        filename = ((String)filename + steuerjahr).replace(' ', '_');
        return filename;
    }
}

