/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.util;

import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.TaxFileImporter;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.presentation.cd.GeTaxWindow;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import ch.dvbern.tax.ge.pp.utils.UUIDException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeTaxFileImporterCD
extends TaxFileImporter {
    private static final Logger LOG = LoggerFactory.getLogger(GeTaxFileImporterCD.class);
    public static final String TITRE_VALEUNOMINALE = "ValeurNominale";
    private static Long tax_year_expected = ApplicationConfig.getInstance().getVorjahr();
    private static Long tax_year_actual_year = ApplicationConfig.getInstance().getJahr();
    private static final String TAX_YEAR_ERROR_CODE = "error.import.steuerjahr";
    private static final String IS_CD_KEY = "Stammdaten.IsOfflineSelected";
    private static final String ASSURANCE_VIE_TABLE_LMK = "Deductions.AssurancesVie.AssurancesVie";
    private static final String ASSURANCE_VIE_ECHANCE_LMK = "Deductions.AssurancesVie.AssurancesVie.AnneeEcheance";
    public static final String COMPTE_FERMETURE = "3";
    public static final String DIVERS_TABLE = "DiversTable";
    public static final String COMPTE_TYP = "CPT";
    public static final String COMPTES_ROW = "Comptes";
    public static final String COMPTE_TYPE_DE_FORTUNE = "TypeDeFortune";
    public static final String COMPTE_OPERATION = "Operation";
    private boolean allowOpenCurrentYear = false;

    public GeTaxFileImporterCD(ImportContext ctx) {
        super(ctx);
    }

    public GeTaxFileImporterCD(ImportContext ctx, boolean allowOpenCurrentYear) {
        super(ctx);
        this.allowOpenCurrentYear = allowOpenCurrentYear;
    }

    @Override
    protected void importOldModelItems() throws ImportException {
        ModelItemDTO taxYearItem = this.getImportContext().getOldDataModel().get("Stammdaten.Declaration.PeriodeTaxation");
        tax_year_expected = ApplicationConfig.getInstance().getVorjahr();
        tax_year_actual_year = ApplicationConfig.getInstance().getJahr();
        boolean departDecesSelected = ((GeTaxWindow)TaxmeController.getInstance().getApp()).isDepartDeces();
        if (departDecesSelected) {
            Long l = tax_year_expected;
            tax_year_expected = tax_year_expected + 1L;
            l = tax_year_actual_year;
            tax_year_actual_year = tax_year_actual_year + 1L;
        } else {
            tax_year_expected = ApplicationConfig.getInstance().getVorjahr();
            tax_year_actual_year = ApplicationConfig.getInstance().getJahr();
        }
        if (tax_year_expected.equals(this.getTaxYear(taxYearItem))) {
            super.importOldModelItems();
        } else if (tax_year_actual_year.equals(this.getTaxYear(taxYearItem)) && this.allowOpenCurrentYear) {
            super.importOldModelItems(true);
        } else {
            throw new ImportException(TAX_YEAR_ERROR_CODE);
        }
        try {
            this.filterClosedBankaccounts();
            this.filterSoldoutTitles();
            this.filterEreleves();
            this.processValeurNominale();
            this.addTouchedItems();
        }
        catch (Exception e) {
            ModelItemDTO noContribuableItem = this.getImportContext().getOldDataModel().get("Stammdaten.Declaration.NoContribuable");
            Object noContribuable = "";
            if (noContribuableItem != null) {
                noContribuable = ", noContribuable : " + (String)noContribuable + noContribuableItem.getValue();
            }
            throw new UUIDException("error.import.ko", (String)noContribuable);
        }
    }

    private @Nullable Long getTaxYear(ModelItemDTO taxYearItem) {
        Object value;
        Long taxYear = null;
        if (taxYearItem != null && (value = taxYearItem.getValue()) != null) {
            if (value instanceof Long) {
                taxYear = (Long)value;
            } else {
                try {
                    taxYear = Long.valueOf(value.toString());
                }
                catch (Exception e) {
                    LOG.warn("tax year conversion failed", (Throwable)e);
                }
            }
        }
        return taxYear;
    }

    @Override
    protected void storeInNewModel(@NonNull String dmk, ModelItemDTO item) throws ImportException {
        String lmk = EngineUtil.removeTableIndices(dmk);
        if (item != null) {
            boolean processed;
            boolean bl = processed = this.processAssurancesVie(dmk, lmk, item) || this.processCdKey(dmk) || this.processImmeublesValeurLocative(dmk, lmk, item) || this.processPossessionAnneeDerniere(dmk, lmk, item);
            if (!processed) {
                super.storeInNewModel(dmk, item);
            }
        }
    }

    private boolean processCdKey(String dmk) throws ImportException {
        if (IS_CD_KEY.equals(dmk)) {
            ModelItemDTO newValue = new ModelItemDTO(Boolean.FALSE, 1);
            super.storeInNewModel(dmk, newValue);
            return true;
        }
        return false;
    }

    private boolean processImmeublesValeurLocative(String dmk, String lmk, ModelItemDTO item) throws ImportException {
        if (lmk.equals("Immeubles.ImmeublesOccupes.ImmeublesOccupes.RevenuEtFortune.ValeurLocativeBrute")) {
            ModelItemDTO cantonItem = this.getImportContext().getOldDataModel().get(EngineUtil.mergeModelKey("Immeubles.ImmeublesOccupes.ImmeublesOccupes.DonneesDeBase.Canton", dmk));
            if (cantonItem == null || cantonItem.getValue() == null) {
                return false;
            }
            return this.calculateImmeubleValeurLocative(dmk, item, cantonItem);
        }
        if (lmk.equals("Immeubles.ImmeublesPPE.ImmeublesPPE.RevenuEtFortune.ValeurLocativeBrute")) {
            ModelItemDTO cantonItem = this.getImportContext().getOldDataModel().get(EngineUtil.mergeModelKey("Immeubles.ImmeublesPPE.ImmeublesPPE.DonneesDeBase.Canton", dmk));
            if (cantonItem == null || cantonItem.getValue() == null) {
                return false;
            }
            return this.calculateImmeubleValeurLocative(dmk, item, cantonItem);
        }
        return false;
    }

    private boolean calculateImmeubleValeurLocative(String dmk, ModelItemDTO item, ModelItemDTO cantonItem) throws ImportException {
        if (item.getValue() != null && cantonItem.getValue().equals("GE")) {
            Map<?, ?> tauxValeurLocative = TaxmeConfig.getDataResource().get("immeublesValeurLocative", null, null);
            Double diviseur = (Double)tauxValeurLocative.keySet().toArray()[0];
            Double facteur = (Double)tauxValeurLocative.values().toArray()[0];
            BigDecimal itemValue = BigDecimal.ZERO;
            if (item.getValue() instanceof Long) {
                itemValue = BigDecimal.valueOf((Long)item.getValue());
            }
            if (item.getValue() instanceof Double) {
                itemValue = BigDecimal.valueOf((Double)item.getValue());
            }
            BigDecimal newVal = itemValue.multiply(BigDecimal.valueOf(facteur / diviseur)).setScale(0, RoundingMode.HALF_UP);
            ModelItemDTO newValue = new ModelItemDTO(newVal.longValue(), 1);
            super.storeInNewModel(dmk, newValue);
        } else {
            super.storeInNewModel(dmk, new ModelItemDTO(null, 1));
        }
        return true;
    }

    private boolean processPossessionAnneeDerniere(String dmk, String lmk, ModelItemDTO item) throws ImportException {
        if (lmk.endsWith("PossessionAnneePrecedente")) {
            ModelItemDTO newValue = new ModelItemDTO(true, 1);
            super.storeInNewModel(dmk, newValue);
            return true;
        }
        return false;
    }

    private @Nullable boolean processAssurancesVie(String dmk, String lmk, ModelItemDTO item) throws ImportException {
        if (item != null && lmk.startsWith(ASSURANCE_VIE_TABLE_LMK)) {
            Long echance;
            ModelItemDTO echanceItem = this.getImportContext().getOldDataModel().get(EngineUtil.mergeModelKey(ASSURANCE_VIE_ECHANCE_LMK, dmk));
            Long l = echance = echanceItem != null ? (Long)echanceItem.getValue() : null;
            if (echance != null && echance > tax_year_actual_year) {
                super.storeInNewModel(dmk, item);
            }
            return true;
        }
        return false;
    }

    @Override
    public @NonNull ImportContext getImportContext() {
        return super.getImportContext();
    }

    @Override
    public void doImport(@Nullable String password) throws ImportException {
        this.doImport(password, false);
    }

    public void doImport(@Nullable String password, boolean withDerivedValues) throws ImportException {
        if (withDerivedValues) {
            Map<String, ModelItemDTO> oldDataModel = this.getImportContext().getOldDataModel();
            HashMap<String, ModelItemDTO> derivedValues = new HashMap<String, ModelItemDTO>();
            for (Map.Entry<String, ModelItemDTO> entry : oldDataModel.entrySet()) {
                this.processDerivedValues(entry.getKey(), entry.getValue(), derivedValues);
            }
            oldDataModel.putAll(derivedValues);
        }
        super.doImport(password);
    }

    private void processDerivedValues(String dmk, ModelItemDTO item, Map<String, ModelItemDTO> derivedValues) throws ImportException {
        String lmk = EngineUtil.removeTableIndices(dmk);
        String typeTitre = null;
        if (lmk.equals("Titres.Divers.DiversTable.Comptes.TypeDeFortuneBarcode") || lmk.equals("Titres.Divers.DiversTable.Titres.TypeDeFortuneBarcode")) {
            typeTitre = (String)item.getValue();
        } else if (lmk.equals("Titres.Divers.DiversTable.RelevesFiscaux.Appartenance")) {
            typeTitre = GeConstants.TypeDeFortune.RF.name();
        }
        if (typeTitre != null) {
            ModelItemDTO typeItem = new ModelItemDTO(typeTitre);
            String typeFortuneDMK = EngineUtil.mergeModelKey("Titres.Divers.DiversTable.TypeDeFortune", dmk);
            typeItem.setTouched();
            derivedValues.put(typeFortuneDMK, typeItem);
        }
    }

    private void filterEreleves() {
        String dmk;
        Map<String, ModelItemDTO> newDatamodel = this.getImportContext().getNewDataModel();
        ArrayList<String> ereleveDmkRoot = new ArrayList<String>();
        for (Map.Entry<String, ModelItemDTO> entry : newDatamodel.entrySet()) {
            ModelItemDTO groupNo;
            Long groupNoValue;
            dmk = entry.getKey();
            if (!dmk.contains(DIVERS_TABLE) || !dmk.endsWith("GroupNo") || (groupNoValue = (Long)(groupNo = newDatamodel.get(dmk)).getValue()) == null || ((Object)groupNoValue).toString().equalsIgnoreCase("0")) continue;
            ereleveDmkRoot.add(new DMK(dmk).findOutermostTableRowDMK().toExternalForm());
        }
        LinkedHashSet elementsToRemove = new LinkedHashSet(ereleveDmkRoot);
        elementsToRemove.forEach(e -> System.out.println("GroupNo ->" + e));
        Iterator<Map.Entry<String, ModelItemDTO>> it = newDatamodel.entrySet().iterator();
        while (it.hasNext()) {
            dmk = it.next().getKey();
            for (String rowDmk : elementsToRemove) {
                if (!dmk.equals(rowDmk) && !dmk.startsWith(rowDmk + ".")) continue;
                it.remove();
                System.out.println("Removed Erel -> " + dmk);
            }
        }
    }

    private void filterClosedBankaccounts() {
        Map<String, ModelItemDTO> newDatamodel = this.getImportContext().getNewDataModel();
        ArrayList<String> comptesDatamodelkeys = new ArrayList<String>();
        for (Map.Entry<String, ModelItemDTO> entry : newDatamodel.entrySet()) {
            ModelItemDTO typeFortune;
            Object typeFortuneValue;
            String dmk = entry.getKey();
            if (dmk.contains(DIVERS_TABLE) && dmk.contains(COMPTES_ROW)) {
                comptesDatamodelkeys.add(dmk);
            }
            if (!dmk.contains(DIVERS_TABLE) || !dmk.contains(COMPTE_TYPE_DE_FORTUNE) || (typeFortuneValue = (typeFortune = this.getImportContext().getOldDataModel().get(dmk)).getValue()) == null || !typeFortune.getValue().toString().equals(COMPTE_TYP)) continue;
            comptesDatamodelkeys.add(dmk);
        }
        ArrayList<String> rowsToRemove = new ArrayList<String>();
        ArrayList<String> operationsDmk = new ArrayList<String>();
        for (String dmk : comptesDatamodelkeys) {
            if (!dmk.endsWith(COMPTE_OPERATION)) continue;
            ModelItemDTO operation = this.getImportContext().getOldDataModel().get(dmk);
            Object operationValue = operation.getValue();
            if (operationValue != null && operationValue.toString().equals(COMPTE_FERMETURE)) {
                rowsToRemove.add(EngineUtil.getOuterTableRowDmk(dmk));
            }
            operationsDmk.add(dmk);
        }
        for (String rowToRemove : rowsToRemove) {
            for (String dmk : comptesDatamodelkeys) {
                if (!dmk.startsWith(rowToRemove)) continue;
                this.getImportContext().getNewDataModel().remove(dmk);
            }
        }
        for (String operationDmk : operationsDmk) {
            this.getImportContext().getNewDataModel().remove(operationDmk);
        }
    }

    private void filterSoldoutTitles() {
        Map<String, ModelItemDTO> newDatamodel = this.getImportContext().getNewDataModel();
        ArrayList<String> titreDatamodelkeys = new ArrayList<String>();
        for (Map.Entry<String, ModelItemDTO> entry : newDatamodel.entrySet()) {
            ModelItemDTO typeFortune;
            String typeFortuneCode;
            String dmk = entry.getKey();
            String[] tokens = dmk.split("\\.");
            if (tokens[tokens.length - 2].equals("Titres")) {
                titreDatamodelkeys.add(dmk);
            }
            if (!dmk.contains(DIVERS_TABLE) || !dmk.contains(COMPTE_TYPE_DE_FORTUNE) || !(typeFortuneCode = Objects.requireNonNull((typeFortune = this.getImportContext().getOldDataModel().get(dmk)).getValue()).toString()).equals("ACT") && !typeFortuneCode.equals("OBL") && !typeFortuneCode.equals("DEV") && !typeFortuneCode.equals("FDS")) continue;
            titreDatamodelkeys.add(dmk);
        }
        ArrayList<String> titresToRemove = new ArrayList<String>();
        for (String dmk : titreDatamodelkeys) {
            ModelItemDTO operation;
            Object value;
            if (!dmk.endsWith(TITRE_VALEUNOMINALE) || !(value = Objects.requireNonNull((operation = this.getImportContext().getOldDataModel().get(dmk)).getValue())).toString().equals("0.0")) continue;
            titresToRemove.add(EngineUtil.getOuterTableRowDmk(dmk));
        }
        for (String rowToRemove : titresToRemove) {
            for (String dmk : titreDatamodelkeys) {
                if (!dmk.startsWith(rowToRemove)) continue;
                this.getImportContext().getNewDataModel().remove(dmk);
            }
        }
    }

    private void processValeurNominale() throws ImportException {
        Map<String, ModelItemDTO> newDatamodel = this.getImportContext().getNewDataModel();
        ArrayList<String> dmksToRemove = new ArrayList<String>();
        for (Map.Entry<String, ModelItemDTO> entry : newDatamodel.entrySet()) {
            String dmk = entry.getKey();
            if (!dmk.contains(DIVERS_TABLE) || !dmk.endsWith(TITRE_VALEUNOMINALE)) continue;
            dmksToRemove.add(dmk);
        }
        for (String dmkToRemove : dmksToRemove) {
            ModelItemDTO valeurNominale = newDatamodel.get(dmkToRemove);
            ModelItemDTO valeurNominaleInitial = valeurNominale.cloneUntouched();
            String newDmk = dmkToRemove.replace(TITRE_VALEUNOMINALE, "ValeurNominaleInitial");
            super.storeInNewModel(newDmk, valeurNominaleInitial);
            newDatamodel.remove(dmkToRemove);
        }
    }

    private void addTouchedItems() {
        String dmk = "Immeubles.Recapitulation.ObservationsOuiNon";
        ModelItemDTO item = new ModelItemDTO(false);
        item = item.cloneTouched();
        this.getImportContext().getNewDataModel().put(dmk, item);
        dmk = "Immeubles.Recapitulation.Platzhalter";
        item = new ModelItemDTO(true);
        item = item.cloneTouched();
        this.getImportContext().getNewDataModel().put(dmk, item);
        dmk = "Dettes.Recapitulation.Platzhalter";
        item = new ModelItemDTO(true);
        item = item.cloneTouched();
        this.getImportContext().getNewDataModel().put(dmk, item);
    }
}

