/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.upload;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.UserDocument;
import ch.ge.afc.ael.fo.teledeclaration.pp.EnumCodeErreurTeleversement;
import ch.ge.afc.ael.fo.teledeclaration.pp.ResultatTeleversement;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadResultDTO {
    private static final Logger LOG = LoggerFactory.getLogger(UploadResultDTO.class);
    private static final int RESULT_MSG_MAX_LENGTH = 300;
    private static final Pattern RESULT_MSG_ILLEGAL_CHAR_PTN = Pattern.compile("\\p{C}");
    private final boolean success;
    private final String userErrorMsg;
    private final byte[] content;

    private UploadResultDTO(boolean success, String userErrorMsg, byte[] content) {
        this.success = success;
        this.userErrorMsg = userErrorMsg;
        this.content = content;
    }

    static UploadResultDTO process(@Nonnull ResultatTeleversement result, @Nonnull List<UserDocument> docs) {
        String errorMsg;
        boolean success;
        EnumCodeErreurTeleversement errorCode = result.getCode();
        boolean bl = success = errorCode == EnumCodeErreurTeleversement.OK;
        if (success) {
            errorMsg = null;
        } else {
            errorMsg = UploadResultDTO.resolveErrorMessage(errorCode, result.getInfo(), docs);
            if (errorMsg == null) {
                errorMsg = UploadResultDTO.decodeMsg(result.getResultat());
                if (errorMsg != null) {
                    LOG.warn("Received unknown error code {}, interpreted upload result as textual data: {}", (Object)errorCode, (Object)errorMsg);
                } else {
                    LOG.warn("Received unknown error code {}, but cannot interpret the upload result as textual data.", (Object)errorCode);
                    errorMsg = Messages.translate((String)"label.upload.error.other", (Object[])new Object[0]);
                }
            }
        }
        assert (success || errorMsg != null);
        return new UploadResultDTO(success, errorMsg, result.getResultat());
    }

    static String resolveErrorMessage(@Nullable EnumCodeErreurTeleversement errorCode, @Nullable String info, @Nullable List<UserDocument> docs) {
        if (errorCode == null) {
            return null;
        }
        String errorKey = null;
        Object[] errorArgs = null;
        switch (errorCode) {
            case ERR_COHERENCE_DATA: {
                errorKey = "label.upload.error.enum.coherence";
                break;
            }
            case ERR_CONTROLE_METIER: {
                errorKey = "label.upload.error.enum.metier";
                break;
            }
            case ERR_DECODAGE: {
                errorKey = "label.upload.error.enum.decode";
                break;
            }
            case ERR_CRYPTAGE: {
                errorKey = "label.upload.error.enum.cryptage";
                break;
            }
            case ERR_INTERNE: 
            case ERR_SERVICE_INDISPONIBLE: {
                errorKey = "label.upload.error.enum.interne";
                break;
            }
            case ERR_VERSION_OBSOLETE: {
                errorKey = "label.upload.error.enum.obsolete";
                break;
            }
            case ERR_PARAMETRE: {
                errorKey = "label.upload.error.enum.parametre";
                break;
            }
            case ERR_SIGNATURE: {
                errorKey = "label.upload.error.enum.signature";
                break;
            }
            case ERR_MANDAT_EN_LIGNE: {
                errorKey = "label.upload.error.enum.mandat";
                break;
            }
            case ERR_PERIODE_INVALIDE: {
                errorKey = "label.upload.error.enum.periode";
                break;
            }
            case ERR_PIECE_JOINTE: {
                UserDocument doc = null;
                if (info != null && docs != null) {
                    try {
                        int docId = Integer.parseInt(info);
                        doc = docs.get(docId);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Cannot parse document id from: " + info);
                    }
                    catch (IndexOutOfBoundsException e) {
                        LOG.error("No such document: " + info);
                    }
                }
                if (doc != null) {
                    errorKey = "label.upload.error.enum.attachment";
                    errorArgs = new Object[]{doc.getDescription(), doc.getOrigFilename()};
                    break;
                }
                errorKey = "label.upload.error.enum.attachment.unknown";
            }
        }
        return errorKey != null ? Messages.translate((String)errorKey, errorArgs) : null;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nullable
    public String getUserErrorMsg() {
        return this.userErrorMsg;
    }

    @Nullable
    public byte[] getContent() {
        return this.content;
    }

    private static String decodeMsg(@Nullable byte[] message) {
        String errorMsg = null;
        if (message != null && message.length > 0) {
            CoderResult decodeResult;
            CharsetDecoder resultMsgDecoder = StandardCharsets.UTF_8.newDecoder();
            resultMsgDecoder.reset();
            resultMsgDecoder.onMalformedInput(CodingErrorAction.REPORT);
            resultMsgDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            CharBuffer out = CharBuffer.allocate(300);
            ByteBuffer in = ByteBuffer.wrap(message);
            try {
                decodeResult = resultMsgDecoder.decode(in, out, true);
            }
            catch (CoderMalfunctionError e) {
                decodeResult = null;
                LOG.warn("Exception thrown during message decoding. ", (Throwable)e);
            }
            if (decodeResult != null && !decodeResult.isError() && !decodeResult.isOverflow()) {
                out.flip();
                errorMsg = out.toString();
                if (RESULT_MSG_ILLEGAL_CHAR_PTN.matcher(errorMsg).find()) {
                    errorMsg = null;
                }
            }
        }
        return errorMsg;
    }
}

