/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.upload;

import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.CryptoSession;
import ch.dvbern.tax.ge.pp.presentation.cd.util.CodeDeclarationIdentificationCodeCalculator;
import ch.dvbern.tax.ge.pp.transfer.utils.BarcodeConfiguration;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

class UploadRequest {
    private final CryptoSession cryptoSession;
    private final long timestamp = System.currentTimeMillis();
    private String firstName;
    private String lastName;
    private String codeDeclaration;
    private String taxPayerNumber;
    private Boolean departDeces;
    private BarcodeConfiguration barcodeConfiguration;

    UploadRequest() {
        try {
            this.cryptoSession = CryptoSession.newInstance();
        }
        catch (GeneralSecurityException e) {
            throw new InternalFailureException("Failed to load cryptographic session.", (Throwable)e);
        }
    }

    @Nonnull
    static UploadRequest build(@Nonnull BarcodeConfiguration barcodeConfiguration, @Nonnull Map<String, ModelItemDTO> dataModel) {
        Objects.requireNonNull(barcodeConfiguration, "Barcode configuration cannot be null.");
        Objects.requireNonNull(dataModel, "Data model cannot be null.");
        UploadRequest request = new UploadRequest();
        request.firstName = DataModelUtil.getRequiredValue(dataModel, String.class, "Stammdaten.Contribuable.Prenom");
        request.lastName = DataModelUtil.getRequiredValue(dataModel, String.class, "Stammdaten.Contribuable.Nom");
        request.taxPayerNumber = DataModelUtil.getRequiredValue(dataModel, String.class, "Stammdaten.Declaration.NoContribuableBarcode");
        request.codeDeclaration = new CodeDeclarationIdentificationCodeCalculator(TaxmeConfig.getString((String)"steuerjahr")).getCodeDeclarationWithControlCode(request.taxPayerNumber, DataModelUtil.getRequiredValue(dataModel, String.class, "Stammdaten.Declaration.CodeDeclaration"));
        request.barcodeConfiguration = barcodeConfiguration;
        request.departDeces = DataModelUtil.getRequiredValue(dataModel, Boolean.class, "Stammdaten.Declaration.DepartDeces");
        return request;
    }

    @Nonnull
    String getFirstName() {
        return this.firstName;
    }

    @Nonnull
    String getLastName() {
        return this.lastName;
    }

    @Nonnull
    String getCodeDeclaration() {
        return this.codeDeclaration;
    }

    @Nonnull
    String getCodeDeclarationWithoutChecksum() {
        String codeWithoutCHecksum = this.codeDeclaration.replaceAll("[^\\d]", "");
        return codeWithoutCHecksum;
    }

    @Nonnull
    String getTaxPayerNumber() {
        return this.taxPayerNumber;
    }

    @Nonnull
    CryptoSession getCryptoSession() {
        return this.cryptoSession;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    @Nonnull
    BarcodeConfiguration getBarcodeConfiguration() {
        return this.barcodeConfiguration;
    }

    public Boolean isDepartDeces() {
        return this.departDeces;
    }
}

