/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.upload;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.util.LaunchUtil;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UploadLoginDialog
extends Dialog {
    private static final Logger LOG = LoggerFactory.getLogger(UploadLoginDialog.class);
    private static final Pattern JSON_CONTENT_PATTERN = Pattern.compile("\\{.*\\}");
    private final String loginUrl;
    private final String logoutUrl;
    private JsonObject outcome;

    UploadLoginDialog(@Nullable Shell parentShell, @Nonnull String loginUrl, @Nonnull String logoutUrl) {
        super(parentShell);
        Objects.requireNonNull(loginUrl, "Login URL cannot be null");
        this.loginUrl = loginUrl;
        this.logoutUrl = logoutUrl;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.translate((String)"depot.login.dialog.title", (Object[])new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new RowLayout(512));
        StyledText phaseLbl = new StyledText(mainPanel, 0);
        phaseLbl.setBackground(this.getShell().getBackground());
        phaseLbl.setEnabled(false);
        String phase1Txt = Messages.translate((String)"depot.dialog.phase1", (Object[])new Object[0]);
        phaseLbl.setText(phase1Txt + " > " + Messages.translate((String)"depot.dialog.phase2", (Object[])new Object[0]));
        StyleRange style = new StyleRange();
        style.fontStyle = 1;
        style.start = 0;
        style.length = phase1Txt.length();
        phaseLbl.setStyleRange(style);
        final Browser browser = new Browser(parent, 1);
        browser.setLayoutData((Object)GridDataFactory.fillDefaults().hint(600, 600).create());
        browser.setJavascriptEnabled(true);
        browser.setUrl(this.loginUrl);
        browser.addOpenWindowListener(windowEvent -> {
            Browser dummy = new Browser((Composite)this.getShell(), 1);
            dummy.setVisible(false);
            dummy.addLocationListener(new LocationListener(){

                public void changing(LocationEvent locationEvent) {
                    locationEvent.doit = false;
                    Display.getCurrent().asyncExec(() -> LaunchUtil.launchBrowser((String)locationEvent.location));
                }

                public void changed(LocationEvent locationEvent) {
                }
            });
            windowEvent.browser = dummy;
        });
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent locationEvent) {
                Display.getCurrent().asyncExec(() -> {
                    String content = browser.getText();
                    if (content == null) {
                        return;
                    }
                    LOG.info("TLV Received  content: " + content);
                    Matcher m = JSON_CONTENT_PATTERN.matcher(content);
                    if (!m.find()) {
                        LOG.info("TLV No content matched");
                        return;
                    }
                    try {
                        LOG.info("TLV Attempt to parse outcome");
                        UploadLoginDialog.this.outcome = Json.createReader((Reader)new StringReader(m.group())).readObject();
                        LOG.info("TLV Parsing successful");
                    }
                    catch (JsonException e) {
                        LOG.info("TLV No Json content found");
                        return;
                    }
                    boolean urlLoaded = browser.setUrl(UploadLoginDialog.this.logoutUrl);
                    LOG.info("TLV Logout URL called: " + UploadLoginDialog.this.logoutUrl + "with result=" + urlLoaded);
                    Browser.clearSessions();
                    Display.getCurrent().asyncExec(UploadLoginDialog.this::okPressed);
                });
            }
        });
        return browser;
    }

    public void okPressed() {
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    @Nullable
    JsonObject getOutcome() {
        return this.outcome;
    }
}

