/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.upload;

import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DDataDTO;
import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpMainhelpAction;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.LaunchUtil;
import ch.dvbern.tax.common.presentation.cd.util.PrintUtilCD;
import ch.dvbern.tax.common.presentation.cd.util.SystemIdentifier;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.common.presentation.common.print.PrintUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.util.ZipHelper;
import ch.dvbern.tax.ge.pp.justificatifs.ResolvedCategory;
import ch.dvbern.tax.ge.pp.presentation.cd.GeDvbTaxCdSession;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.FSDocumentStore;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.UserDocumentsDialog;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.CryptoSession;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.DepotDialog;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.ReleaseDialog;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.TeleversementSuccessDialog;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadErrorDialog;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadFailureException;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadHistoryDialog;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadHistoryEntry;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadLoginDialog;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadProgressDialog;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadRequest;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadResultDTO;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadResultStore;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadTask;
import ch.dvbern.tax.ge.pp.transfer.utils.Barcode;
import ch.dvbern.tax.ge.pp.transfer.utils.BarcodeConfiguration;
import ch.dvbern.tax.ge.pp.transfer.utils.BarcodeProfile;
import ch.dvbern.tax.ge.pp.transfer.utils.PersistenceKeysRegistry;
import ch.dvbern.tax.ge.pp.upload.ReleaseMode;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import ch.ge.afc.ael.fo.teledeclaration.pp.EnumCodeErreurTeleversement;
import jakarta.json.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ReadOnlyFileSystemException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseAction
extends ActionBase
implements ButtonCommand {
    private static final String LOGIN_URL_CONFIG_KEY = "televersement.login.url";
    private static final String LOGOUT_URL_CONFIG_KEY = "televersement.logout.url";
    private static final Logger LOG = LoggerFactory.getLogger(ReleaseAction.class);
    private static final String DEFAULT_FAILURE_MSG_KEY = "label.upload.error";

    public ReleaseAction() {
        super("menu.upload", "Ctrl+U", "icon.upload");
    }

    public void run() {
        String errorMsg = null;
        try {
            LOG.info("TLV Starting upload procedure.");
            this.runInternal();
            LOG.info("TLV Upload procedure terminated.");
        }
        catch (UploadFailureException e) {
            String errorMsgKey = e.getMessageKey();
            Object[] errorMsgArgs = null;
            if (errorMsgKey == null) {
                errorMsgKey = DEFAULT_FAILURE_MSG_KEY;
            } else {
                errorMsgArgs = e.getMsgArgs();
            }
            LOG.error("TLV Upload failure", (Throwable)e);
            errorMsg = Messages.translate((String)errorMsgKey, (Object[])errorMsgArgs);
        }
        catch (InterruptedException e) {
            LOG.info("TLV Release was interrupted.");
            DialogUtil.showWarningDialog((Shell)TaxmeController.getInstance().getShell(), (String)"release.action.error.cancelled", (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOG.error("TLV Unexpected failure during upload", (Throwable)e);
            errorMsg = Messages.translate((String)DEFAULT_FAILURE_MSG_KEY, (Object[])new Object[0]);
        }
        if (errorMsg != null) {
            MessageWithLinkDialog dlg = new MessageWithLinkDialog(TaxmeController.getInstance().getShell(), Messages.translate((String)"title.error", (Object[])new Object[0]), null, errorMsg, 1, new String[]{Messages.translate((String)"label.button.ok", (Object[])new Object[0])}, 0);
            dlg.open();
        }
    }

    private void runInternal() throws InterruptedException, UploadFailureException {
        String ipAddress = null;
        try {
            URL url = new URL("https://api.ipify.org/");
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            ipAddress = br.readLine();
        }
        catch (MalformedURLException e) {
            LOG.error("TLV Could not open URL to get public IP address");
        }
        catch (IOException e) {
            LOG.error("TLV could not read IP address from URL");
        }
        LOG.info("TLV Client IP address: " + ipAddress);
        LOG.info("TLV Beginning runInternal()");
        TaxmeController ctrl = TaxmeController.getInstance();
        GeDvbTaxCdSession session = (GeDvbTaxCdSession)ctrl.getTmoCdSession();
        Shell parentShell = ctrl.getShell();
        if (!(session.changesSaved() || DialogUtil.showYesNoDialog((Shell)parentShell, (String)"release.action.save", (Object[])new Object[0]) && ctrl.saveFile())) {
            LOG.info("TLV User cancelled mandatory save.");
            return;
        }
        if (ctrl.getMode() == Mode.EXPERT) {
            ctrl.getTmoCdSession().touchCompleteModel();
            ctrl.update();
        }
        try {
            LOG.info("TLV Getting tax file");
            File taxFile = session.getFile();
            try (FSDocumentStore documentStore = session.openDocumentStore();){
                LOG.info("TLV Opening document store");
                assert (documentStore != null) : "TLV Document store not available on saved tax file.";
                this.runInternal(documentStore);
            }
            catch (ReadOnlyFileSystemException rfe) {
                this.openDocumentstoreReadonlyFilesystem(session, taxFile);
            }
        }
        catch (IOException e) {
            throw new UploadFailureException("TLV Failed to access document store.", "documents.action.error", e, new Object[0]);
        }
    }

    private void openDocumentstoreReadonlyFilesystem(GeDvbTaxCdSession session, File taxFile) throws IOException, InterruptedException, UploadFailureException {
        File localFile = File.createTempFile(taxFile.getName(), "");
        FileUtils.copyFile((File)taxFile, (File)localFile);
        session.setFile(localFile);
        try (FSDocumentStore documentStore = session.openDocumentStore();){
            assert (documentStore != null) : "Document store not available on saved tax file.";
            this.runInternal(documentStore);
        }
        FileUtils.deleteQuietly((File)localFile);
        session.setFile(null);
        session.setFile(taxFile);
    }

    private void runInternal(FSDocumentStore documentStore) throws InterruptedException, UploadFailureException {
        List<UploadHistoryEntry> history;
        UploadResultStore resultStore;
        LOG.info("TLV runInternal(documentStore)");
        TaxmeController ctrl = TaxmeController.getInstance();
        GeDvbTaxCdSession session = (GeDvbTaxCdSession)ctrl.getTmoCdSession();
        Shell parentShell = ctrl.getShell();
        int dataModelState = session.getDataModelState();
        boolean readyForRelease = dataModelState == 1 || dataModelState == 2;
        LOG.info("TLV dataModelState= " + dataModelState);
        boolean codeDeclaAvailable = DataModelUtil.getValue(session.getDataModel(), String.class, "Stammdaten.Declaration.CodeDeclaration") != null;
        boolean withAttachements = !documentStore.getIndex().getDocs().isEmpty();
        boolean codeDeclaCorrect = ((ModelItemDTO)session.getDataModel().get("Stammdaten.Declaration.CodeDeclaration")).getState() == 1;
        LOG.info("TLV codeDeclaCorrect= " + codeDeclaCorrect);
        ReleaseDialog releaseDialog = new ReleaseDialog(parentShell, withAttachements, readyForRelease, codeDeclaAvailable, codeDeclaCorrect);
        releaseDialog.open();
        ReleaseMode releaseMode = releaseDialog.getReleaseMode();
        if (releaseMode == null) {
            LOG.info("Release mode dialog cancelled by user.");
            return;
        }
        LOG.info("TLV required documents by category");
        List categories = ResolvedCategory.resolveAll((Map)session.getDataModel(), (Map)session.getLogicModel());
        LOG.info("TLV creating documents dialog");
        UserDocumentsDialog docsDialog = new UserDocumentsDialog(parentShell, documentStore, categories, releaseMode);
        if (docsDialog.open() != 0) {
            throw new InterruptedException("TLV User interrupted documents selection..");
        }
        BarcodeConfiguration barcodeConfiguration = new BarcodeConfiguration(BarcodeProfile.CD, releaseMode).withAttachments(withAttachements).withSystemIdentifiers(SystemIdentifier.getOSIdentifier(), SystemIdentifier.getJVMIdentifier());
        if (releaseMode == ReleaseMode.PRINT) {
            FormRendererConfiguration configuration = GeConstants.newPrintConfiguration();
            long timestamp = System.currentTimeMillis();
            PrintRequest printRequest = PrintUtilCD.newPrintRequest().withConfiguration(configuration).withFormKeys(PrintUtil.getPrintAllKeys((DvbTaxSession)((Object)session)));
            PersistenceKeysRegistry persistenceKeysRegistry = session.getPersistenceKeysRegistry();
            Barcode barcodeGenerator = Barcode.newInstance((PersistenceKeysRegistry)persistenceKeysRegistry, (Map)session.getDataModel());
            Barcode2DDataDTO barcode = barcodeGenerator.generateDTO(barcodeConfiguration);
            configuration.withTimestamp(timestamp).withProperty("barcode", barcode);
            if (TaxmeConfig.isDebugEnabled()) {
                String noContribuable = DataModelUtil.getRequiredValue(session.getDataModel(), String.class, "Stammdaten.Declaration.NoContribuable");
                try {
                    File debugFile = new File(noContribuable + "_interface.xml");
                    FileUtils.writeByteArrayToFile((File)debugFile, (byte[])ZipHelper.unzip(barcode.getData()));
                    LOG.info("Debug file written: " + debugFile.getAbsolutePath());
                }
                catch (IOException e) {
                    LOG.error("Failed to dump barcode file.", (Throwable)e);
                }
            }
            PrintUtilCD.printForms((PrintRequest)printRequest);
            return;
        }
        LOG.info("TLV preparing UploadRequest");
        UploadRequest request = UploadRequest.build(barcodeConfiguration, ctrl.getTmoCdSession().getDataModel());
        byte[] signature = null;
        LOG.info("TLV preparing pre-upload Dialog");
        try {
            Path uploadStoreDir = Paths.get(TaxmeConfig.getString((String)(releaseMode == ReleaseMode.DEPOT ? "user.depot" : "user.televersement")), new String[0]);
            if (!uploadStoreDir.isAbsolute()) {
                uploadStoreDir = Paths.get(TaxmeConfig.getUserHome(), new String[0]).resolve(uploadStoreDir);
            }
            resultStore = UploadResultStore.getInstance(uploadStoreDir);
            history = resultStore.getHistory(request.getTaxPayerNumber());
        }
        catch (IOException e) {
            throw new UploadFailureException("TLV Failed to retrieve upload history.", "release.action.error.history", e, new Object[0]);
        }
        LOG.info("TLV preparing uploadHistory Dialog");
        UploadHistoryDialog dlg = new UploadHistoryDialog(parentShell, releaseMode, history);
        if (dlg.open() != 0) {
            throw new InterruptedException("TLV User cancelled upload on history dialog.");
        }
        if (releaseMode == ReleaseMode.DEPOT) {
            LOG.debug("TLV Invoking login dialog.");
            UploadLoginDialog loginDlg = new UploadLoginDialog(ctrl.getShell(), this.buildLoginURL(releaseMode.getAppVersion(withAttachements), request), TaxmeConfig.getString((String)LOGOUT_URL_CONFIG_KEY));
            loginDlg.open();
            JsonObject outcome = loginDlg.getOutcome();
            if (outcome == null) {
                throw new InterruptedException("TLV User cancelled login request.");
            }
            LOG.debug("TLV Login outcome: {}", (Object)outcome);
            signature = this.processLoginOutcome(request, outcome);
            if (signature == null) {
                LOG.debug("TLV Signature is null");
                return;
            }
            if (0 != new DepotDialog(parentShell).open()) {
                throw new InterruptedException("TLV Cancelled before deposing.");
            }
        }
        LOG.info("TLV beginning upload");
        CryptoSession cryptoSession = request.getCryptoSession();
        LOG.info("TLV creating uploadTask");
        UploadTask uploadTask = new UploadTask(request, documentStore, signature);
        LOG.info("TLV opening upload dialog");
        UploadProgressDialog uploadDialog = new UploadProgressDialog(parentShell, releaseMode);
        try {
            uploadDialog.run(true, true, uploadTask);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (categories instanceof IOException) {
                throw new UploadFailureException("I/O exception encountered during upload.", "label.upload.error.io", e, new Object[0]);
            }
            throw new UploadFailureException("Exception encountered during upload.", e);
        }
        LOG.info("TLV processing upload result");
        UploadResultDTO uploadResult = uploadTask.getUploadResult();
        if (uploadResult.isSuccess()) {
            Path summaryPage;
            LOG.info("TLV upload successfull");
            try {
                LOG.info("TLV decrypt content");
                Cipher cipher = cryptoSession.getCipher();
                cryptoSession.initCipher(cipher, 2);
                byte[] resultContent = uploadResult.getContent();
                if (resultContent == null) {
                    throw new UploadFailureException("TLV No summary page available in response.");
                }
                byte[] pageSynthese = cipher.doFinal(resultContent);
                summaryPage = resultStore.save(pageSynthese, request.getLastName(), request.getFirstName(), request.getTaxPayerNumber(), request.getTimestamp());
            }
            catch (IOException e) {
                throw new UploadFailureException("TLV Failed to persist summary page", "label.upload.error.summary", e, new Object[0]);
            }
            catch (GeneralSecurityException e) {
                throw new UploadFailureException("TLV Failed to decrypt server response", e);
            }
            LOG.info("TLV open summary page.");
            LaunchUtil.launchPdfReader((String)summaryPage.toString());
            if (releaseMode == ReleaseMode.SOUMISSION) {
                LOG.info("TLV open soumission dialog.");
                TeleversementSuccessDialog dlgResult = new TeleversementSuccessDialog(parentShell);
                dlgResult.open();
            } else {
                LOG.info("TLV open depot dialog.");
                assert (releaseMode == ReleaseMode.DEPOT);
                DialogUtil.showInfoDialog((Shell)parentShell, (String)"release.action.depot.success", (Object[])new Object[0]);
            }
        } else {
            LOG.info("TLV displaying error dialog.");
            String errorMsg = uploadResult.getUserErrorMsg();
            assert (errorMsg != null);
            new UploadErrorDialog(parentShell, errorMsg).open();
        }
    }

    @Nonnull
    private String buildLoginURL(String appVersion, UploadRequest request) throws UploadFailureException {
        assert (appVersion != null && request != null);
        String loginUrl = TaxmeConfig.getString((String)LOGIN_URL_CONFIG_KEY);
        if (loginUrl == null) {
            throw new UploadFailureException("Login URL not configured.");
        }
        StringBuilder url = new StringBuilder(loginUrl).append("?");
        url.append("periode=").append(ApplicationConfig.getInstance().getJahr()).append("&");
        url.append("version=").append(appVersion).append("&");
        url.append("provider=").append(BarcodeProfile.CD.getProviderString()).append("&");
        CryptoSession cryptoSession = request.getCryptoSession();
        url.append("cleSession=").append(Base64.encodeBase64URLSafeString((byte[])cryptoSession.getWrappedKey())).append("&");
        try {
            Cipher cipher = cryptoSession.getCipher();
            cryptoSession.initCipher(cipher, 1);
            url.append("idDecla=").append(this.marshallParamValue(cryptoSession, cipher, request.getCodeDeclarationWithoutChecksum())).append("&");
            url.append("sno=").append(this.marshallParamValue(cryptoSession, cipher, request.getTaxPayerNumber())).append("&");
            url.append("dd=").append(request.isDepartDeces() != false ? "1" : "0");
        }
        catch (GeneralSecurityException e) {
            throw new UploadFailureException("Failed to encrypt URL parameter.", e);
        }
        LOG.debug("Login URL: {}", (Object)url);
        return url.toString();
    }

    @Nullable
    private byte[] processLoginOutcome(UploadRequest request, JsonObject outcome) throws UploadFailureException {
        assert (outcome != null);
        String errorMsg = null;
        try {
            String codeStr = outcome.getString("code", null);
            String resultStr = outcome.getString("resultat", null);
            EnumCodeErreurTeleversement code = EnumCodeErreurTeleversement.fromValue((String)codeStr);
            if (code == EnumCodeErreurTeleversement.OK) {
                CryptoSession cryptoSession = request.getCryptoSession();
                Cipher cipher = cryptoSession.getCipher();
                cryptoSession.initCipher(cipher, 2);
                byte[] signature = cipher.doFinal(new Base64(true).decode(resultStr));
                LOG.debug("Signature successfuly decoded ({} bytes).", (Object)signature.length);
                return signature;
            }
            errorMsg = UploadResultDTO.resolveErrorMessage(code, null, null);
            LOG.error("Login failed with code: {}. Result: {}", (Object)code, (Object)resultStr);
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException | GeneralSecurityException e) {
            LOG.error("Failed to unmarshall JSON parameter.", (Throwable)e);
        }
        if (errorMsg != null) {
            UploadErrorDialog dlg = new UploadErrorDialog(TaxmeController.getInstance().getShell(), errorMsg);
            dlg.open();
            return null;
        }
        throw new UploadFailureException("Login failed.", "label.upload.login.fail", null, new Object[0]);
    }

    private String marshallParamValue(CryptoSession cryptoSession, Cipher cipher, String value) throws GeneralSecurityException {
        assert (cryptoSession != null && cipher != null && value != null);
        cryptoSession.initCipher(cipher, 1);
        byte[] ciphered = cipher.doFinal(value.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64URLSafeString((byte[])ciphered);
    }

    public void init(IButtonItem buttonDTO) {
    }

    public void execute(IButtonItem buttonDTO) {
        this.run();
    }

    private static class MessageWithLinkDialog
    extends MessageDialog {
        MessageWithLinkDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        }

        protected Control createMessageArea(Composite composite) {
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
            }
            if (this.message != null) {
                Link messageLabel = new Link(composite, this.getMessageLabelStyle());
                messageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        HelpMainhelpAction help = new HelpMainhelpAction(this.getShell(), event.text);
                        help.run();
                    }
                });
                messageLabel.setText(this.message);
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageLabel);
            }
            return composite;
        }
    }
}

