/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.justificatifs;

import ch.dvbern.tax.ge.pp.justificatifs.UserDocumentCategory;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class UserDocument {
    private static final String CATEGORY_KEY = "category";
    private static final String PATH_KEY = "path";
    private static final String ORIG_FILENAME = "origFilename";
    private static final String DESCRIPTION_KEY = "description";
    private static final String DMK = "dmk";
    private static final String HASH = "hash";
    private final UserDocumentCategory category;
    private final Path path;
    private final String origFilename;
    private final String description;
    private final String dmk;
    private final String hash;
    private final int hashcode;

    UserDocument(@Nonnull UserDocumentCategory category, @Nonnull Path path, @Nonnull String origFilename, @Nonnull String hash, @Nonnull String description, @Nullable String dmk) {
        Objects.requireNonNull(category, "Category cannot be null.");
        Objects.requireNonNull(path, "File path cannot be null.");
        Objects.requireNonNull(origFilename, "Original filename cannot be null.");
        Objects.requireNonNull(description, "Description cannot be null.");
        Objects.requireNonNull(hash, "Hash cannot be null.");
        this.category = category;
        this.path = path;
        this.origFilename = origFilename;
        this.description = description;
        this.dmk = dmk;
        this.hash = hash;
        this.hashcode = new HashCodeBuilder(1445283167, 2048787203).append((Object)category).append((Object)path).append((Object)origFilename).append((Object)description).append((Object)hash).build();
    }

    @Nonnull
    public UserDocumentCategory getCategory() {
        return this.category;
    }

    @Nonnull
    public String getOrigFilename() {
        return this.origFilename;
    }

    @Nonnull
    public String getHash() {
        return this.hash;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    @Nullable
    public String getDmk() {
        return this.dmk;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserDocument) {
            UserDocument that = (UserDocument)obj;
            return this.hashcode == that.hashcode && this.category == that.getCategory() && this.path.equals(that.getPath()) && this.origFilename.equals(that.getOrigFilename()) && this.description.equals(that.getDescription());
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return this.asJson().toString();
    }

    @Nonnull
    static UserDocument load(@Nonnull Path dir, @Nonnull JsonObject value) {
        Objects.requireNonNull(dir, "Storage directory cannot be null.");
        Objects.requireNonNull(value, "JSON value cannot be null.");
        try {
            Path docFile = dir.resolve(value.getString(PATH_KEY));
            String hash = value.getString(HASH);
            return new UserDocument(UserDocumentCategory.valueOf((String)value.getString(CATEGORY_KEY)), docFile, value.getString(ORIG_FILENAME), hash, value.getString(DESCRIPTION_KEY), value.containsKey((Object)DMK) ? value.getString(DMK) : null);
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("Cannot load user document info from JSon value: " + value, e);
        }
    }

    @Nonnull
    JsonObject asJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add(CATEGORY_KEY, this.category.toString());
        builder.add(PATH_KEY, this.path.toString());
        builder.add(ORIG_FILENAME, this.origFilename);
        builder.add(DESCRIPTION_KEY, this.description);
        if (this.dmk != null) {
            builder.add(DMK, this.dmk);
        }
        builder.add(HASH, this.hash);
        return builder.build();
    }
}

