/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.justificatifs;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.ge.pp.justificatifs.UserDocumentCategory;
import ch.dvbern.tax.ge.pp.presentation.cd.GeDvbTaxCdSession;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.DocAlreadyStoredException;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.DocSizeLimitExceededException;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.ExtractBankStatement;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.MaxDocCountExceededException;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.StoreSizeLimitExceededException;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.UnsupportedDocFormatException;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.UserDocument;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import com.lowagie.text.pdf.PdfReader;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSDocumentStore
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(FSDocumentStore.class);
    public static final long MAX_STORE_SIZE = 0x6400000L;
    public static final long MAX_FILE_SIZE = 0xA00000L;
    public static final int MAX_FILE_COUNT = 20;
    static final String HASH_ALGORITHM = "MD5";
    public static boolean hasAttachments = false;
    private Path indexFile;
    private Path docDir;
    private Index index;
    private long totalSize = 0L;

    public FSDocumentStore(@Nonnull Path root) throws IOException {
        Objects.requireNonNull(root, "Root of the store cannot be null.");
        this.createDocumentStore(root);
        hasAttachments = !this.getIndex().getDocs().isEmpty();
    }

    private void createDocumentStore(@Nonnull Path root) throws IOException {
        this.docDir = root.resolve("files");
        this.indexFile = root.resolve("index.json");
        Files.createDirectories(this.docDir, new FileAttribute[0]);
        this.index = this.loadIndex(this.indexFile, this.docDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(@Nonnull Path filePath, @Nonnull UserDocumentCategory category, @Nonnull String description, boolean containsBarcode, @Nullable String rowDmk) throws IOException {
        Objects.requireNonNull(filePath, "File path cannot be null.");
        Objects.requireNonNull(category, "Document category cannot be null.");
        Objects.requireNonNull(description, "Description cannot be null.");
        Index index = this.index;
        synchronized (index) {
            String hash;
            byte[] pdf;
            if (this.index.getDocs().size() >= 20) {
                throw new MaxDocCountExceededException(String.format("Doc count limit reached (%d/%d).", this.index.getDocs().size(), 20));
            }
            long fileSize = Files.size(filePath);
            if (fileSize > 0xA00000L) {
                throw new DocSizeLimitExceededException(String.format("Max file size exceeded: %d (limit: %d).", fileSize, 0xA00000L));
            }
            try (DigestInputStream is = new DigestInputStream(Files.newInputStream(filePath, new OpenOption[0]), MessageDigest.getInstance(HASH_ALGORITHM));){
                pdf = IOUtils.toByteArray((InputStream)is);
                hash = SharedUtils.formatDigest((MessageDigest)is.getMessageDigest());
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalFailureException("Cannot compute hash.", (Throwable)e);
            }
            for (UserDocument userDoc : this.index.getDocs()) {
                if (!hash.equals(userDoc.getHash()) || (long)pdf.length != Files.size(userDoc.getPath())) continue;
                InputStream is = Files.newInputStream(userDoc.getPath(), new OpenOption[0]);
                try {
                    if (!IOUtils.contentEquals((InputStream)new ByteArrayInputStream(pdf), (InputStream)is)) continue;
                    throw new DocAlreadyStoredException();
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            if ((long)pdf.length > 0xA00000L) {
                throw new DocSizeLimitExceededException(String.format("Max file size exceeded: %d (limit: %d).", pdf.length, 0xA00000L));
            }
            if ((long)pdf.length + this.index.getTotalSize() > 0x6400000L) {
                throw new StoreSizeLimitExceededException();
            }
            if (!TaxmeConfig.isDebugEnabled()) {
                try {
                    new PdfReader(pdf);
                }
                catch (Exception e) {
                    throw new UnsupportedDocFormatException("Cannot parse as a PDF file.", e);
                }
            }
            Path target = Files.createTempFile(this.docDir, "doc_", ".dat", new FileAttribute[0]);
            Files.copy(new ByteArrayInputStream(pdf), target, StandardCopyOption.REPLACE_EXISTING);
            ArrayList<UserDocument> docs = new ArrayList<UserDocument>(this.index.docs);
            if (category == UserDocumentCategory.RELEVE_FISCAL && containsBarcode && rowDmk != null) {
                docs.add(new UserDocument(category, target, this.normalize(filePath.getFileName().toString()), hash, this.normalize(description), rowDmk));
                ExtractBankStatement.extract(filePath, description, rowDmk);
            } else {
                docs.add(new UserDocument(category, target, this.normalize(filePath.getFileName().toString()), hash, this.normalize(description), null));
            }
            this.storeIndex(this.indexFile, docs);
            ((GeDvbTaxCdSession)TaxmeController.getInstance().getTmoCdSession()).updateDocumentStore();
        }
    }

    @NotNull
    public String normalize(String filename) {
        String result = Normalizer.normalize(filename, Normalizer.Form.NFD);
        result = result.replaceAll("\\p{M}", "");
        result = result.toLowerCase();
        result = result.replaceAll("[^a-z0-9\\.\\-\\_]", "-");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(UserDocument doc, UserDocumentCategory category, String description) throws IOException {
        Objects.requireNonNull(doc, "Document cannot be null.");
        Objects.requireNonNull(category, "Document category cannot be null.");
        Objects.requireNonNull(description, "Description cannot be null.");
        Index index = this.index;
        synchronized (index) {
            ArrayList<UserDocument> docs = new ArrayList<UserDocument>(this.index.docs);
            if (!docs.remove(doc)) {
                throw new NoSuchElementException("Document does not exists in store: " + doc);
            }
            docs.add(new UserDocument(category, doc.getPath(), doc.getOrigFilename(), doc.getHash(), description, doc.getDmk()));
            this.storeIndex(this.indexFile, docs);
        }
        ((GeDvbTaxCdSession)TaxmeController.getInstance().getTmoCdSession()).updateDocumentStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String dmk) throws IOException {
        Index index = this.index;
        synchronized (index) {
            ArrayList<UserDocument> docs = new ArrayList<UserDocument>(this.index.docs);
            Optional<UserDocument> docToDelete = docs.stream().filter(e -> e.getDmk() != null && e.getDmk().equals(dmk)).findFirst();
            if (!docToDelete.isPresent() || !docs.remove(docToDelete.get())) {
                LOG.info("No document to be deleted: " + docToDelete);
                return;
            }
            this.storeIndex(this.indexFile, docs);
            Files.delete(docToDelete.get().getPath());
            ((GeDvbTaxCdSession)TaxmeController.getInstance().getTmoCdSession()).updateDocumentStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(UserDocument doc) throws IOException {
        Index index = this.index;
        synchronized (index) {
            ArrayList<UserDocument> docs = new ArrayList<UserDocument>(this.index.docs);
            if (!docs.remove(doc)) {
                throw new NoSuchElementException("No such document: " + doc);
            }
            this.storeIndex(this.indexFile, docs);
            Files.delete(doc.getPath());
            ((GeDvbTaxCdSession)TaxmeController.getInstance().getTmoCdSession()).updateDocumentStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Index getIndex() {
        Index index = this.index;
        synchronized (index) {
            return this.index.readOnlyCopy();
        }
    }

    private Index loadIndex(Path indexFile, Path docDir) throws IOException {
        assert (indexFile != null && docDir != null);
        ArrayList<UserDocument> docs = new ArrayList<UserDocument>();
        if (Files.isRegularFile(indexFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(indexFile, StandardCharsets.UTF_8);){
                JsonArray array = Json.createReader((Reader)reader).readArray();
                for (JsonValue value : array) {
                    try {
                        UserDocument doc = UserDocument.load(docDir, (JsonObject)value);
                        Path path = doc.getPath();
                        if (Files.isRegularFile(path, new LinkOption[0])) {
                            this.totalSize += Files.size(path);
                            docs.add(doc);
                            continue;
                        }
                        LOG.error("Ignoring document with invalid path: " + doc);
                    }
                    catch (ClassCastException | IllegalArgumentException e) {
                        LOG.error("Ignoring unparseable JSon object: " + value, (Throwable)e);
                    }
                }
            }
            catch (JsonException e) {
                LOG.error("Failed to parse JSON index file, assume corrupted.", (Throwable)e);
                Files.delete(indexFile);
            }
        }
        Index index = new Index();
        index.docs = docs;
        index.totalSize = this.totalSize;
        return index;
    }

    private void storeIndex(Path indexFile, List<UserDocument> docs) throws IOException {
        long totalSize = 0L;
        try (JsonGenerator generator = Json.createGenerator((OutputStream)new BufferedOutputStream(Files.newOutputStream(indexFile, StandardOpenOption.CREATE)));){
            generator.writeStartArray();
            Iterator<UserDocument> itr = docs.iterator();
            while (itr.hasNext()) {
                UserDocument doc = itr.next();
                Path path = doc.getPath();
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    LOG.error("Ignoring non existing document.");
                    itr.remove();
                    continue;
                }
                totalSize += Files.size(path);
                generator.write((JsonValue)doc.asJson());
            }
            generator.writeEnd();
        }
        this.index.docs = docs;
        this.index.totalSize = totalSize;
        hasAttachments = totalSize > 0L;
    }

    @Override
    public void close() {
        try {
            this.docDir.getFileSystem().close();
        }
        catch (IOException | UnsupportedOperationException exception) {
            // empty catch block
        }
    }

    public static class Index {
        private List<UserDocument> docs;
        private long totalSize;

        @Nonnull
        public List<UserDocument> getDocs() {
            return this.docs;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        private Index readOnlyCopy() {
            Index index = new Index();
            index.docs = Collections.unmodifiableList(new ArrayList<UserDocument>(this.docs));
            index.totalSize = this.totalSize;
            return index;
        }
    }
}

