/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.ge.pp.presentation.cd.util.GeResources;
import ch.dvbern.tax.ge.pp.transfer.dto.TravauxImmeublesDTO;
import ch.dvbern.tax.ge.pp.utils.ImmeublesTravauxSearchHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class ImmeublesTravauxDialog
extends TitleAreaDialog {
    private List listOfTravauxDisplay;
    private final Map<String, TravauxImmeublesDTO> travauxImmeublesDTO;
    private TravauxImmeublesDTO selectedItem;
    ScrolledComposite scrolledComposite;

    public ImmeublesTravauxDialog(Shell parentShell, Map<String, TravauxImmeublesDTO> travauxImmeublesDTO) {
        super(parentShell);
        this.travauxImmeublesDTO = travauxImmeublesDTO;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.translate((String)"immeubles.travaux.dialog.title", (Object[])new Object[0]));
    }

    @Nonnull
    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.translate((String)"immeubles.travaux.dialog.info.title", (Object[])new Object[0]));
        this.setMessage(Messages.translate((String)"immeubles.travaux.dialog.info.message", (Object[])new Object[0]));
        return this.createContent(parent);
    }

    protected boolean isResizable() {
        return true;
    }

    private static void createField(Composite parent, String labelText) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private Composite createForm() {
        Composite result = new Composite((Composite)this.scrolledComposite, 0);
        result.setLayout((Layout)new GridLayout(2, false));
        ImmeublesTravauxDialog.createField(result, "Title");
        ImmeublesTravauxDialog.createField(result, "Salutation");
        ImmeublesTravauxDialog.createField(result, "First name");
        ImmeublesTravauxDialog.createField(result, "Middle name");
        ImmeublesTravauxDialog.createField(result, "Last name");
        ImmeublesTravauxDialog.createField(result, "Maiden name");
        ImmeublesTravauxDialog.createField(result, "Street");
        ImmeublesTravauxDialog.createField(result, "Street supplement");
        ImmeublesTravauxDialog.createField(result, "PO Box");
        ImmeublesTravauxDialog.createField(result, "Zip code");
        ImmeublesTravauxDialog.createField(result, "City");
        ImmeublesTravauxDialog.createField(result, "State");
        ImmeublesTravauxDialog.createField(result, "Country");
        ImmeublesTravauxDialog.createField(result, "Private Phone");
        ImmeublesTravauxDialog.createField(result, "Mobile Phone");
        ImmeublesTravauxDialog.createField(result, "Email address");
        ImmeublesTravauxDialog.createField(result, "Web site");
        return result;
    }

    @Nonnull
    private Control createContent(Composite parent) {
        Composite mainArea = new Composite(parent, 0);
        mainArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        mainArea.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(true).create());
        Composite searchPanel = new Composite(mainArea, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 20;
        layout.marginLeft = 20;
        layout.marginBottom = 20;
        layout.marginRight = 20;
        searchPanel.setLayout((Layout)layout);
        searchPanel.setLayoutData((Object)new GridData());
        Label resolvedCatLabel = new Label(searchPanel, 0);
        resolvedCatLabel.setText(Messages.translate((String)"immeubles.travaux.dialog.filter.search", (Object[])new Object[0]));
        resolvedCatLabel.setFont(GeResources.Font.DIALOG_TITLE.get());
        Text searchText = new Text(searchPanel, 2048);
        GridData gd = new GridData();
        gd.widthHint = 300;
        searchText.setLayoutData((Object)gd);
        SashForm sash = new SashForm(mainArea, 512);
        sash.setBackground(Display.getCurrent().getSystemColor(15));
        sash.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create());
        Composite detailsTravauxPanel = new Composite((Composite)sash, 0);
        detailsTravauxPanel.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(true).create());
        detailsTravauxPanel.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Label searchLabel = new Label(detailsTravauxPanel, 0);
        searchLabel.setText(Messages.translate((String)"label.Immeubles.FraisTravauxEffectifs.TravauxChooserButton", (Object[])new Object[0]));
        searchLabel.setFont(GeResources.Font.DIALOG_TITLE.get());
        final ScrolledComposite scrollPanel = new ScrolledComposite(detailsTravauxPanel, 2560);
        scrollPanel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).indent(0, 5).create());
        scrollPanel.addListener(26, e -> scrollPanel.setFocus());
        final Composite travauxDetailListPanel = new Composite((Composite)scrollPanel, 0);
        scrollPanel.setContent((Control)travauxDetailListPanel);
        travauxDetailListPanel.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).spacing(0, 0).equalWidth(false).margins(0, 0).create());
        travauxDetailListPanel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.listOfTravauxDisplay = new List(travauxDetailListPanel, 516);
        scrollPanel.setExpandVertical(true);
        scrollPanel.setExpandHorizontal(true);
        scrollPanel.setMinSize(-1, 200);
        scrollPanel.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrollPanel.getClientArea();
                scrollPanel.setMinSize(travauxDetailListPanel.computeSize(r.width, -1));
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                ImmeublesTravauxDialog.this.okPressed();
            }
        };
        this.addMouseListener((Control)scrollPanel, (MouseListener)mouseListener);
        this.travauxImmeublesDTO.forEach((key, value) -> this.listOfTravauxDisplay.add(String.valueOf(value.getText())));
        ModifyListener listener = e -> {
            this.listOfTravauxDisplay.removeAll();
            ImmeublesTravauxSearchHelper.filteredTravaux((String)searchText.getText(), this.travauxImmeublesDTO).forEach((key, value) -> this.listOfTravauxDisplay.add(String.valueOf(key)));
        };
        searchText.addModifyListener(listener);
        return mainArea;
    }

    private void addMouseListener(Control ctrl, MouseListener me) {
        ctrl.addMouseListener(me);
        if (ctrl instanceof Composite) {
            for (Control aCtrl : ((Composite)ctrl).getChildren()) {
                this.addMouseListener(aCtrl, me);
            }
        }
    }

    protected void okPressed() {
        this.selectedItem = this.travauxImmeublesDTO.get(this.listOfTravauxDisplay.getSelection()[0]);
        super.okPressed();
    }

    public TravauxImmeublesDTO getSelectedItemDTO() {
        return this.selectedItem;
    }
}

