/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.PrintableAction;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class GePrintDialog
extends TitleAreaDialog {
    private static final int SINGLE_PRINT_BTN_PER_COL = 10;
    private List<Button> singleFormBtns;
    private PrintableAction printAction;

    public GePrintDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.translate((String)"title.shell.print.dialog", (Object[])new Object[0]));
    }

    private void addEmptyCell(Composite parent) {
        assert (parent != null);
        Label emptyLbl = new Label(parent, 0);
        emptyLbl.setVisible(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.translate((String)"title.print.dialog", (Object[])new Object[0]));
        this.setMessage(Messages.translate((String)"label.print.message", (Object[])new Object[0]));
        TaxmeController ctrl = TaxmeController.getInstance();
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout(1, true));
        mainPanel.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create());
        GridDataFactory gdf = GridDataFactory.swtDefaults().align(0x1000000, 4).span(2, 1);
        final Button printAllBtn = new Button(mainPanel, 32);
        printAllBtn.setLayoutData((Object)gdf.align(16384, 4).grab(true, false).create());
        printAllBtn.setText(Messages.translate((String)"label.print.einzelformulare.all", (Object[])new Object[0]));
        Label singlePrintSepLbl = new Label(mainPanel, 258);
        singlePrintSepLbl.setLayoutData((Object)gdf.align(4, 4).create());
        List navItems = ctrl.getTmoCdSession().getExpertNavigationItems();
        ArrayList filteredNavItems = new ArrayList(navItems.size());
        filteredNavItems.addAll(navItems.stream().filter(navigationDTO -> navigationDTO.getPrintState() != 12 && navigationDTO.isPrintEinzeldruck()).collect(Collectors.toList()));
        if (((ExpertDisplayInfoDTO.NavigationDTO)filteredNavItems.get(0)).getFormName().contains("departDeces")) {
            filteredNavItems.remove(0);
        }
        final ArrayList<Button> singleFormBtns = new ArrayList<Button>();
        GridDataFactory singleFormBtnLDFty = GridDataFactory.swtDefaults().hint(-1, -1);
        Composite singlePrintPanel = new Composite(mainPanel, 0);
        singlePrintPanel.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).spacing(10, 5).create());
        singlePrintPanel.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 4).create());
        boolean firstCol = true;
        int total = 0;
        boolean singlePrintBtnEnabled = false;
        int i = 0;
        while (total < filteredNavItems.size()) {
            int effectiveIndex;
            int n = effectiveIndex = firstCol ? i / 2 : i / 2 + 10;
            assert (!firstCol || effectiveIndex < filteredNavItems.size());
            assert (singleFormBtns.size() <= filteredNavItems.size());
            if (effectiveIndex >= filteredNavItems.size()) {
                this.addEmptyCell(singlePrintPanel);
            } else {
                ++total;
                ExpertDisplayInfoDTO.NavigationDTO navigationDTO2 = (ExpertDisplayInfoDTO.NavigationDTO)filteredNavItems.get(effectiveIndex);
                final Button singleFormBtn = new Button(singlePrintPanel, 96);
                singleFormBtn.setData((Object)navigationDTO2);
                singleFormBtn.setText(Messages.translate((String)("nav.expert." + navigationDTO2.getFormName()), (Object[])new Object[0]));
                int state = navigationDTO2.getState();
                boolean enabled = state == 1 || state == 2;
                singleFormBtn.setEnabled(enabled);
                singlePrintBtnEnabled |= enabled;
                singleFormBtns.add(firstCol ? effectiveIndex : singleFormBtns.size(), singleFormBtn);
                singleFormBtn.setLayoutData((Object)singleFormBtnLDFty.create());
                singleFormBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        if (!singleFormBtn.getSelection()) {
                            printAllBtn.setSelection(false);
                        }
                    }
                });
            }
            ++i;
            firstCol = !firstCol;
        }
        printAllBtn.setEnabled(singlePrintBtnEnabled);
        printAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean selected = printAllBtn.getSelection();
                singleFormBtns.stream().filter(Control::isEnabled).forEach(btn -> btn.setSelection(selected));
            }
        });
        assert (singleFormBtns.size() == filteredNavItems.size());
        this.singleFormBtns = singleFormBtns;
        return parent;
    }

    private List<FormKey> getChecked() {
        ArrayList<FormKey> checked = new ArrayList<FormKey>();
        this.singleFormBtns.stream().filter(Button::getSelection).forEach(singleFormBtn -> {
            ExpertDisplayInfoDTO.NavigationDTO navigationDTO = (ExpertDisplayInfoDTO.NavigationDTO)singleFormBtn.getData();
            this.addSubItems(navigationDTO, checked);
        });
        return checked;
    }

    private void addSubItems(ExpertDisplayInfoDTO.NavigationDTO navigationDTO, List<FormKey> items) {
        if (navigationDTO.getSubItems() != null) {
            navigationDTO.getSubItems().stream().filter(childDTO -> childDTO.getPrintState() != 12).forEach(childDTO -> this.addSubItems((ExpertDisplayInfoDTO.NavigationDTO)childDTO, items));
        } else {
            FormKey key = new FormKey(navigationDTO.getAccessKey(), Mode.EXPERT);
            items.add(key);
        }
    }

    public PrintableAction getPrintAction() {
        return this.printAction;
    }

    protected void okPressed() {
        MessageDialog dlg = new MessageDialog(this.getShell(), Messages.translate((String)"title.info", (Object[])new Object[0]), null, Messages.translate((String)"label.print.warnung.kopie", (Object[])new Object[0]), 2, new String[]{Messages.translate((String)"label.button.ok", (Object[])new Object[0])}, 0){

            protected Control createMessageArea(Composite composite) {
                Control ctrl = super.createMessageArea(composite);
                this.messageLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
                return ctrl;
            }
        };
        dlg.open();
        final List<FormKey> checked = this.getChecked();
        if (!checked.isEmpty()) {
            this.printAction = new PrintableAction(){

                public List<FormKey> getFormKeys() {
                    return checked;
                }

                public FormRendererConfiguration getConfiguration() {
                    return new FormRendererConfiguration().withCopyWatermark(true);
                }
            };
        }
        super.okPressed();
    }
}

