/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.action;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.ge.pp.justificatifs.ResolvedCategory;
import ch.dvbern.tax.ge.pp.presentation.cd.GeDvbTaxCdSession;
import ch.dvbern.tax.ge.pp.presentation.cd.action.enums.PdfType;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.FSDocumentStore;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.UserDocumentsDialog;
import java.io.File;
import java.io.IOException;
import java.nio.file.ReadOnlyFileSystemException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDocumentsAction
extends ActionBase
implements ButtonCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserDocumentsAction.class);
    @Nonnull
    private PdfType pdfType;
    private String rowDmk = null;

    public UserDocumentsAction(@Nonnull PdfType pdfType) {
        super("documents.action", null, "icon.document");
        this.pdfType = pdfType;
    }

    public void init(IButtonItem buttonDTO) {
    }

    public void execute(IButtonItem buttonDTO) {
        this.rowDmk = EngineUtil.getOuterTableRowDmk(buttonDTO.getCommandDmk());
        this.run();
        TaxmeController.getInstance().update();
    }

    public void run() {
        TaxmeController ctrl = TaxmeController.getInstance();
        GeDvbTaxCdSession session = (GeDvbTaxCdSession)ctrl.getTmoCdSession();
        if (session.getFile() == null) {
            if (!DialogUtil.showYesNoDialog((Shell)TaxmeController.getInstance().getShell(), (String)"documents.action.save", (Object[])new Object[0])) {
                return;
            }
            if (!ctrl.saveFile()) {
                return;
            }
        }
        switch (this.pdfType) {
            case GENERIC: {
                try {
                    this.openDocumentStore(ctrl, session);
                }
                catch (ReadOnlyFileSystemException rfe) {
                    this.openDocumentStoreReadonlyFilesystem(ctrl, session);
                }
                break;
            }
            case RELEVE_FISCAL_WITH_BARCODE: {
                this.openDocumentStoreEReleve(ctrl, session);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid UserDocumentsAction.BarcodeReadingMode " + this.pdfType);
            }
        }
    }

    private void openDocumentStoreReadonlyFilesystem(TaxmeController ctrl, GeDvbTaxCdSession session) {
        File taxFile = session.getTaxFile().getFile();
        try {
            File localFile = File.createTempFile(session.getTaxFile().getFile().getName(), "");
            FileUtils.copyFile((File)taxFile, (File)localFile);
            session.setFile(localFile);
            this.openDocumentStore(ctrl, session);
            FileUtils.deleteQuietly((File)localFile);
            session.setFile(null);
            session.setFile(taxFile);
        }
        catch (IOException e) {
            LOG.error("Cannot retrieve document store instance.");
            DialogUtil.showErrorDialog((Shell)ctrl.getShell(), (String)"documents.action.error", (Object[])new Object[0]);
        }
    }

    private void openDocumentStore(TaxmeController ctrl, GeDvbTaxCdSession session) {
        try (FSDocumentStore documentStore = session.openDocumentStore();){
            List categories = ResolvedCategory.resolveAll((Map)session.getDataModel(), (Map)session.getLogicModel());
            UserDocumentsDialog dlg = new UserDocumentsDialog(ctrl.getShell(), documentStore, categories, null);
            dlg.open();
        }
        catch (IOException e) {
            LOG.error("Cannot retrieve document store instance.");
            DialogUtil.showErrorDialog((Shell)ctrl.getShell(), (String)"documents.action.error", (Object[])new Object[0]);
        }
    }

    private void openDocumentStoreEReleve(TaxmeController ctrl, GeDvbTaxCdSession session) {
        try (FSDocumentStore documentStore = session.openDocumentStore();){
            List categories = ResolvedCategory.resolveAll((Map)session.getDataModel(), (Map)session.getLogicModel());
            List<ResolvedCategory> filteredCategories = categories.stream().filter(category -> category.getLabel().equals(Messages.translate((String)"label.justificatifs.category.titres", (Object[])new Object[0]))).collect(Collectors.toList());
            UserDocumentsDialog dlg = new UserDocumentsDialog(ctrl.getShell(), documentStore, filteredCategories, null, this.pdfType, this.rowDmk);
            dlg.open();
        }
        catch (IOException e) {
            LOG.error("Cannot retrieve document store instance.");
            DialogUtil.showErrorDialog((Shell)ctrl.getShell(), (String)"documents.action.error", (Object[])new Object[0]);
        }
    }
}

