/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.action;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.DocumentAction;
import ch.dvbern.tax.common.presentation.cd.util.LaunchUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentSaveAsAction
extends DocumentAction {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentSaveAsAction.class);
    public static final String INFO_TITLE_KEY = "label.dialog.documentSaveAs.title";
    public static final String INFO_MSG_KEY = "label.dialog.documentSaveAs.msg";
    public static final String ERROR_MSG_KEY = "label.dialog.documentSaveAs.error";
    public static final String CONFIRM_OVERWRITE_KEY = "label.dialog.documentSaveAs.confirmOverwrite";
    private static final Pattern FILE_EXT_PATTERN = Pattern.compile(".*\\.(\\w+)");
    private final String filename;
    private final boolean translate;
    private final String[] filterExts;

    public DocumentSaveAsAction(String filename, String menuname) {
        this(filename, menuname, false);
    }

    public DocumentSaveAsAction(String filename, String menuname, boolean translate) {
        super(filename, menuname, translate);
        if (filename == null) {
            throw new NullPointerException("Filename cannot be null.");
        }
        this.filename = filename;
        this.translate = translate;
        Matcher m = FILE_EXT_PATTERN.matcher(filename);
        if (m.matches()) {
            String autoFilter = "*." + m.group(1);
            this.filterExts = new String[2];
            this.filterExts[0] = autoFilter;
        } else {
            this.filterExts = new String[1];
        }
        this.filterExts[this.filterExts.length - 1] = "*.*";
    }

    @Nonnull
    public String getFilename() {
        return this.filename;
    }

    public void execute() {
        MessageDialog overwriteDlg;
        File src = new File(TaxmeConfig.getDocumentDir((boolean)this.translate), this.filename);
        if (!src.isFile() || !src.canRead()) {
            LOG.error("Failed to read source file: {}", (Object)src.getAbsolutePath());
            return;
        }
        Shell parent = TaxmeController.getInstance().getShell();
        String title = Messages.translate((String)INFO_TITLE_KEY, (Object[])new Object[0]);
        MessageDialog infoDlg = new MessageDialog(parent, title, null, Messages.translate((String)INFO_MSG_KEY, (Object[])new Object[0]), 2, new String[]{Messages.translate((String)"label.button.ok", (Object[])new Object[0])}, 0);
        FileDialog fileDlg = new FileDialog(parent, 8192);
        fileDlg.setFileName(this.filename);
        fileDlg.setFilterExtensions(this.filterExts);
        infoDlg.open();
        String savePath = fileDlg.open();
        if (savePath == null || savePath.length() == 0) {
            return;
        }
        File dest = new File(savePath);
        if (dest.exists() && (overwriteDlg = new MessageDialog(parent, title, null, Messages.translate((String)CONFIRM_OVERWRITE_KEY, (Object[])new Object[0]), 2, new String[]{Messages.translate((String)"label.button.ja", (Object[])new Object[0]), Messages.translate((String)"label.button.nein", (Object[])new Object[0])}, 1)).open() != 0) {
            return;
        }
        try {
            FileUtils.copyFile((File)src, (File)dest);
        }
        catch (IOException e) {
            MessageDialog errorDlg = new MessageDialog(parent, title, null, Messages.translate((String)ERROR_MSG_KEY, (Object[])new Object[0]), 1, new String[]{Messages.translate((String)"label.button.ok", (Object[])new Object[0])}, 0);
            errorDlg.open();
            return;
        }
        String filePath = dest.getAbsolutePath();
        if (filePath.endsWith(".pdf")) {
            LaunchUtil.launchPdfReader((String)filePath);
        } else {
            LaunchUtil.launch((String)filePath);
        }
    }
}

