/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.action;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ButtonDeleteAction;
import ch.dvbern.tax.common.presentation.cd.items.ITableRow;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.presentation.cd.GeDvbTaxCdSession;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.FSDocumentStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteRowAndLinkedFileAction
extends ButtonDeleteAction {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteRowAndLinkedFileAction.class);
    public static final String RELEVE_FISCAL = "RF";

    public DeleteRowAndLinkedFileAction() {
        super("label.question.delete.table");
    }

    public void run(Object data) {
        TableViewer tableViewer = (TableViewer)data;
        StructuredSelection selection = (StructuredSelection)tableViewer.getSelection();
        TaxmeController ctrl = TaxmeController.getInstance();
        GeDvbTaxCdSession session = (GeDvbTaxCdSession)ctrl.getTmoCdSession();
        @NonNull Map model = Objects.requireNonNull(session.getDataModel());
        if (selection.isEmpty()) {
            return;
        }
        Table table = tableViewer.getTable();
        List<TableItem> tableItems = Arrays.asList(table.getSelection());
        if (tableItems.isEmpty()) {
            return;
        }
        String messageKey = this.getMessageKey(tableViewer);
        if (messageKey != null && DialogUtil.showConfirmDialog((String)messageKey, (Object[])new Object[0])) {
            ITableRow selectedRow = (ITableRow)selection.getFirstElement();
            ArrayList<String> rowDmks = this.findRelatedRows(model, selectedRow);
            if (rowDmks.isEmpty()) {
                rowDmks.add(selectedRow.getDmkTableEntry());
            }
            for (String dmkToDelete : rowDmks) {
                session.delete(dmkToDelete);
                ctrl.update();
                try (FSDocumentStore documentStore = session.openDocumentStore();){
                    documentStore.remove(dmkToDelete);
                }
                catch (IOException e) {
                    LOG.error("Cannot retrieve document store instance.");
                    DialogUtil.showErrorDialog((Shell)ctrl.getShell(), (String)"documents.action.error", (Object[])new Object[0]);
                }
                catch (NoSuchElementException nse) {
                    LOG.info("Nothing to delete in Document Store");
                }
                catch (IllegalStateException ise) {
                    LOG.info(ise.getMessage());
                }
            }
        }
    }

    private @NonNull ArrayList<String> findRelatedRows(@NonNull Map<String, ModelItemDTO> model, @NonNull ITableRow selectedRow) {
        ArrayList<String> rowDmks = new ArrayList<String>();
        String tableDmk = selectedRow.getTable().getTableDmk();
        ModelItemDTO groupNoDto = Objects.requireNonNull(model).get(selectedRow.getDmkTableEntry() + ".GroupNo");
        if (groupNoDto != null && groupNoDto.getValue() != null && (Long)groupNoDto.getValue() != 0L) {
            Long groupNo = (Long)groupNoDto.getValue();
            ModelItemDTO tableDto = (ModelItemDTO)Objects.requireNonNull(TaxmeController.getInstance().getTmoCdSession().getDataModel()).get(tableDmk);
            ((HashSet)Objects.requireNonNull(tableDto.getValue())).forEach(rowNo -> {
                String rowDmk = tableDmk + "." + rowNo;
                String groupNoDmk = rowDmk + ".GroupNo";
                if (((ModelItemDTO)model.get(groupNoDmk)).getValue() == groupNo) {
                    rowDmks.add(rowDmk);
                }
            });
        }
        return rowDmks;
    }

    private @Nullable String getMessageKey(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        List<TableItem> tableItems = Arrays.asList(table.getSelection());
        if (tableItems.isEmpty()) {
            return null;
        }
        String cellContent = tableItems.get(0).getText(1);
        String messageKey = cellContent.equals(RELEVE_FISCAL) ? "label.question.delete.table.releveFiscal" : this.getConfirmMsgKey();
        return messageKey;
    }
}

