/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.action;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.presentation.cd.dialog.InfoMandataireDialog;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInitAction
extends ActionBase {
    private static final Logger LOG = LoggerFactory.getLogger(CaseInitAction.class);
    private static final String KEY_FIRST_TIME_START = "first.time.start";
    public static final String KEY_QUESTION = "Stammdaten.MandataireOuiNon";
    public static final String KEY_NOM = "Stammdaten.MandataireNom";
    public static final String KEY_NO = "Stammdaten.MandataireNo";
    public static final String KEY_RUE = "Stammdaten.MandataireRue";
    public static final String KEY_NPA = "Stammdaten.MandataireNpa";
    public static final String KEY_LOCALITE = "Stammdaten.MandataireLieu";
    public static final String KEY_EMAIL = "Stammdaten.MandataireEmail";
    public static final String KEY_TEL = "Stammdaten.MandataireTel";
    private static final String KEY_SHOW_NEXT_START_FIN_ASSUJ = "dialog.welcome.shownextstart.departDeces";
    private static final String KEY_SHOW_NEXT_START = "dialog.welcome.shownextstart";

    public CaseInitAction() {
        this("");
    }

    public CaseInitAction(String name) {
        super(name);
    }

    public void run() {
        boolean firstTimeStart = TaxmeConfig.getBoolean((String)KEY_FIRST_TIME_START);
        if (firstTimeStart) {
            InfoMandataireDialog dlg = new InfoMandataireDialog(Display.getCurrent().getActiveShell());
            dlg.setBlockOnOpen(true);
            dlg.open();
            TaxmeConfig.setValue((String)KEY_FIRST_TIME_START, (boolean)false);
            TaxmeConfig.setValue((String)KEY_SHOW_NEXT_START_FIN_ASSUJ, (boolean)true);
        }
        this.setValuesToModel();
    }

    private void createDepartDecesContent(Composite parent) {
    }

    protected void setValuesToModel() {
        ModelItemDTO question = new ModelItemDTO(TaxmeConfig.getBoolean((String)KEY_QUESTION));
        question.setTouched();
        TaxmeController.getInstance().getTmoCdSession().updateSilent(Collections.singletonMap(KEY_QUESTION, question));
        ModelItemDTO nom = new ModelItemDTO(TaxmeConfig.getString((String)KEY_NOM));
        ModelItemDTO no = new ModelItemDTO(TaxmeConfig.getString((String)KEY_NO));
        ModelItemDTO rue = new ModelItemDTO(TaxmeConfig.getString((String)KEY_RUE));
        ModelItemDTO npa = new ModelItemDTO(TaxmeConfig.getString((String)KEY_NPA));
        ModelItemDTO lieu = new ModelItemDTO(TaxmeConfig.getString((String)KEY_LOCALITE));
        ModelItemDTO email = new ModelItemDTO(TaxmeConfig.getString((String)KEY_EMAIL));
        ModelItemDTO tel = new ModelItemDTO(TaxmeConfig.getString((String)KEY_TEL));
        HashMap<String, ModelItemDTO> toStore = new HashMap<String, ModelItemDTO>();
        toStore.put(KEY_NOM, nom);
        toStore.put(KEY_NO, no);
        toStore.put(KEY_RUE, rue);
        toStore.put(KEY_NPA, npa);
        toStore.put(KEY_LOCALITE, lieu);
        toStore.put(KEY_EMAIL, email);
        toStore.put(KEY_TEL, tel);
        toStore.values().forEach(ModelItemDTO::setTouched);
        TaxmeController.getInstance().getTmoCdSession().updateSilent(toStore);
    }
}

