/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd;

import ch.dvbern.lib.cryptutil.readers.PKCS8PEMCertReader;
import ch.dvbern.lib.update.signatures.MultiMethodSignatureVerifier;
import ch.dvbern.lib.update.signatures.SignMethod;
import ch.dvbern.lib.update.signatures.SignatureVerifier;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.integration.CustomModelValueImporter;
import ch.dvbern.tax.common.presentation.bd.cd.AbstractDvbTaxCdSessionImpl;
import ch.dvbern.tax.common.presentation.cd.Taxme;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.TaxmeLauncher;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.action.BrowserExecuter;
import ch.dvbern.tax.common.presentation.cd.action.ButtonOpenLinkAction;
import ch.dvbern.tax.common.presentation.cd.action.PrintAllAction;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommands;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfig;
import ch.dvbern.tax.common.presentation.cd.util.TaxmeConfigurator;
import ch.dvbern.tax.common.presentation.cd.wizard.FormNavigationPart;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinterFactory;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TableAdditionItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.engine.printer.GeTableAdditionPrinter;
import ch.dvbern.tax.ge.pp.presentation.cd.GeTaxWindow;
import ch.dvbern.tax.ge.pp.presentation.cd.GeTaxmeController;
import ch.dvbern.tax.ge.pp.presentation.cd.action.CaseInitAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.ChangeLanguageAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.DeleteRowAndLinkedFileAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.FileNewActionDepartDeces;
import ch.dvbern.tax.ge.pp.presentation.cd.action.GeFileNewAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.GeFileOpenAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.GeOpenXMLAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.GePPOpenLinkAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.GePrintAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.GeTablerowClickAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.ImmeublesTravauxAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.TitreGeTaxSearch;
import ch.dvbern.tax.ge.pp.presentation.cd.action.UserDocumentsAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.UtilInfoMandataireAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.ValorSearchAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.enums.PdfType;
import ch.dvbern.tax.ge.pp.presentation.cd.dialog.ValorDatabaseDialog;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.ReleaseAction;
import ch.dvbern.tax.ge.pp.presentation.cd.util.GeResources;
import ch.dvbern.tax.ge.pp.presentation.cd.util.TaxmeGeFilename;
import ch.dvbern.tax.ge.pp.utils.DataModelFixer;
import ch.dvbern.tax.ge.pp.utils.DataResourceImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.RGB;

public final class TaxmeGeLauncher {
    public static final String FORMS_DIR_STANDARD = "config/cd/forms/";
    public static final String SIGNED_KEY_NAME_PROD = "ge-signing_PROD.pub";

    private TaxmeGeLauncher() {
    }

    public static void main(String[] args) {
        TaxmeConfig.load((File)new File("config/cd/app-config.properties"));
        TaxmeConfig.setDataResource((DataResource)DataResourceImpl.getInstance());
        TaxmeConfig.setExpertModeEnabled((boolean)true);
        TaxmeConfig.setWizardModeEnabled((boolean)true);
        TaxmeConfig.setValue((String)"forms.dir", (String)FORMS_DIR_STANDARD);
        boolean debugEnabled = System.getProperty("DebugEnabled", "").equals("777");
        TaxmeConfig.setValue((String)"DebugEnabled", (boolean)debugEnabled);
        TaxmeConfig.setValue((String)"user.savedir", (String)TaxmeConfig.getString((String)"user.savedir"));
        TaxmeConfig.setValue((String)"user.importdir", (String)TaxmeConfig.getString((String)"user.importdir"));
        TaxmeConfig.setValue((String)"user.printdir", (String)TaxmeConfig.getString((String)"user.printdir"));
        TaxmeConfig.setValue((String)"user.config", (String)TaxmeConfig.getString((String)"user.config"));
        TaxmeConfig.setValue((String)"file.history.size", (String)TaxmeConfig.getString((String)"file.history.size"));
        TaxmeConfig.setValue((String)"autosave.savedir", (String)TaxmeConfig.getString((String)"autosave.savedir"));
        TaxmeConfig.setValue((String)"user.televersement", (String)TaxmeConfig.getString((String)"user.televersement"));
        TaxmeConfig.setValue((String)"user.depot", (String)TaxmeConfig.getString((String)"user.depot"));
        TaxmeConfig.setValue((String)"user.valor.updateURL", (String)TaxmeConfig.getString((String)"user.valor.updateURL"));
        TaxmeConfig.setValue((String)"user.valor", (String)TaxmeConfig.getString((String)"user.valor"));
        MultiMethodSignatureVerifier updateVerifier = TaxmeGeLauncher.readUpdateSignatureCertificate();
        TaxmeConfig.setUpdateSignatureVerifier((SignatureVerifier)updateVerifier);
        GeTaxmeController ctrl = new GeTaxmeController();
        TaxmeController.setInstance((TaxmeController)ctrl);
        HashMap<String, ModelItemDTO> changes = new HashMap<String, ModelItemDTO>();
        changes.put("Stammdaten.IsOfflineSelected", new ModelItemDTO(Boolean.TRUE));
        TaxmeConfigurator.setSpecificInitValues(changes);
        ButtonCommands.register((String)"/shares.database.cmd", (ButtonCommand)new ValorDatabaseDialog.ValorDatabaseButtonCommand());
        ButtonCommands.register((String)"/print.cmd", (ButtonCommand)new GePrintAction());
        ButtonCommands.register((String)"/release.cmd", (ButtonCommand)new ReleaseAction());
        ButtonCommands.register((String)"/open.url.cmd", (ButtonCommand)new BrowserExecuter());
        ButtonCommands.register((String)"/open.titres.url.cmd", (ButtonCommand)new TitreGeTaxSearch());
        ButtonCommands.register((String)"/link.cmd", (ButtonCommand)new GePPOpenLinkAction());
        ButtonCommands.register((String)"/valor.search.cmd", (ButtonCommand)new ValorSearchAction());
        ButtonCommands.register((String)"/add.releve.fiscal.cmd", (ButtonCommand)new UserDocumentsAction(PdfType.RELEVE_FISCAL_WITH_BARCODE));
        ButtonCommands.register((String)"/gestion.des.justificatifs.cmd", (ButtonCommand)new UserDocumentsAction(PdfType.GENERIC));
        ButtonCommands.register((String)"/immeubles.travaux.search.cmd", (ButtonCommand)new ImmeublesTravauxAction());
        FormNavigationPart.setOkCancelPostion((int)2);
        ActionRegistry reg = ActionRegistry.getInstance();
        reg.registerAction("treuhand", (Action)new UtilInfoMandataireAction());
        reg.registerAction("DEPARTDECES", (Action)new FileNewActionDepartDeces());
        reg.registerAction("new", (Action)new GeFileNewAction());
        reg.registerAction("open", (Action)new GeFileOpenAction());
        reg.registerAction("init", (Action)new CaseInitAction());
        reg.registerAction("print", (Action)new GePrintAction());
        reg.registerAction("table.delete", (Action)new DeleteRowAndLinkedFileAction());
        reg.registerAction("link.www", (Action)new ButtonOpenLinkAction("http://www.getax.ch/pp"));
        reg.registerAction("table.row.click", (Action)new GeTablerowClickAction());
        reg.createCustomMenu("menu.document");
        reg.addCustomMenuAction("menu.document", (Action)new ButtonOpenLinkAction("label.menu.documents.document_1", "https://www.getax.ch/support/guides", "", false));
        reg.addCustomMenuAction("menu.document", (Action)new ButtonOpenLinkAction("label.menu.documents.document_2", "https://www.ge.ch/c/guidepp2024", "", false));
        reg.addCustomMenuAction("menu.document", (Action)new ButtonOpenLinkAction("label.menu.documents.document_3", "https://www.ge.ch/c/guide-indep", "", false));
        reg.addCustomMenuAction("menu.document", (Action)new ButtonOpenLinkAction("label.menu.documents.document_4", "https://www.ge.ch/c/snp", "", false));
        reg.addCustomMenuAction("menu.document", (Action)new ButtonOpenLinkAction("label.menu.documents.document_5", "https://www.ge.ch/c/qvalo", "", false));
        reg.addCustomMenuAction("menu.document", (Action)new ButtonOpenLinkAction("label.menu.documents.document_6", "https://www.ge.ch/c/imp-difi", "", false));
        reg.addCustomMenuAction("menu.document", (Action)new ButtonOpenLinkAction("label.menu.documents.document_7", "https://www.ge.ch/c/qvalo", "", false));
        if (TaxmeConfig.getBoolean((String)"switchLanguageEnable")) {
            reg.createCustomMenu("menu.language");
            ChangeLanguageAction fr = new ChangeLanguageAction("label.menu.langue.fr", "fr");
            ChangeLanguageAction en = new ChangeLanguageAction("label.menu.langue.en", "en");
            fr.setOther(en);
            en.setOther(fr);
            reg.addCustomMenuAction("menu.language", (Action)fr);
            reg.addCustomMenuAction("menu.language", (Action)en);
        }
        if (TaxmeConfig.getBoolean((String)"DebugEnabled") || TaxmeConfig.getBoolean((String)"ouvertureXML")) {
            reg.createCustomMenu("menu.xml");
            reg.addCustomMenuAction("menu.xml", (Action)new GeOpenXMLAction(false));
            reg.addCustomMenuAction("menu.xml", (Action)new GeOpenXMLAction(true));
        }
        ItemPrinterFactory.putExpertPrinter(TableAdditionItem.class, (ItemPrinter<? extends ExpertDisplayInfoDTO.ItemDTO>)new GeTableAdditionPrinter());
        GuiUtil.getColorRegistry().put(GuiUtil.COLOR_RED, new RGB(232, 59, 57));
        PrintAllAction.setAskForSave((boolean)true);
        TaxFileConfig.setInstance((TaxFileConfig)new TaxmeGeFilename());
        Taxme.setImplementation(GeTaxWindow.class);
        AbstractDvbTaxCdSessionImpl.addCustomModelValueImporter((CustomModelValueImporter)DataModelFixer.INSTANCE);
        GeResources.init();
        TaxmeLauncher.launchTaxme();
    }

    @Nonnull
    private static MultiMethodSignatureVerifier readUpdateSignatureCertificate() {
        MultiMethodSignatureVerifier multiMethodSignatureVerifier;
        block8: {
            String resourcePath = TaxmeGeLauncher.buildCertificateResourcePath(SIGNED_KEY_NAME_PROD);
            InputStream cert = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
            try {
                MultiMethodSignatureVerifier updateVerifier;
                multiMethodSignatureVerifier = updateVerifier = new MultiMethodSignatureVerifier((PublicKey)new PKCS8PEMCertReader(cert).readPublicKey(), Arrays.asList(SignMethod.SHA256withRSA, SignMethod.SHA512withRSA), "");
                if (cert == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cert != null) {
                        try {
                            cert.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not read certificate for update verification @" + resourcePath, e);
                }
            }
            cert.close();
        }
        return multiMethodSignatureVerifier;
    }

    @Nonnull
    private static String buildCertificateResourcePath(@NonNull String filename) {
        String resourceDir = TaxmeConfig.getString((String)"update-site.certpath");
        if (StringUtils.isBlank((CharSequence)resourceDir)) {
            resourceDir = "certs/prod";
        }
        return resourceDir + "/" + filename;
    }
}

