/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd;

import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.common.util.TaxFileUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import ch.dvbern.tax.ge.pp.presentation.cd.GeTaxWindow;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeTaxmeController
extends TaxmeController {
    private static final Logger LOG = LoggerFactory.getLogger(GeTaxmeController.class);

    public void setTitle() {
        if (((GeTaxWindow)this.getApp()).isDepartDeces()) {
            this.setTitle("taxme.cd.title.departDeces", new Object[]{((GeTaxWindow)this.getApp()).getDepartDecesSteuerjahr()});
        } else {
            this.setTitle("taxme.cd.title", new Object[]{ApplicationConfig.getInstance().getJahr()});
        }
    }

    public void openFile(File file, boolean force) {
        if (file == null) {
            super.openFile(file, force);
            return;
        }
        boolean isDepartDecesAction = ((GeTaxWindow)TaxmeController.getInstance().getApp()).isDepartDeces();
        try {
            boolean isDepartOrDeces;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            Map<String, ModelItemDTO> oldDatamodel = TaxFileUtil.read(in, "");
            boolean isDeces = DataModelUtil.getValue(oldDatamodel, Boolean.class, "Stammdaten.IsDeces");
            boolean isDepart = DataModelUtil.getValue(oldDatamodel, Boolean.class, "Stammdaten.IsDepart");
            boolean bl = isDepartOrDeces = isDeces || isDepart;
            if (isDepartOrDeces && !isDepartDecesAction) {
                DialogUtil.showErrorDialog((String)"error.open.departDeces", (Object[])new Object[0]);
                return;
            }
            super.openFile(file, force);
            Map map = this.getTmoCdSession().getDataModel();
        }
        catch (InvalidAuthenticationException | FileNotFoundException e) {
            DialogUtil.showErrorDialog((String)"error.open.corrupt.file", (Object[])new Object[0]);
        }
    }
}

