/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.Taxme;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.ge.pp.ictax.ICTAXXMLDatabaseUpdateAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.FileImportActionDepartDeces;
import ch.dvbern.tax.ge.pp.presentation.cd.action.FileInfoDepartDeces;
import ch.dvbern.tax.ge.pp.presentation.cd.action.FileNewActionDepartDeces;
import ch.dvbern.tax.ge.pp.presentation.cd.action.FileOpenActionDepartDeces;
import ch.dvbern.tax.ge.pp.presentation.cd.action.GeFileNewAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.GePrintAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.UserDocumentsAction;
import ch.dvbern.tax.ge.pp.presentation.cd.action.enums.PdfType;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.ReleaseAction;
import ch.dvbern.tax.ge.pp.presentation.cd.util.GeResources;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeTaxWindow
extends Taxme {
    private static final Logger LOG = LoggerFactory.getLogger(GeTaxWindow.class);
    private final ReleaseAction releaseAction = new ReleaseAction();
    private final FileNewActionDepartDeces departDecesNew = new FileNewActionDepartDeces();
    private final FileOpenActionDepartDeces departDecesOpen = new FileOpenActionDepartDeces();
    private final FileImportActionDepartDeces departDecesImport = new FileImportActionDepartDeces();
    private final FileInfoDepartDeces infoDepartDeces = new FileInfoDepartDeces();
    private final UserDocumentsAction attachDocsAction = new UserDocumentsAction(PdfType.GENERIC);
    private final MenuManager menuFileDepartDeces = new MenuManager(Messages.configurableTranslate((String)"menu.file.departDeces", (Object[])new Object[0]), "menu.file.departDeces");
    private boolean departDeces;

    public int open() {
        GeResources.init();
        new ICTAXXMLDatabaseUpdateAction().run(true);
        return super.open();
    }

    protected MenuManager createMenuManager() {
        MenuManager mgr = super.createMenuManager();
        MenuManager utilMgr = (MenuManager)mgr.find("menu.util");
        utilMgr.appendToGroup("utils.main", (IAction)new ICTAXXMLDatabaseUpdateAction());
        MenuManager fileMgr = (MenuManager)mgr.find("menu.file");
        fileMgr.insertAfter(GePrintAction.class.getName(), (IAction)this.releaseAction);
        this.menuFileDepartDeces.add((IAction)this.infoDepartDeces);
        this.menuFileDepartDeces.add((IAction)this.departDecesNew);
        this.menuFileDepartDeces.add((IAction)this.departDecesOpen);
        this.menuFileDepartDeces.add((IAction)this.departDecesImport);
        fileMgr.insertAfter(GeFileNewAction.class.getName(), (IContributionItem)this.menuFileDepartDeces);
        return mgr;
    }

    protected ToolBarManager createToolBarManager(int style) {
        ToolBarManager tbm = super.createToolBarManager(style);
        tbm.insertAfter(GePrintAction.class.getName(), (IAction)this.releaseAction);
        tbm.insertAfter(ReleaseAction.class.getName(), (IAction)this.attachDocsAction);
        return tbm;
    }

    public void setMenuState() {
        super.setMenuState();
        boolean hasContent = TaxmeController.getInstance().isDeclarationOpen();
        this.releaseAction.setEnabled(hasContent);
        this.attachDocsAction.setEnabled(hasContent);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        TaxmeController ctrl = TaxmeController.getInstance();
        StatusLineManager statusLineManager = this.getStatusLineManager();
        statusLineManager.removeAll();
        assert (statusLineManager != null) : "Status line support was removed from super class.";
        if (ctrl.isDeclarationOpen() && this.departDeces) {
            ctrl.setTitle("taxme.cd.title.departDeces", new Object[0]);
            statusLineManager.add((IContributionItem)new ContributionItem(){

                public void fill(Composite parent) {
                    Label lbl = new Label(parent, 0);
                    lbl.setFont(GuiUtil.getFontRegistry().get("font.disabled"));
                    lbl.setText(Messages.translate((String)"status.line.departDeces", (Object[])new Object[0]));
                    lbl.setForeground(GuiUtil.getColorRegistry().get("font.disabled"));
                }
            });
        }
        statusLineManager.update(true);
        final Browser welcome = this.getWelcome();
        if (welcome != null) {
            welcome.addProgressListener((ProgressListener)new ProgressAdapter(){

                public void completed(ProgressEvent progressEvent) {
                    if (!welcome.execute("setDepartDeces(" + GeTaxWindow.this.departDeces + ");")) {
                        LOG.error("Failed to reset end-of-subjection flag in DOM, assume unset.");
                        GeTaxWindow.this.departDeces = false;
                    }
                }
            });
            new BrowserFunction(welcome, "toggleFinAssujettissement"){

                public Object function(Object[] objects) {
                    Object arg;
                    Boolean departDeces = null;
                    if (objects != null && objects.length > 0 && (arg = objects[0]) instanceof Boolean) {
                        departDeces = (Boolean)arg;
                    }
                    if (departDeces == null) {
                        throw new IllegalStateException("Cannot retrieve boolean argument for method toggleFinAssujettissement().");
                    }
                    GeTaxWindow.this.departDeces = departDeces;
                    LOG.debug("Updated flag \"Fin Assujettissement\" to value: {}", (Object)departDeces);
                    return null;
                }
            };
        }
        return contents;
    }

    public boolean isDepartDeces() {
        return this.departDeces;
    }

    public void setDepartDeces(boolean departDeces) {
        this.departDeces = departDeces;
    }

    public int getDepartDecesSteuerjahr() {
        return ApplicationConfig.getInstance().getJahr() + 1;
    }
}

