/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.CryptoSession;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Environment
extends Enum<Environment> {
    public static final /* enum */ Environment PROD = new Environment();
    public static final /* enum */ Environment DEV = new Environment();
    public static final /* enum */ Environment MOCKED = new Environment();
    private static final Logger LOG;
    public static final String ENV_KEY = "env";
    public static final Environment DEFAULT_ENVIRONMENT;
    private static final /* synthetic */ Environment[] $VALUES;

    public static Environment[] values() {
        return (Environment[])$VALUES.clone();
    }

    public static Environment valueOf(String name) {
        return Enum.valueOf(Environment.class, name);
    }

    public static Environment getCurrentEnvironment() {
        try {
            TaxmeConfig.check();
        }
        catch (RuntimeException e) {
            LOG.info("TaxmeConfig not initialized, assume mocked environment");
            return MOCKED;
        }
        String envName = TaxmeConfig.getString((String)ENV_KEY);
        if (envName == null) {
            return DEFAULT_ENVIRONMENT;
        }
        try {
            return Environment.valueOf(envName);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unknown environment specified in configuration: {}, assume default", (Object)envName);
            return DEFAULT_ENVIRONMENT;
        }
    }

    public static InputStream getUploadPublicKeyStream() {
        switch (Environment.getCurrentEnvironment()) {
            case PROD: 
            case DEV: {
                return CryptoSession.class.getResourceAsStream("afc-key.public");
            }
            case MOCKED: {
                return CryptoSession.class.getResourceAsStream("test-key.public");
            }
        }
        assert (false) : "Unreachable code path";
        return null;
    }

    private static /* synthetic */ Environment[] $values() {
        return new Environment[]{PROD, DEV, MOCKED};
    }

    static {
        $VALUES = Environment.$values();
        LOG = LoggerFactory.getLogger(Environment.class);
        DEFAULT_ENVIRONMENT = PROD;
    }
}

