/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.ge.pp.ictax.ICTAXDataBaseProvider;
import ch.dvbern.tax.ge.pp.ictax.ICTAXXMLDatabaseProvider;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICTAXXMLDatabaseUpdateAction
extends ActionBase {
    private static final Logger LOG = LoggerFactory.getLogger(ICTAXXMLDatabaseUpdateAction.class);

    public ICTAXXMLDatabaseUpdateAction() {
        super("menu.util.update.valor");
    }

    public void run() {
        this.run(false);
    }

    public void run(boolean headless) {
        ICTAXXMLDatabaseProvider xmlDBProvider = null;
        ServiceLoader<ICTAXDataBaseProvider> providers = ServiceLoader.load(ICTAXDataBaseProvider.class);
        for (ICTAXDataBaseProvider provider : providers) {
            if (!(provider instanceof ICTAXXMLDatabaseProvider)) continue;
            xmlDBProvider = (ICTAXXMLDatabaseProvider)provider;
            break;
        }
        if (xmlDBProvider == null) {
            throw new InternalFailureException("Failed to lookup XML database provider.");
        }
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(TaxmeController.getInstance().getShell());
        try {
            UpdateJob job = new UpdateJob(xmlDBProvider);
            dlg.run(true, true, (IRunnableWithProgress)job);
            if (job.updatePerformed) {
                if (!headless) {
                    DialogUtil.showInfoDialog((String)"valorUpdate.action.done", (Object[])new Object[0]);
                }
            } else if (!headless) {
                DialogUtil.showInfoDialog((String)"valorUpdate.action.none", (Object[])new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
            LOG.error("Failed to proceed with the valor update.", (Throwable)e);
            if (e.getCause() instanceof IOException) {
                if (!headless) {
                    DialogUtil.showErrorDialog((String)"valorUpdate.action.error.network", (Object[])new Object[0]);
                }
            } else if (!headless) {
                DialogUtil.showErrorDialog((String)"valorUpdate.action.error", (Object[])new Object[0]);
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Operation cancelled.", (Throwable)e);
        }
    }

    private class UpdateJob
    implements IRunnableWithProgress {
        final ICTAXXMLDatabaseProvider provider;
        volatile boolean updatePerformed = false;

        UpdateJob(ICTAXXMLDatabaseProvider provider) {
            assert (provider != null);
            this.provider = provider;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            Future<Boolean> task = Executors.newSingleThreadExecutor().submit(() -> this.provider.performURLUpdate(monitor, ApplicationConfig.getInstance().getJahr()));
            while (!task.isDone()) {
                try {
                    this.updatePerformed = task.get(1L, TimeUnit.SECONDS);
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e.getCause());
                }
                catch (TimeoutException e) {
                    if (!monitor.isCanceled()) continue;
                    task.cancel(true);
                    throw new InterruptedException();
                }
            }
        }
    }
}

