/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.ge.pp.ictax.ICTAXDataBase;
import ch.dvbern.tax.ge.pp.ictax.ICTAXDataBaseProvider;
import ch.dvbern.tax.ge.pp.ictax.ICTAXXMLDataBase;
import ch.dvbern.tax.ge.pp.ictax.ICTAXXMLMetaData;
import ch.dvbern.tax.ge.pp.online.integration.xml.ictax.UnmarshallHelper;
import ch.dvbern.tax.ge.pp.presentation.cd.util.ZipHelper;
import ch.dvbern.tax.ge.pp.utils.InvalidConfigurationException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICTAXXMLDatabaseProvider
extends ICTAXDataBaseProvider {
    static final String INDEX_DIR_NAME = "db";
    static final String EXCHANGE_RATES_FILE_NAME = "exchangeRate.properties";
    static final String ZIP_FILE_NAME = "ictax.zip";
    private static final Logger LOG = LoggerFactory.getLogger(ICTAXXMLDatabaseProvider.class);
    private static final Path BUNDLED_INDEX_DIR = Paths.get("config/cd/valor_idx", new String[0]);
    private final Map<Integer, ICTAXXMLDataBase> databases = new ConcurrentHashMap<Integer, ICTAXXMLDataBase>();

    @Nullable
    public ICTAXDataBase getICTAXDataBase(int year) {
        ICTAXXMLDataBase db = this.databases.get(year);
        if (db != null) {
            return db;
        }
        List<DBInfo> availableDBs = this.findAvailableDatabases(year);
        DBInfo dbInfo = null;
        ICTAXXMLDataBase database = null;
        for (DBInfo candidate : availableDBs) {
            Directory directory;
            LOG.debug("Loading valor index database from: {}", (Object)candidate.dbPath);
            Map<String, BigDecimal> exchangeRates = this.loadExchangeRates(candidate.dbPath);
            if (exchangeRates == null || (directory = this.loadDirectory(candidate.dbPath)) == null) continue;
            assert (candidate.metaData.getYear() == year);
            try {
                database = new ICTAXXMLDataBase(year, directory, exchangeRates);
                dbInfo = candidate;
                break;
            }
            catch (IOException e) {
                LOG.error("Failed to open Lucene index for: {}", (Object)candidate, (Object)e);
            }
        }
        if (database == null) {
            LOG.info("No XML database available.");
        } else {
            assert (dbInfo != null);
            LOG.info("Selected database: {}", dbInfo);
            this.databases.put(year, database);
        }
        return database;
    }

    boolean performURLUpdate(IProgressMonitor monitor, int year) throws IOException, InterruptedException {
        Path userDatabaseDir;
        URL updateURL;
        assert (monitor != null && year > 0);
        try {
            Object urlString = TaxmeConfig.getString((String)"user.valor.updateURL");
            if (urlString != null && !((String)urlString).endsWith("/")) {
                urlString = (String)urlString + "/";
            }
            updateURL = new URL((String)urlString);
        }
        catch (MalformedURLException e) {
            throw new InvalidConfigurationException("Invalid valor update URL.", (Throwable)e);
        }
        try {
            userDatabaseDir = Paths.get(TaxmeConfig.getUserHome(), new String[0]).resolve(TaxmeConfig.getString((String)"user.valor"));
        }
        catch (InvalidPathException e) {
            throw new InvalidConfigurationException("Invalid valor database update directory.", (Throwable)e);
        }
        monitor.setTaskName(Messages.translate((String)"valorUpdate.task.check", (Object[])new Object[0]));
        ICTAXXMLMetaData md = ICTAXXMLMetaData.load(updateURL);
        if (md.getYear() != year) {
            LOG.info("Ignoring available update {} (not in expected year: {})", (Object)md, (Object)year);
            return false;
        }
        this.checkCancel(monitor);
        List<DBInfo> availableDBs = this.findAvailableDatabases(year);
        if (availableDBs.isEmpty() || availableDBs.get((int)0).metaData.getCreationDate().isBefore((ReadablePartial)md.getCreationDate())) {
            LOG.info("Update available: {}", (Object)md);
            URL archiveURL = new URL(updateURL, ZIP_FILE_NAME);
            String dateStr = UnmarshallHelper.printDate((LocalDate)md.getCreationDate());
            Path tmpArchiveFile = Files.createTempFile("getax_valor_update_", ".zip", new FileAttribute[0]);
            LOG.debug("Starting download from {}", (Object)updateURL);
            URLConnection connection = archiveURL.openConnection();
            try {
                boolean bl;
                block30: {
                    OutputStream os = Files.newOutputStream(tmpArchiveFile, new OpenOption[0]);
                    try {
                        try (InputStream is = connection.getInputStream();){
                            int readCount;
                            int fileSize = connection.getContentLength();
                            monitor.beginTask(Messages.translate((String)"valorUpdate.task.download", (Object[])new Object[]{dateStr}), fileSize > 0 ? fileSize : -1);
                            byte[] buffer = new byte[8192];
                            while ((readCount = is.read(buffer)) != -1) {
                                this.checkCancel(monitor);
                                os.write(buffer, 0, readCount);
                                monitor.worked(readCount);
                            }
                        }
                        FileUtils.deleteQuietly((File)userDatabaseDir.toFile());
                        Files.createDirectory(userDatabaseDir, new FileAttribute[0]);
                        ZipHelper.unzip(tmpArchiveFile, userDatabaseDir);
                        md.store(userDatabaseDir);
                        ICTAXXMLDataBase db = this.databases.remove(year);
                        if (db != null) {
                            db.close();
                        }
                        LOG.info("Valor database successfully updated.");
                        bl = true;
                        if (os == null) break block30;
                    }
                    catch (Throwable throwable) {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    os.close();
                }
                return bl;
            }
            finally {
                try {
                    Files.delete(tmpArchiveFile);
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private void checkCancel(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException("Operation cancelled.");
        }
    }

    private List<DBInfo> findAvailableDatabases(int year) {
        assert (year > 0);
        ArrayList<DBInfo> availableDBs = new ArrayList<DBInfo>();
        ICTAXXMLMetaData bundledMetaData = this.loadMetaData(BUNDLED_INDEX_DIR, year);
        if (bundledMetaData != null) {
            availableDBs.add(new DBInfo(BUNDLED_INDEX_DIR, bundledMetaData));
        }
        try {
            Path userIndexDir = Paths.get(TaxmeConfig.getUserHome(), new String[0]).resolve(TaxmeConfig.getString((String)"user.valor"));
            ICTAXXMLMetaData md = this.loadMetaData(userIndexDir, year);
            if (md != null) {
                availableDBs.add(new DBInfo(userIndexDir, md));
            }
        }
        catch (InvalidPathException e) {
            LOG.error("Ignoring invalid user valor index directory path.", (Throwable)e);
        }
        Collections.sort(availableDBs, (db1, db2) -> db2.metaData.getCreationDate().compareTo((ReadablePartial)db1.metaData.getCreationDate()));
        return availableDBs;
    }

    private Map<String, BigDecimal> loadExchangeRates(Path dbPath) {
        HashMap<String, BigDecimal> hashMap;
        assert (dbPath != null);
        Path exchangeRateFile = dbPath.resolve(INDEX_DIR_NAME).resolve(EXCHANGE_RATES_FILE_NAME);
        HashMap<String, BigDecimal> exchangeRateYearEndMap = new HashMap<String, BigDecimal>(160);
        BufferedInputStream is = new BufferedInputStream(Files.newInputStream(exchangeRateFile, new OpenOption[0]));
        try {
            Properties exchangeRateProps = new Properties();
            exchangeRateProps.load(is);
            for (Map.Entry<Object, Object> entry : exchangeRateProps.entrySet()) {
                exchangeRateYearEndMap.put((String)entry.getKey(), new BigDecimal((String)entry.getValue()));
            }
            hashMap = exchangeRateYearEndMap;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.error("Failed to parse year-end exchange rates: {}", (Object)exchangeRateFile, (Object)e);
                return null;
            }
        }
        ((InputStream)is).close();
        return hashMap;
    }

    private Directory loadDirectory(Path dbPath) {
        assert (dbPath != null);
        try {
            return new SimpleFSDirectory(dbPath.resolve(INDEX_DIR_NAME).toFile());
        }
        catch (IOException e) {
            LOG.error("Failed to load Lucene index from: {}", (Object)dbPath, (Object)e);
            return null;
        }
    }

    private ICTAXXMLMetaData loadMetaData(Path valorDir, int year) {
        assert (valorDir != null && year > 0);
        if (!Files.isDirectory(valorDir, new LinkOption[0])) {
            LOG.debug("Ignoring non-existing location: {}", (Object)valorDir);
            return null;
        }
        try {
            ICTAXXMLMetaData md = ICTAXXMLMetaData.load(valorDir);
            if (md.getYear() != year) {
                LOG.debug("Ignoring database {} (expected year: {}).", (Object)md, (Object)year);
                return null;
            }
            LOG.debug("Found available database: {}", (Object)md);
            return md;
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.error("Failed to parse meta-data file.", (Throwable)e);
            return null;
        }
    }

    private static class DBInfo {
        final Path dbPath;
        final ICTAXXMLMetaData metaData;

        DBInfo(Path dbPath, ICTAXXMLMetaData metaData) {
            assert (dbPath != null && metaData != null);
            this.dbPath = dbPath;
            this.metaData = metaData;
        }

        public String toString() {
            return this.dbPath + " => " + this.metaData;
        }
    }
}

